/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class RoutineSchema
implements SchemaObject {
    Routine[] routines = Routine.emptyArray;
    int routineType;
    private HsqlNameManager.HsqlName name;

    public RoutineSchema(int n, HsqlNameManager.HsqlName hsqlName) {
        this.routineType = n;
        this.name = hsqlName;
    }

    public int getType() {
        return this.routineType;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        for (int i = 0; i < this.routines.length; ++i) {
            orderedHashSet.addAll(this.routines[i].getReferences());
        }
        return orderedHashSet;
    }

    public OrderedHashSet getComponents() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        orderedHashSet.addAll(this.routines);
        return orderedHashSet;
    }

    public void compile(Session session, SchemaObject schemaObject) {
    }

    public String getSQL() {
        return null;
    }

    public long getChangeTimestamp() {
        return 0L;
    }

    public String[] getSQLArray() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = 0; i < this.routines.length; ++i) {
            hsqlArrayList.add(this.routines[i].getSQL());
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public void addSpecificRoutine(Database database, Routine routine) {
        int n = routine.getParameterSignature();
        Type[] typeArray = routine.getParameterTypes();
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != typeArray.length) continue;
            if (this.routineType == 17) {
                throw Error.error(5605);
            }
            if (this.routines[i].isAggregate() != routine.isAggregate()) {
                throw Error.error(5605);
            }
            boolean bl = true;
            for (int j = 0; j < typeArray.length; ++j) {
                if (this.routines[i].parameterTypes[j].equals(typeArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            throw Error.error(5605);
        }
        if (routine.getSpecificName() == null) {
            HsqlNameManager.HsqlName hsqlName = database.nameManager.newSpecificRoutineName(this.name);
            routine.setSpecificName(hsqlName);
        } else {
            routine.getSpecificName().parent = this.name;
            routine.getSpecificName().schema = this.name.schema;
        }
        routine.setName(this.name);
        routine.routineSchema = this;
        this.routines = (Routine[])ArrayUtil.resizeArray(this.routines, this.routines.length + 1);
        this.routines[this.routines.length - 1] = routine;
    }

    public void removeSpecificRoutine(Routine routine) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i] != routine) continue;
            this.routines = (Routine[])ArrayUtil.toAdjustedArray(this.routines, null, i, -1);
            break;
        }
    }

    public Routine[] getSpecificRoutines() {
        return this.routines;
    }

    public Routine getSpecificRoutine(Type[] typeArray) {
        int n;
        int n2 = -1;
        block0: for (int i = 0; i < this.routines.length; ++i) {
            int n3;
            int n4;
            int n5;
            n = 0;
            if (this.routines[i].isAggregate() && typeArray.length == 1) {
                if (typeArray[0] == null) {
                    return this.routines[i];
                }
                n5 = typeArray[0].precedenceDegree(this.routines[i].parameterTypes[0]);
                if (n5 < -128) {
                    if (n2 == -1 || (n4 = typeArray[0].precedenceDegree(this.routines[n2].parameterTypes[0])) == (n3 = typeArray[0].precedenceDegree(this.routines[i].parameterTypes[0])) || n3 >= n4) continue;
                    n2 = i;
                    continue;
                }
                if (n5 == 0) {
                    return this.routines[i];
                }
                n2 = i;
                continue;
            }
            if (this.routines[i].parameterTypes.length != typeArray.length) continue;
            if (typeArray.length == 0) {
                return this.routines[i];
            }
            for (n5 = 0; n5 < typeArray.length; ++n5) {
                if (typeArray[n5] == null) continue;
                n4 = typeArray[n5].precedenceDegree(this.routines[i].parameterTypes[n5]);
                if (n4 < -128) continue block0;
                if (n4 != 0 || n != n5) continue;
                n = n5 + 1;
            }
            if (n == typeArray.length) {
                return this.routines[i];
            }
            if (n2 == -1) {
                n2 = i;
                continue;
            }
            for (n5 = 0; n5 < typeArray.length; ++n5) {
                if (typeArray[n5] == null || (n4 = typeArray[n5].precedenceDegree(this.routines[n2].parameterTypes[n5])) == (n3 = typeArray[n5].precedenceDegree(this.routines[i].parameterTypes[n5]))) continue;
                if (n3 >= n4) continue block0;
                n2 = i;
                continue block0;
            }
        }
        if (n2 < 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name.getSchemaQualifiedStatementName());
            stringBuffer.append("(");
            for (n = 0; n < typeArray.length; ++n) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(typeArray[n].getNameString());
            }
            stringBuffer.append(")");
            throw Error.error(5609, stringBuffer.toString());
        }
        return this.routines[n2];
    }

    public Routine getSpecificRoutine(int n) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != n) continue;
            return this.routines[i];
        }
        throw Error.error(5501);
    }

    public boolean isAggregate() {
        return this.routines[0].isAggregate;
    }
}

