/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.store.ValuePool;

public class ExpressionAggregate
extends Expression {
    boolean isDistinctAggregate;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionAggregate(int n, boolean bl, Expression expression) {
        super(n);
        this.nodes = new Expression[1];
        this.isDistinctAggregate = bl;
        this.nodes[0] = expression;
    }

    boolean isSelfAggregate() {
        return true;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 71: {
                stringBuffer.append(' ').append("COUNT").append('(');
                break;
            }
            case 72: {
                stringBuffer.append(' ').append("SUM").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 73: {
                stringBuffer.append(' ').append("MIN").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 74: {
                stringBuffer.append(' ').append("MAX").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 75: {
                stringBuffer.append(' ').append("AVG").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 76: {
                stringBuffer.append(' ').append("EVERY").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 77: {
                stringBuffer.append(' ').append("SOME").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 78: {
                stringBuffer.append(' ').append("STDDEV_POP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 79: {
                stringBuffer.append(' ').append("STDDEV_SAMP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 80: {
                stringBuffer.append(' ').append("VAR_POP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 81: {
                stringBuffer.append(' ').append("VAR_SAMP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 71: {
                stringBuffer.append("COUNT").append(' ');
                break;
            }
            case 72: {
                stringBuffer.append("SUM").append(' ');
                break;
            }
            case 73: {
                stringBuffer.append("MIN").append(' ');
                break;
            }
            case 74: {
                stringBuffer.append("MAX").append(' ');
                break;
            }
            case 75: {
                stringBuffer.append("AVG").append(' ');
                break;
            }
            case 76: {
                stringBuffer.append("EVERY").append(' ');
                break;
            }
            case 77: {
                stringBuffer.append("SOME").append(' ');
                break;
            }
            case 78: {
                stringBuffer.append("STDDEV_POP").append(' ');
                break;
            }
            case 79: {
                stringBuffer.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 80: {
                stringBuffer.append("VAR_POP").append(' ');
                break;
            }
            case 81: {
                stringBuffer.append("VAR_SAMP").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            stringBuffer.append(" arg=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVariableArray, int n, HsqlList hsqlList, boolean bl) {
        HsqlList hsqlList2 = this.condition.resolveColumnReferences(session, rangeVariableArray, n, null, false);
        if (hsqlList2 != null) {
            ExpressionColumn.checkColumnsResolved(hsqlList2);
        }
        if (hsqlList == null) {
            hsqlList = new ArrayListIdentity();
        }
        hsqlList.add(this);
        return hsqlList;
    }

    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate && this.nodes[0].dataType.isLobType()) {
            throw Error.error(5534);
        }
        this.dataType = SetFunction.getType(this.opType, this.nodes[0].dataType);
        this.condition.resolveTypes(session, null);
    }

    public boolean equals(Expression expression) {
        if (!(expression instanceof ExpressionAggregate)) {
            return false;
        }
        ExpressionAggregate expressionAggregate = (ExpressionAggregate)expression;
        if (this.opType == expression.opType && this.exprSubType == expression.exprSubType && this.isDistinctAggregate == expressionAggregate.isDistinctAggregate && this.condition.equals(expressionAggregate.condition)) {
            return super.equals(expression);
        }
        return false;
    }

    public Object updateAggregatingValue(Session session, Object object) {
        if (!this.condition.testCondition(session)) {
            return object;
        }
        if (object == null) {
            object = new SetFunction(this.opType, this.nodes[0].dataType, this.isDistinctAggregate);
        }
        Integer n = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        ((SetFunction)object).add(session, n);
        return object;
    }

    public Object getAggregatedValue(Session session, Object object) {
        if (object == null) {
            return this.opType == 71 ? ValuePool.INTEGER_0 : null;
        }
        return ((SetFunction)object).getValue(session);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }
}

