/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hpccsystems.ws.client.utils.DataSingleton;

public class CollectionDelta {
    private ArrayList<DataSingleton> before;
    protected String cause;
    protected ArrayList<DataSingleton> added;
    protected ArrayList<DataSingleton> unchanged;
    protected ArrayList<DataSingleton> removed;

    public CollectionDelta(String cause) {
        this.cause = cause;
        this.before = new ArrayList();
    }

    public <T extends DataSingleton> CollectionDelta(String cause, Collection<T> before) {
        this.cause = cause;
        this.before = new ArrayList<T>(before);
    }

    public <T extends DataSingleton> CollectionDelta calcChanges(T[] after) {
        return this.calcChanges(new ArrayList<T>(Arrays.asList(after)));
    }

    public <T extends DataSingleton> CollectionDelta calcChanges(Collection<T> after) {
        new ArrayList<T>(after);
        this.added = new ArrayList();
        this.unchanged = new ArrayList();
        this.removed = new ArrayList<DataSingleton>(this.before);
        for (DataSingleton item : after) {
            if (this.removed.contains(item)) {
                this.unchanged.add(item);
                this.removed.remove(item);
                continue;
            }
            this.added.add(item);
        }
        return this;
    }

    public boolean hasChanged() {
        return !this.removed.isEmpty() || !this.added.isEmpty();
    }

    public boolean exists(DataSingleton item) {
        return this.added.contains(item) || this.unchanged.contains(item);
    }

    public String getCause() {
        return this.cause;
    }

    public boolean removeContains(DataSingleton item) {
        return this.removed.contains(item);
    }

    public ArrayList<DataSingleton> getAdded() {
        return this.added;
    }
}

