/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.hpccsystems.ws.client.utils.Utils;

public class Axis2ADBStubWrapperMaker {
    public static final String version = "1.8";
    private static String elementcommentstart = "/**\n * Generated Axis2 ADB stub class wrapper\n * WrapperMaker version: %s\n * Class name: %s\n * Wraps class: %s\n * Output package : %s\n * Service version: %s\n */\n";
    private String crheader = "\n/*******************************************************************************\n * HPCC SYSTEMS software Copyright (C) 2021 HPCC Systems.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *******************************************************************************/\n";
    private String targetPackage = null;
    private String targetWsService = null;
    private String targetWsServiceVer = null;
    private String generatedPackageToWrap = null;
    List<String> imports = null;
    List<SimpleField> fields = null;
    private String outputDir;

    public Axis2ADBStubWrapperMaker(String outputdir, String generatedPackageToWrap, String targetPackage, String targetWsServiceName, String targetWsVer) {
        this.generatedPackageToWrap = generatedPackageToWrap;
        this.targetPackage = targetPackage + (targetWsServiceName == null || targetWsServiceName.isEmpty() ? "" : "." + targetWsServiceName.replaceFirst("_", "").toLowerCase());
        this.targetWsService = targetWsServiceName;
        this.targetWsServiceVer = targetWsVer;
        this.outputDir = outputdir;
    }

    public void wrapClass(Class<?> cls) {
        Field[] fields;
        this.imports = new ArrayList<String>();
        this.fields = new ArrayList<SimpleField>();
        String packagedeclaration = "package " + this.targetPackage + ";\n\n";
        String wrappedclassname = cls.getSimpleName() + "Wrapper";
        System.out.println(cls.getName() + " to be wrapped as: " + this.targetPackage + "." + this.targetWsService + "." + wrappedclassname);
        String fullpath = this.outputDir + File.separator + this.targetPackage.replace(".", File.separator);
        File file = new File(fullpath);
        if (!file.exists() && !file.mkdirs()) {
            System.out.println("Failed to create directory: " + fullpath);
            System.exit(-1);
        }
        fullpath = fullpath + File.separator + wrappedclassname + ".java";
        System.out.println("Attempting to create file: " + fullpath);
        file = new File(fullpath);
        try {
            if (!file.createNewFile()) {
                System.out.println("Warning: Target file already exists: " + fullpath);
            }
        }
        catch (IOException e1) {
            System.out.println("Warning: Could not create file: " + fullpath);
            System.out.println(e1.getLocalizedMessage());
            e1.printStackTrace();
            System.exit(-1);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            System.out.println("Warning: Could not filewriter for : " + fullpath);
            System.out.println(e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        for (Field field : fields = cls.getDeclaredFields()) {
            this.processField(field);
        }
        String importdeclarations = this.generateImports();
        String fielddeclarations = this.generateFieldDeclarations();
        String constructors = this.generateConstructors(cls);
        String gettersettermethods = this.createGetterAndSetter();
        String classcomment = String.format(elementcommentstart, version, wrappedclassname, cls.getName(), this.targetPackage, this.targetWsServiceVer);
        String classcontent = packagedeclaration + "\n" + this.crheader + importdeclarations + classcomment + "public class " + wrappedclassname + "\n{\n" + fielddeclarations + "\n" + constructors + "\n" + gettersettermethods + "\n}";
        try {
            writer.write(classcontent);
        }
        catch (IOException e) {
            System.out.println("Warning: Could not write to file: " + fullpath);
            System.out.println(e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Warning: Could not close filewritter: " + fullpath);
            e.printStackTrace();
        }
    }

    private String generateImports() {
        String importslist = "";
        for (String importname : this.imports) {
            importslist = importslist + "import " + importname + ";\n";
        }
        return importslist + "\n";
    }

    private String generateConstructors(Class<?> baseclass) {
        Constructor<?>[] constructors2;
        String wrappedname = baseclass.getSimpleName() + "Wrapper";
        String constructors = "    public " + wrappedname + "() {}\n\n";
        String rawmethobody = "";
        if (this.fields.size() > 0) {
            constructors = constructors + "    public " + wrappedname + "( " + baseclass.getTypeName() + " " + baseclass.getSimpleName().toLowerCase() + ")\n    {\n        copy( " + baseclass.getSimpleName().toLowerCase() + " );\n    }\n";
            String copymethobody = "";
            String fullctrbody = "";
            String paramlist = "";
            String tostringstr = "\n    @Override\n    public String toString()\n    {\n        return \"" + wrappedname + " [\" + ";
            constructors = constructors + "    public " + wrappedname + "( ";
            Iterator<SimpleField> iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                Method[] methods;
                SimpleField simpleField = iterator.next();
                String simplename = simpleField.getName();
                String capitalized = Character.toUpperCase(simplename.charAt(0)) + simplename.substring(1);
                paramlist = paramlist + simpleField.getActualType() + " _" + simplename;
                if (iterator.hasNext()) {
                    paramlist = paramlist + ", ";
                }
                tostringstr = tostringstr + "\"" + simplename + " = \" + " + simpleField.getSafeName();
                if (iterator.hasNext()) {
                    tostringstr = tostringstr + " + \", \" + ";
                }
                fullctrbody = fullctrbody + "        this." + simpleField.getSafeName() + " = _" + simplename + ";\n";
                if (simpleField.isContainer) {
                    copymethobody = copymethobody + "        if (raw.get" + capitalized + "() != null" + (simpleField.isESPStringArray() ? " && raw.get" + capitalized + "().getItem() != null" : "") + ")\n        {\n";
                    copymethobody = copymethobody + "            this." + simpleField.getSafeName() + " = new Array" + simpleField.getActualType() + "();\n";
                    copymethobody = simpleField.isESPStringArray() ? copymethobody + "            for ( int i = 0; i < raw.get" + capitalized + "().getItem().length; i++)\n" : copymethobody + "            for ( int i = 0; i < raw.get" + capitalized + "().length; i++)\n";
                    copymethobody = copymethobody + "            {\n                this." + simpleField.getSafeName() + ".add(new " + simpleField.getBaseType();
                    if (simpleField.isWrapped()) {
                        copymethobody = copymethobody + "Wrapper";
                    }
                    copymethobody = simpleField.isESPStringArray() ? copymethobody + "(raw.get" + capitalized + "().getItem()[i]));\n            }\n        }" : copymethobody + "(raw.get" + capitalized + "()[i]));\n            }\n        }";
                    rawmethobody = rawmethobody + "        if (this." + simpleField.getSafeName() + "!= null)\n        {\n";
                    rawmethobody = simpleField.isWrapped() ? rawmethobody + "            " + baseclass.getPackage().getName() + "." + simpleField.getBaseType() + "[] arr = new " + baseclass.getPackage().getName() + "." + simpleField.getBaseType() + "[this." + simpleField.getSafeName() + ".size()];\n" : (simpleField.isESPStringArray() ? rawmethobody + "            EspStringArray arr = new EspStringArray();\n" : rawmethobody + "            " + simpleField.getPackagename() + "." + simpleField.getBaseType() + "[] arr = new " + simpleField.getPackagename() + "." + simpleField.getBaseType() + "[this." + simpleField.getSafeName() + ".size()];\n");
                    rawmethobody = rawmethobody + "            for ( int i = 0; i < this." + simpleField.getSafeName() + ".size(); i++)\n";
                    rawmethobody = simpleField.isESPStringArray() ? rawmethobody + "            {\n                arr.addItem(this." + simpleField.getSafeName() + ".get(i));\n            }" : rawmethobody + "            {\n                arr[i] = this." + simpleField.getSafeName() + ".get(i) " + (simpleField.isWrapped() ? ".getRaw()" : "") + ";\n            }";
                    rawmethobody = rawmethobody + "\n            raw.set" + capitalized + "(arr);\n        }\n";
                    continue;
                }
                if (simpleField.isWrapped) {
                    copymethobody = copymethobody + "        if (raw.get" + capitalized + "() != null)\n            this." + simpleField.getSafeName() + " = new " + simpleField.getActualType() + "( raw.get" + capitalized + "());\n";
                    rawmethobody = rawmethobody + "        if (" + simpleField.getSafeName() + " != null)\n            raw.set" + capitalized + "( " + simpleField.getSafeName() + ".getRaw());\n";
                    continue;
                }
                boolean foundget = false;
                boolean foundset = false;
                for (Method method : methods = baseclass.getMethods()) {
                    if (method.getName().equals("get" + capitalized)) {
                        foundget = true;
                    }
                    if (!method.getName().equals("set" + capitalized)) continue;
                    foundset = true;
                }
                copymethobody = foundget ? copymethobody + "        this." + simpleField.getSafeName() + " = raw.get" + capitalized + "();\n" : copymethobody + "//Warning raw class does not provide expected method: get" + capitalized + "();\n";
                if (foundset) {
                    rawmethobody = rawmethobody + "        raw.set" + capitalized + "( " + simpleField.getSafeName() + ");\n";
                    continue;
                }
                rawmethobody = rawmethobody + "//Warning raw class doe not provide expected method: set" + capitalized + "(" + simpleField.getName() + ");\n";
            }
            constructors = constructors + paramlist + " )\n    {\n" + fullctrbody + "\n    }\n\n";
            constructors = constructors + "    private void copy( " + baseclass.getTypeName() + " raw )\n    {\n";
            constructors = constructors + "        if (raw == null)\n            return;\n\n";
            constructors = constructors + copymethobody + "\n    }\n";
            constructors = constructors + tostringstr + " + \"]\";\n    }\n";
        }
        boolean empyconstructorfound = false;
        for (Constructor<?> constructor : constructors2 = baseclass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            empyconstructorfound = true;
            break;
        }
        constructors = constructors + "    public " + baseclass.getTypeName() + " getRaw()\n    {\n        " + baseclass.getTypeName() + " raw = ";
        constructors = empyconstructorfound ? constructors + "new " + baseclass.getTypeName() + "();\n" : constructors + "null;\n //WARNING base class does not provide expected default constructor";
        constructors = constructors + rawmethobody + "        return raw;\n    }\n";
        return constructors;
    }

    private String generateFieldDeclarations() {
        String fielddeclarations = "";
        for (SimpleField simpleField : this.fields) {
            fielddeclarations = fielddeclarations + "    " + simpleField.getActualDeclaration();
        }
        return fielddeclarations;
    }

    public void processField(Field field) {
        String fieldname = field.getName();
        if (!(Modifier.isStatic(field.getModifiers()) || Modifier.isAbstract(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || fieldname.equals("MY_QNAME") || fieldname.equalsIgnoreCase("serialVersionUID"))) {
            Package package1;
            if (fieldname.startsWith("local")) {
                if (fieldname.endsWith("Tracker")) {
                    return;
                }
                fieldname = fieldname.substring(5);
                fieldname = Character.toLowerCase(fieldname.charAt(0)) + fieldname.substring(1);
            }
            SimpleField sfield = new SimpleField(fieldname);
            this.typeDeclaration(field.getType(), sfield);
            this.fields.add(sfield);
            Class<?> type = field.getType();
            if (!type.isPrimitive() && (package1 = type.getPackage()) != null) {
                String fieldpackagename = type.getPackage().getName();
                if (type.getSimpleName().equals("EspStringArray")) {
                    sfield.setESPStringArray(true);
                    sfield.setWrapped(false);
                } else if (this.generatedPackageToWrap.equals(fieldpackagename)) {
                    sfield.setWrapped(true);
                    fieldpackagename = this.targetPackage;
                } else if (!fieldpackagename.startsWith("java.lang") && !this.imports.contains(fieldpackagename + "." + type.getSimpleName())) {
                    this.imports.add(fieldpackagename + "." + type.getSimpleName());
                }
            }
        }
    }

    private String createGetterAndSetter() {
        String settergetter = "";
        if (this.fields.size() > 0) {
            for (SimpleField simpleField : this.fields) {
                String simplename = simpleField.getName();
                String capitalized = Character.toUpperCase(simplename.charAt(0)) + simplename.substring(1);
                settergetter = settergetter + "\n    public void set" + capitalized + "( " + simpleField.getActualType() + " _" + simplename + " )\n    {\n        this." + simpleField.getSafeName() + " = _" + simplename + ";\n    }";
                settergetter = settergetter + "\n    public " + simpleField.getActualType() + " get" + capitalized + "( )\n    {\n        return this." + simpleField.getSafeName() + ";\n    }";
            }
        }
        return settergetter;
    }

    private void typeDeclaration(Class<?> type, SimpleField sfield) {
        Package package1;
        String fieldpackagename = null;
        if (!type.isPrimitive() && (package1 = type.getPackage()) != null) {
            fieldpackagename = type.getPackage().getName();
            if (type.getSimpleName().equals("EspStringArray")) {
                sfield.setESPStringArray(true);
                sfield.setWrapped(false);
            } else if (this.generatedPackageToWrap.equals(fieldpackagename)) {
                fieldpackagename = this.targetPackage;
                sfield.setWrapped(true);
            } else if (!fieldpackagename.startsWith("java.lang") && !this.imports.contains(fieldpackagename + "." + type.getSimpleName())) {
                this.imports.add(fieldpackagename + "." + type.getSimpleName());
            }
        }
        sfield.setPackagename(fieldpackagename);
        boolean isarr = type.isArray();
        if (isarr || type.getSimpleName().equals("EspStringArray")) {
            sfield.setContainer(true);
            if (!this.imports.contains("java.util.List")) {
                this.imports.add("java.util.List");
            }
            if (!this.imports.contains("java.util.ArrayList")) {
                this.imports.add("java.util.ArrayList");
            }
            if (type.getSimpleName().equals("EspStringArray")) {
                this.typeDeclaration(String.class, sfield);
                if (!this.imports.contains(fieldpackagename + "." + type.getSimpleName())) {
                    this.imports.add(fieldpackagename + "." + type.getSimpleName());
                }
            } else {
                this.typeDeclaration(type.getComponentType(), sfield);
            }
        } else {
            sfield.setType(type.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Class<?> getClassFromPackage(String packageName, String targetClassName) {
        String[] classPathEntries;
        System.out.println(System.getProperty("java.class.path"));
        String path = packageName.replace('.', File.separatorChar);
        for (String classpathEntry : classPathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            if (classpathEntry.endsWith(".jar")) {
                System.out.println("Attempting to load: " + classpathEntry);
                ZipInputStream zip = null;
                try {
                    zip = new ZipInputStream(new FileInputStream(classpathEntry));
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                            String className = entry.getName().replace('/', '.');
                            int maxClassLength = (className = className.substring(0, className.length() - 6)).length();
                            if (maxClassLength > packageName.length()) {
                                maxClassLength = packageName.length();
                            }
                            if (className.substring(0, maxClassLength).equals(packageName) && className.equalsIgnoreCase(targetClassName)) {
                                Class<?> clazz = Class.forName(className);
                                return clazz;
                            }
                        }
                        entry = zip.getNextEntry();
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    continue;
                }
                finally {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException e) {
                            System.out.println("Warning: Issue closing zip inputstream");
                        }
                    }
                }
            }
            try {
                File base = new File(classpathEntry + File.separatorChar + path);
                for (File file : base.listFiles()) {
                    String name = file.getName();
                    if (!name.endsWith(".class") || !(name = name.substring(0, name.length() - 6)).equalsIgnoreCase(targetClassName)) continue;
                    return Class.forName(packageName + "." + name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Class<?>> getClassesInPackage(String packageName) {
        String[] classPathEntries;
        System.out.println(System.getProperty("java.class.path"));
        String path = packageName.replace('.', File.separatorChar);
        ArrayList classes = new ArrayList();
        for (String classpathEntry : classPathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            if (classpathEntry.endsWith(".jar")) {
                System.out.println("Attempting to load: " + classpathEntry);
                ZipInputStream zip = null;
                try {
                    zip = new ZipInputStream(new FileInputStream(classpathEntry));
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                            String className = entry.getName().replace('/', '.');
                            int maxClassLength = (className = className.substring(0, className.length() - 6)).length();
                            if (maxClassLength > packageName.length()) {
                                maxClassLength = packageName.length();
                            }
                            if (className.substring(0, maxClassLength).equals(packageName)) {
                                classes.add(Class.forName(className));
                            }
                        }
                        entry = zip.getNextEntry();
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    continue;
                }
                finally {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException e) {
                            System.out.println("Warning: Issue closing zip inputstream");
                        }
                    }
                }
            }
            try {
                File base = new File(classpathEntry + File.separatorChar + path);
                for (File file : base.listFiles()) {
                    String name = file.getName();
                    if (!name.endsWith(".class")) continue;
                    name = name.substring(0, name.length() - 6);
                    classes.add(Class.forName(packageName + "." + name));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classes;
    }

    public static boolean isMethodOverrriden(Method myMethod) {
        Class<?> declaringClass = myMethod.getDeclaringClass();
        if (declaringClass.equals(Object.class)) {
            return false;
        }
        try {
            declaringClass.getSuperclass().getMethod(myMethod.getName(), myMethod.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static void printUsage() {
        String usage = "Generates wrapper classes based off Axis2 ADB generated stub\n\nUsage: WrapperMaker parameterstargetpackage=<packageName> outputdir=<outputdirname> outputpackage=<outputpackagename> servicename=<nameofservicestub>\n\n\nParameters:\ntargetpackage   - The Axis2 ADB stub package to wrap\nservicename     - The name of the WebService associated with the Axis Stub package\noutputdir       - The directory on which the wrapped classes will be written\noutputpackage   - The base package name on which the wrapped classes exist - it is postfixed with the service name\n\nExample: WrapperMaker parameterstargetpackage=org.hpccsystems.ws.client.gen.axis2.wsfileio.latest \\\n                      outputdir=C:\\project\\src\\main\\java outputpackage=org.hpccsystems.ws.client.wrappers servicename=<nameofservicestub>";
        System.out.println(usage);
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        String outputdir;
        String generatedPackageToWrap;
        String targetWsServiceName;
        Properties argsprops = new Properties();
        for (String arg : args) {
            String[] split = arg.split("=");
            if (split.length == 2) {
                argsprops.setProperty(split[0].trim(), split[1].trim());
                continue;
            }
            System.out.println("Ignored input param: " + arg);
        }
        String targetPackage = argsprops.getProperty("outputpackage");
        if (targetPackage == null || targetPackage.isEmpty()) {
            System.out.println("Error: Missing parameter: 'outputpackage'\n\n");
            Axis2ADBStubWrapperMaker.printUsage();
        }
        if ((targetWsServiceName = argsprops.getProperty("servicename")) == null || targetWsServiceName.isEmpty()) {
            System.out.println("Error: Missing parameter: 'servicename'\n\n");
            Axis2ADBStubWrapperMaker.printUsage();
        }
        if ((generatedPackageToWrap = argsprops.getProperty("targetpackage")) == null || generatedPackageToWrap.isEmpty()) {
            System.out.println("Error: Missing parameter: 'targetpackage'\n\n");
            Axis2ADBStubWrapperMaker.printUsage();
        }
        if ((outputdir = argsprops.getProperty("outputdir")) == null || outputdir.isEmpty()) {
            System.out.println("Error: Missing parameter: 'outputdir'\n\n");
            Axis2ADBStubWrapperMaker.printUsage();
        }
        System.out.println("WraperMaker v1.8: wrapping '" + targetWsServiceName + "' from generated Stub package '" + generatedPackageToWrap + "'");
        Class<?> targetStubClass = Axis2ADBStubWrapperMaker.getClassFromPackage(generatedPackageToWrap, targetWsServiceName + "Stub");
        if (targetStubClass == null) {
            System.out.println("Alert! Could not find '" + generatedPackageToWrap + "." + targetWsServiceName + "Stub'");
            return;
        }
        String serviceVer = "unknown";
        Object wsStub = targetStubClass.newInstance();
        if (wsStub == null) {
            System.out.println("Alert! Could not determine service version due to error while instantiating '" + generatedPackageToWrap + "." + targetWsServiceName + "Stub'");
            return;
        }
        ServiceClient servClient = (ServiceClient)targetStubClass.getMethod("_getServiceClient", new Class[0]).invoke(wsStub, new Object[0]);
        if (servClient == null) {
            System.out.println("Alert! Could not determine service version due to error invoking '" + generatedPackageToWrap + "." + targetWsServiceName + "Stub._getServiceClient()'");
            return;
        }
        Options options = servClient.getOptions();
        if (options == null) {
            System.out.println("Alert! Could not determine service version due to error fetching '" + targetWsServiceName + "Stub._getServiceClient().options()'");
            return;
        }
        serviceVer = Utils.parseVersionFromWSDLURL(options.getTo().getAddress());
        System.out.println("Found service version: " + serviceVer);
        Axis2ADBStubWrapperMaker wrapperMaker = new Axis2ADBStubWrapperMaker(outputdir, generatedPackageToWrap, targetPackage, targetWsServiceName, serviceVer);
        List<Class<?>> classesInPackage = Axis2ADBStubWrapperMaker.getClassesInPackage(generatedPackageToWrap);
        if (classesInPackage.size() > 0) {
            for (Class<?> cls : classesInPackage) {
                if (cls.getDeclaringClass() != null || cls.getSimpleName().equalsIgnoreCase(targetWsServiceName + "Stub") || cls.getSimpleName().equalsIgnoreCase(targetWsServiceName) || cls.getSimpleName().equalsIgnoreCase("String") || cls.getSimpleName().equalsIgnoreCase("ExtensionMapper") || cls.getSimpleName().equalsIgnoreCase("EspStringArray")) continue;
                wrapperMaker.wrapClass(cls);
            }
            System.out.println("Finsished wrapping stub classes from package: " + generatedPackageToWrap + "!\n");
            System.out.println("Confirm contents of: " + outputdir + File.separator + targetPackage);
        } else {
            System.out.println("Could not find any classes in package: " + generatedPackageToWrap + "\n");
        }
    }

    class SimpleField {
        String type;
        String packagename;
        String name;
        boolean isContainer = false;
        boolean isWrapped = false;
        boolean isESPStringArray = false;

        public SimpleField(String name) {
            this.packagename = null;
            this.type = null;
            this.name = name;
        }

        public SimpleField(String packagename, String type, String name, boolean iswrapped) {
            this.packagename = packagename;
            this.type = type;
            this.name = name;
        }

        public boolean isESPStringArray() {
            return this.isESPStringArray;
        }

        public void setESPStringArray(boolean isESPStringArray) {
            this.isESPStringArray = isESPStringArray;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public void setContainer(boolean isContainer) {
            this.isContainer = isContainer;
        }

        public boolean isWrapped() {
            return this.isWrapped;
        }

        public void setWrapped(boolean isWrapped) {
            this.isWrapped = isWrapped;
        }

        public String getBaseType() {
            return this.type;
        }

        public String getActualType() {
            String actualtype = this.type;
            if (this.isWrapped) {
                actualtype = actualtype + "Wrapper";
            }
            if (this.isContainer) {
                actualtype = "List<" + actualtype + ">";
            }
            return actualtype;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPackagename() {
            return this.packagename;
        }

        public void setPackagename(String packagename) {
            this.packagename = packagename;
        }

        public String getName() {
            return this.name;
        }

        public String getSafeName() {
            return "local_" + this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getActualDeclaration() {
            return "protected " + this.getActualType() + " " + this.getSafeName() + (this.isContainer ? " = null" : "") + ";\n";
        }
    }
}

