/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.HPCCFileSprayClient;
import org.hpccsystems.ws.client.gen.axis2.wstopology.latest.TpMachine;
import org.hpccsystems.ws.client.platform.PhysicalFile;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.gen.filespray.PhysicalFileStructWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpMachineWrapper;

public class PhysicalMachine
extends DataSingleton {
    private static final Logger log = LogManager.getLogger(PhysicalMachine.class);
    private static Map<Integer, PhysicalMachine> physicalMachines = new HashMap<Integer, PhysicalMachine>();
    private Platform platform;
    private TpMachine physicalmachinestruct;
    private Collection<PhysicalFile> files;

    public static synchronized PhysicalMachine get(Platform platform, String name) {
        PhysicalMachine physicalMachine = new PhysicalMachine(platform, name);
        if (physicalMachines.containsKey(physicalMachine.hashCode())) {
            return physicalMachines.get(physicalMachine.hashCode());
        }
        physicalMachines.put(physicalMachine.hashCode(), physicalMachine);
        return physicalMachine;
    }

    private PhysicalMachine(Platform platform, String name) {
        this.platform = platform;
        this.physicalmachinestruct = new TpMachine();
        this.physicalmachinestruct.setName(name);
        this.files = new HashSet<PhysicalFile>();
    }

    public String getName() {
        return this.physicalmachinestruct.getName();
    }

    public String getConfigNetaddress() {
        return this.physicalmachinestruct.getConfigNetaddress();
    }

    public String getNetaddress() {
        return this.physicalmachinestruct.getNetaddress();
    }

    public String getDirectory() {
        return this.physicalmachinestruct.getDirectory();
    }

    public String getDomain() {
        return this.physicalmachinestruct.getDomain();
    }

    public int getOS() {
        return this.physicalmachinestruct.getOS();
    }

    public Utils.HPCCEnvOSCode getOSCode() {
        return Utils.HPCCEnvOSCode.fromCode(this.physicalmachinestruct.getOS());
    }

    public String getOSName() {
        return Utils.HPCCEnvOSCode.fromCode(this.physicalmachinestruct.getOS()).getName();
    }

    public String getPath() {
        return this.physicalmachinestruct.getPath();
    }

    synchronized PhysicalFile getFile(String name) {
        return PhysicalFile.get(this.platform, name);
    }

    PhysicalFile getFile(PhysicalFileStructWrapper fileStruct) {
        return PhysicalFile.get(this.platform, fileStruct);
    }

    public PhysicalFile[] getFiles() {
        this.fullRefresh();
        return this.files.toArray(new PhysicalFile[0]);
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        try {
            HPCCFileSprayClient wsfsclient = this.platform.getWsClient().getFileSprayClient();
            List<PhysicalFileStructWrapper> dzfiles = wsfsclient.listFiles(this.physicalmachinestruct.getNetaddress(), this.physicalmachinestruct.getDirectory(), null);
            this.update(dzfiles);
        }
        catch (Exception e) {
            log.error("Could not refresh files list for PhysicalMachine: '" + this.physicalmachinestruct.getName() + "'");
            e.printStackTrace();
        }
        this.notifyObservers((Object)Notification.PHYSICALMACHINE);
    }

    private void update(List<PhysicalFileStructWrapper> dzfiles) {
        if (dzfiles != null) {
            this.files.clear();
            for (PhysicalFileStructWrapper file : dzfiles) {
                PhysicalFile physicalFile = this.getFile(file.getName());
                physicalFile.update(file);
                this.files.add(physicalFile);
            }
        }
    }

    public void update(TpMachine tpmachinestruct) {
        if (this.physicalmachinestruct.getName().equals(tpmachinestruct.getName())) {
            this.physicalmachinestruct = tpmachinestruct;
        }
    }

    public void update(TpMachineWrapper tpmachinestruct) {
        this.update(tpmachinestruct.getRaw());
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof PhysicalMachine)) {
            return false;
        }
        PhysicalMachine that = (PhysicalMachine)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.physicalmachinestruct.getName(), that.physicalmachinestruct.getName());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.physicalmachinestruct.getName());
        return result;
    }

    public static enum Notification {
        PHYSICALMACHINE;

    }
}

