/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.cluster;

import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.cluster.AddrRemapper;
import org.hpccsystems.dfs.cluster.NullRemapper;
import org.hpccsystems.dfs.cluster.RemapInfo;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileAccessInfoWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileCopyWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUPartWrapper;

public abstract class ClusterRemapper {
    protected int nodes;
    protected static final int DEFAULT_LEGACY_CLEAR_PORT = 7100;
    protected static final int DEFAULT_LEGACY_SSL_PORT = 7700;
    protected static final int DEFAULT_ROWSERVICE_PORT = 7601;
    protected static final boolean DEFAULT_ROWSERVICE_USES_SSL = false;

    protected ClusterRemapper(RemapInfo ri) throws HpccFileException {
        this.nodes = ri.getNodes();
    }

    public abstract String[] reviseIPs(String[] var1) throws HpccFileException;

    public abstract String[] reviseIPs(DFUFileCopyWrapper[] var1) throws HpccFileException;

    public abstract int revisePort(DFUPartWrapper var1);

    public abstract boolean getUsesSSLConnection(DFUPartWrapper var1);

    public static ClusterRemapper makeMapper(RemapInfo ri, DFUFileAccessInfoWrapper fileaccessinfo) throws HpccFileException {
        return ri.isNullMapper() ? new NullRemapper(ri, fileaccessinfo) : new AddrRemapper(ri, fileaccessinfo);
    }
}

