/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.cluster;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.cluster.ClusterRemapper;
import org.hpccsystems.dfs.cluster.RemapInfo;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileAccessInfoWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileCopyWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUPartWrapper;

public class AddrRemapper
extends ClusterRemapper {
    private HashMap<String, String> ip_tab;
    private int rowServicePort;
    private boolean usesSSL;
    private static Comparator<DFUPartWrapper> FilePartInfoComparator = new Comparator<DFUPartWrapper>(){

        @Override
        public int compare(DFUPartWrapper fpi1, DFUPartWrapper fpi2) {
            if (fpi1.getCopy() < fpi2.getCopy()) {
                return -1;
            }
            if (fpi1.getCopy() > fpi2.getCopy()) {
                return 1;
            }
            if (fpi1.getId() < fpi2.getId()) {
                return -1;
            }
            if (fpi1.getId() > fpi2.getId()) {
                return 1;
            }
            return 0;
        }
    };

    public AddrRemapper(RemapInfo ri, DFUFileAccessInfoWrapper dfufileinfo) throws HpccFileException {
        super(ri);
        this.rowServicePort = dfufileinfo.getFileAccessPort();
        this.usesSSL = dfufileinfo.getFileAccessSSL();
        String[] allavailablelocations = dfufileinfo.getAllFilePartCopyLocations();
        HashSet<String> ip_set = new HashSet<String>(allavailablelocations.length);
        for (String location : allavailablelocations) {
            ip_set.add(location);
        }
        Object[] ip_list = ip_set.toArray(new String[0]);
        Arrays.sort(ip_list);
        if (ip_list.length > ri.getNodes()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Too many addresses, need ");
            sb.append(ip_list.length);
            sb.append(" but have only ");
            sb.append(ri.getNodes());
            throw new HpccFileException(sb.toString());
        }
        short[] target_parts = new short[4];
        StringTokenizer st = new StringTokenizer(ri.getBaseIp(), ".");
        if (st.countTokens() != 4) {
            throw new IllegalArgumentException("Incomplete IP address for target");
        }
        int pos = 0;
        while (st.hasMoreTokens()) {
            target_parts[pos] = Short.parseShort(st.nextToken());
            ++pos;
        }
        this.ip_tab = new HashMap(ip_list.length * 2);
        for (int i = 0; i < ip_list.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < 4; ++j) {
                sb.append(target_parts[j]);
                if (j >= 3) continue;
                sb.append(".");
            }
            this.ip_tab.put((String)ip_list[i], sb.toString());
            target_parts[3] = (short)(target_parts[3] + 1);
            if (target_parts[3] < 256) continue;
            target_parts[3] = 0;
            target_parts[2] = (short)(target_parts[2] + 1);
            if (target_parts[2] < 256) continue;
            target_parts[2] = 0;
            target_parts[1] = (short)(target_parts[1] + 1);
            if (target_parts[1] < 256) continue;
            throw new IllegalArgumentException("Too many nodes for starting address");
        }
    }

    @Override
    public String[] reviseIPs(String[] ips) throws HpccFileException {
        String[] revisedips = new String[ips.length];
        for (int ipindex = 0; ipindex < ips.length; ++ipindex) {
            if (!this.ip_tab.containsKey(ips[ipindex])) {
                throw new HpccFileException("IP not in cluster ip mapping table");
            }
            revisedips[ipindex] = this.ip_tab.get(ips[ipindex]);
        }
        return revisedips;
    }

    @Override
    @Deprecated
    public String[] reviseIPs(DFUFileCopyWrapper[] dfuFileCopies) throws HpccFileException {
        String[] revisedips = new String[dfuFileCopies.length];
        for (int partsindex = 0; partsindex < revisedips.length; ++partsindex) {
            if (!this.ip_tab.containsKey(dfuFileCopies[partsindex].getCopyHost())) {
                throw new HpccFileException("IP not in cluster ip mapping table");
            }
            revisedips[partsindex] = this.ip_tab.get(dfuFileCopies[partsindex].getCopyHost());
        }
        return revisedips;
    }

    @Override
    public int revisePort(DFUPartWrapper fpi) {
        return this.rowServicePort;
    }

    @Override
    public boolean getUsesSSLConnection(DFUPartWrapper fpi) {
        return this.usesSSL;
    }
}

