/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.RecordDefinitionTranslator;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.client.CompressionAlgorithm;

public class RowServiceOutputStream
extends OutputStream {
    private static final Logger log = LogManager.getLogger(RowServiceOutputStream.class);
    public static final int DEFAULT_CONNECT_TIMEOUT_MILIS = 5000;
    private static int SCRATCH_BUFFER_LEN = 2048;
    private String rowServiceVersion = "";
    private String rowServiceIP = null;
    private int rowServicePort = -1;
    private FieldDef recordDef = null;
    private String filePath = null;
    private int filePartIndex = -1;
    private String accessToken = null;
    private CompressionAlgorithm compressionAlgo = CompressionAlgorithm.NONE;
    private Socket socket = null;
    private DataInputStream dis = null;
    private DataOutputStream dos = null;
    private boolean useOldProtocol = false;
    private long bytesWritten = 0L;
    private long handle = -1L;
    private ByteBuffer scratchBuffer = ByteBuffer.allocate(SCRATCH_BUFFER_LEN);

    @Deprecated
    RowServiceOutputStream(String ip, int port, String accessToken, FieldDef recordDef, int filePartIndex, String filePartPath, CompressionAlgorithm fileCompression) throws Exception {
        this(ip, port, true, accessToken, recordDef, filePartIndex, filePartPath, fileCompression);
    }

    RowServiceOutputStream(String ip, int port, boolean useSSL, String accessToken, FieldDef recordDef, int filePartIndex, String filePartPath, CompressionAlgorithm fileCompression) throws Exception {
        this(ip, port, useSSL, accessToken, recordDef, filePartIndex, filePartPath, fileCompression, 5000);
    }

    RowServiceOutputStream(String ip, int port, boolean useSSL, String accessToken, FieldDef recordDef, int filePartIndex, String filePartPath, CompressionAlgorithm fileCompression, int connectTimeoutMs) throws Exception {
        this.rowServiceIP = ip;
        this.rowServicePort = port;
        this.recordDef = recordDef;
        this.filePartIndex = filePartIndex;
        this.filePath = filePartPath;
        this.accessToken = accessToken;
        this.compressionAlgo = fileCompression;
        try {
            if (useSSL) {
                SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                this.socket = (SSLSocket)ssf.createSocket();
                this.socket.setPerformancePreferences(0, 1, 2);
                this.socket.connect(new InetSocketAddress(this.rowServiceIP, this.rowServicePort), connectTimeoutMs);
                log.debug("Attempting SSL handshake...");
                ((SSLSocket)this.socket).startHandshake();
                log.debug("SSL handshake successful...");
                log.debug("   Remote address = " + this.socket.getInetAddress().toString() + " Remote port = " + this.socket.getPort());
            } else {
                SocketFactory sf = SocketFactory.getDefault();
                this.socket = sf.createSocket();
                this.socket.setPerformancePreferences(0, 1, 2);
                this.socket.connect(new InetSocketAddress(this.rowServiceIP, this.rowServicePort), 5000);
            }
            this.dos = new DataOutputStream(this.socket.getOutputStream());
            this.dis = new DataInputStream(this.socket.getInputStream());
        }
        catch (Exception e) {
            String errorMessage = "Exception occured while attempting to connect to row service (" + this.rowServiceIP + ":" + this.rowServicePort + "): " + e.getMessage();
            log.error(errorMessage);
            throw new Exception(errorMessage);
        }
        try {
            String msg = this.makeGetVersionRequest();
            int msgLen = msg.length();
            this.dos.writeInt(msgLen);
            this.dos.write(msg.getBytes(StandardCharsets.ISO_8859_1), 0, msgLen);
            this.dos.flush();
        }
        catch (IOException e) {
            throw new HpccFileException("Failed on initial remote read read trans", (Throwable)e);
        }
        RowServiceResponse response = this.readResponse();
        if (response.len == 0) {
            this.useOldProtocol = true;
        } else {
            this.useOldProtocol = false;
            byte[] versionBytes = new byte[response.len];
            try {
                this.dis.readFully(versionBytes);
            }
            catch (IOException e) {
                throw new HpccFileException("Error while attempting to read version response.", (Throwable)e);
            }
            this.rowServiceVersion = new String(versionBytes, StandardCharsets.ISO_8859_1);
        }
        this.makeInitialWriteRequest();
    }

    private String makeGetVersionRequest() {
        String versionMsg = "+{ \"command\" : \"version\", \"handle\": \"-1\", \"format\": \"binary\" }";
        return "+{ \"command\" : \"version\", \"handle\": \"-1\", \"format\": \"binary\" }";
    }

    private void makeInitialWriteRequest() throws Exception {
        String jsonRecordDef = RecordDefinitionTranslator.toJsonRecord((FieldDef)this.recordDef).toString();
        String initialRequest = "\n{\n    \"format\" : \"binary\",\n    \"replyLimit\" : " + SCRATCH_BUFFER_LEN + ",\n" + (this.useOldProtocol ? "" : "\"command\" : \"newstream\",\n") + "    \"node\" : {\n        \"kind\" : \"diskwrite\",\n        \"metaInfo\" : \"" + this.accessToken + "\",\n        \"fileName\" : \"" + this.filePath + "\",\n        \"filePart\" : \"" + this.filePartIndex + "\",\n        \"compressed\" : \"" + (Object)((Object)this.compressionAlgo) + "\",\n        \"input\" : " + jsonRecordDef + "\n    }\n}\n";
        byte[] jsonRequestData = initialRequest.getBytes("ISO-8859-1");
        ByteBuffer requestBuffer = ByteBuffer.allocate(jsonRequestData.length + 256);
        requestBuffer.mark();
        requestBuffer.putInt(0);
        requestBuffer.put((byte)45);
        requestBuffer.putInt(jsonRequestData.length);
        requestBuffer.put(jsonRequestData);
        int rowDataLen = 0;
        requestBuffer.putInt(rowDataLen);
        int headerLen = requestBuffer.position();
        int packetLen = headerLen + rowDataLen - 4;
        requestBuffer.reset();
        requestBuffer.putInt(packetLen);
        this.dos.write(requestBuffer.array(), 0, headerLen);
        this.dos.flush();
        RowServiceResponse response = this.readResponse();
        this.handle = response.handle;
    }

    private String makeCloseHandleRequest() {
        StringBuilder sb = new StringBuilder(256);
        sb.delete(0, sb.length());
        sb.append("{ \"format\" : \"binary\",\n");
        sb.append("  \"handle\" : \"" + Long.toString(this.handle) + "\",");
        sb.append("  \"command\" : \"close\"");
        sb.append("\n}");
        return sb.toString();
    }

    private void sendCloseFileRequest() throws IOException {
        if (this.useOldProtocol) {
            return;
        }
        String closeFileRequest = this.makeCloseHandleRequest();
        int jsonRequestLen = closeFileRequest.length();
        try {
            this.dos.writeInt(jsonRequestLen + 4 + 1);
            this.dos.write(45);
            this.dos.writeInt(jsonRequestLen);
            this.dos.write(closeFileRequest.getBytes(StandardCharsets.ISO_8859_1));
            this.dos.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed on close file with error: ", e);
        }
        try {
            this.readResponse();
        }
        catch (HpccFileException e) {
            throw new IOException("Failed to close file. Unable to read response with error: ", e);
        }
    }

    private RowServiceResponse readResponse() throws HpccFileException {
        RowServiceResponse response = new RowServiceResponse();
        try {
            response.len = this.dis.readInt();
            if (response.len < 0) {
                response.len &= Integer.MAX_VALUE;
            }
            if (response.len == 0) {
                response.len = -1;
                return response;
            }
            response.errorCode = this.dis.readInt();
            response.len -= 4;
            if (response.errorCode != 0) {
                StringBuilder sb = new StringBuilder();
                sb.delete(0, sb.length());
                sb.append("\nReceived ERROR from Thor node (");
                sb.append(this.rowServiceIP);
                sb.append("): Code: '");
                sb.append(response.errorCode);
                sb.append("'");
                if (response.len > 0) {
                    byte[] message = new byte[response.len];
                    this.dis.readFully(message, 0, response.len);
                    sb.append(" Message: '");
                    sb.append(new String(message));
                    sb.append("'");
                }
                switch (response.errorCode) {
                    case -6: {
                        sb.append("\nInvalid file access expiry reported - change File Access Expiry (HPCCFile) and retry");
                        break;
                    }
                    case -7: {
                        sb.append("\nFile access expired before initial request - Retry and consider increasing File Access Expiry (HPCCFile)");
                        break;
                    }
                }
                response.len = -1;
                response.errorMessage = sb.toString();
                return response;
            }
            if (response.len < 4) {
                throw new HpccFileException("Early data termination, no handle");
            }
            response.handle = this.dis.readInt();
            response.len -= 4;
        }
        catch (IOException e) {
            throw new HpccFileException("Error while attempting to read row service response: ", (Throwable)e);
        }
        return response;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (!this.useOldProtocol) {
            this.sendCloseFileRequest();
        } else if (this.bytesWritten == 0L && this.compressionAlgo != CompressionAlgorithm.NONE) {
            throw new IOException("Fatal error while closing file. Writing compressed files with 0 length is not supported with the remote HPCC cluster.");
        }
        this.socket.close();
    }

    @Override
    public void flush() throws IOException {
        this.dos.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        String request = "{ \"format\" : \"binary\", \"handle\" : \"" + this.handle + "\"" + (this.useOldProtocol ? "" : ", \"command\" : \"continue\"") + " }";
        byte[] jsonRequestData = request.getBytes("ISO-8859-1");
        this.scratchBuffer.clear();
        this.scratchBuffer.mark();
        this.scratchBuffer.putInt(0);
        this.scratchBuffer.put((byte)45);
        this.scratchBuffer.putInt(jsonRequestData.length);
        this.scratchBuffer.put(jsonRequestData);
        int rowDataLen = len;
        this.scratchBuffer.putInt(rowDataLen);
        int headerLen = this.scratchBuffer.position();
        int packetLen = headerLen + len - 4;
        this.scratchBuffer.reset();
        this.scratchBuffer.putInt(packetLen);
        this.dos.write(this.scratchBuffer.array(), 0, headerLen);
        this.dos.write(b, off, len);
        this.dos.flush();
        this.bytesWritten += (long)len;
        try {
            RowServiceResponse response = this.readResponse();
            this.handle = response.handle;
        }
        catch (HpccFileException e) {
            throw new IOException("Failed during write operation. Unable to read response with error: ", e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.scratchBuffer.array()[0] = (byte)b;
        this.write(this.scratchBuffer.array(), 0, 1);
    }

    private static class RowServiceResponse {
        int len = 0;
        int errorCode = 0;
        int handle = -1;
        String errorMessage = null;

        private RowServiceResponse() {
        }
    }
}

