/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.HpccSrcType;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.commons.errors.UnparsableContentException;
import org.hpccsystems.commons.utils.Utils;
import org.hpccsystems.dfs.client.CountingInputStream;
import org.hpccsystems.dfs.client.IRecordBuilder;
import org.hpccsystems.dfs.client.IRecordReader;
import org.hpccsystems.dfs.client.StreamOperationMessages;

public class BinaryRecordReader
implements IRecordReader {
    protected IRecordBuilder rootRecordBuilder;
    private CountingInputStream inputStream;
    private FieldDef rootRecordDefinition;
    protected boolean defaultLE;
    private long streamPosAfterLastRecord = 0L;
    private boolean isIndex = false;
    private boolean useDecimalForUnsigned8 = false;
    public static final int NO_STRING_PROCESSING = 0;
    public static final int TRIM_STRINGS = 1;
    public static final int TRIM_FIXED_LEN_STRINGS = 2;
    public static final int CONVERT_EMPTY_STRINGS_TO_NULL = 4;
    private boolean shouldTrimFixedLenStrings = false;
    private boolean shouldTrimStrings = false;
    private boolean convertEmptyStringsToNull = false;
    private byte[] scratchBuffer = new byte[8192];
    private static final Charset sbcSet = Charset.forName("ISO-8859-1");
    private static final Charset utf8Set = Charset.forName("UTF-8");
    private static final Charset utf16beSet = Charset.forName("UTF-16BE");
    private static final Charset utf16leSet = Charset.forName("UTF-16LE");
    private static final Logger log = LogManager.getLogger(BinaryRecordReader.class);
    private static final long[] powTable = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L};
    private static final int[] signMap = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 1, -1, 1, 1};
    private static final int MASK_32_LOWER_HALF = 65535;
    private static final int BUFFER_GROW_SIZE = 8192;
    private static final int OPTIMIZED_STRING_READ_AHEAD = 32;
    private static final int QSTR_COMPRESSED_CHUNK_LEN = 3;
    private static final int QSTR_EXPANDED_CHUNK_LEN = 4;
    private StreamOperationMessages messages = new StreamOperationMessages();

    public String getStreamMessages() {
        return this.messages.getMessagesSummary();
    }

    public int getStreamMessageCount() {
        return this.messages.getTotalMessageCount();
    }

    public long getStreamPosAfterLastRecord() {
        return this.streamPosAfterLastRecord;
    }

    public BinaryRecordReader(InputStream is) throws Exception {
        this(is, 0L);
    }

    public BinaryRecordReader(InputStream is, long streamPos) throws Exception {
        if (streamPos < 0L) {
            throw new Exception("BinaryRecordReader: invalid initial streamPos provided: " + streamPos);
        }
        this.inputStream = new CountingInputStream(is);
        this.inputStream.streamPos = streamPos;
        this.defaultLE = true;
        if (!this.inputStream.markSupported()) {
            throw new Exception("BinaryRecordReader requires provided InputStream to support mark()");
        }
    }

    @Override
    public void initialize(IRecordBuilder rb) throws Exception {
        this.rootRecordBuilder = rb;
        if (rb == null) {
            throw new Exception("Error initializing BinaryRecordReader. IRecordBuilder must not be null.");
        }
        this.rootRecordDefinition = rb.getRecordDefinition();
        if (this.rootRecordDefinition == null) {
            throw new Exception("Error initializing BinaryRecordReader. IRecordBuilder provided a null record definition.");
        }
    }

    public void setUseDecimalForUnsigned8(boolean useDecimal) {
        this.useDecimalForUnsigned8 = useDecimal;
    }

    public void setIsIndex(boolean isIdx) {
        this.isIndex = isIdx;
    }

    public void setStringProcessingFlags(int flags) {
        this.shouldTrimStrings = (flags & 1) != 0;
        this.shouldTrimFixedLenStrings = (flags & 2) != 0;
        this.convertEmptyStringsToNull = (flags & 4) != 0;
    }

    @Override
    public boolean hasNext() throws HpccFileException {
        if (this.rootRecordBuilder == null) {
            throw new HpccFileException("RecordReader must be initialized before being used.");
        }
        int nextByte = -1;
        try {
            if (this.inputStream.available() > 0) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        try {
            this.inputStream.mark(2);
            nextByte = this.inputStream.read();
            this.inputStream.reset();
        }
        catch (IOException e) {
            throw new HpccFileException((Throwable)e);
        }
        return nextByte >= 0;
    }

    @Override
    public Object getNext() throws HpccFileException {
        if (this.rootRecordBuilder == null) {
            throw new HpccFileException("RecordReader must be initialized before being used.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next record!");
        }
        Object record = null;
        try {
            record = this.parseRecord(this.rootRecordDefinition, this.rootRecordBuilder, this.defaultLE);
            if (record == null) {
                throw new HpccFileException("RecordContent not found, or invalid record structure. Check logs for more information.");
            }
        }
        catch (Exception e) {
            throw new HpccFileException("Failed to parse next record: " + e.getMessage(), (Throwable)e);
        }
        this.streamPosAfterLastRecord = this.inputStream.getStreamPosition();
        return record;
    }

    @Override
    public int getAvailable() throws IOException {
        return this.inputStream.available();
    }

    private Object parseFlatField(FieldDef fd, boolean isLittleEndian) throws UnparsableContentException, IOException {
        Object fieldValue = null;
        int dataLen = 0;
        if (fd.isFixed() && fd.getDataLen() > Integer.MAX_VALUE) {
            throw new UnparsableContentException("Data length: " + fd.getDataLen() + " exceeds max supported length: " + Integer.MAX_VALUE);
        }
        switch (fd.getFieldType()) {
            case FILEPOS: 
            case INTEGER: {
                long intValue = 0L;
                if (fd.isUnsigned()) {
                    intValue = this.getUnsigned((int)fd.getDataLen(), fd.getSourceType() == HpccSrcType.LITTLE_ENDIAN);
                    if (this.useDecimalForUnsigned8 && fd.getDataLen() == 8L) {
                        BigInteger bi = Utils.extractUnsigned8Val((long)intValue);
                        fieldValue = new BigDecimal(bi);
                        break;
                    }
                    fieldValue = intValue;
                    if (intValue >= 0L) break;
                    this.messages.addMessage("Warning: Possible unsigned overflow in column: '" + fd.getFieldName() + "'. Convert values to BigInteger via org.hpccsystems.commons.utils.extractUnsigned8 if necessary,  or call BinaryRecordReader.setUseDecimalForUnsigned8() before reading to convert unsigned8 values to BigDecimal values.");
                    break;
                }
                intValue = this.getInt((int)fd.getDataLen(), fd.getSourceType() == HpccSrcType.LITTLE_ENDIAN, fd.isBiased());
                fieldValue = intValue;
                break;
            }
            case REAL: {
                double u = this.getReal((int)fd.getDataLen(), fd.getSourceType() == HpccSrcType.LITTLE_ENDIAN);
                fieldValue = u;
                break;
            }
            case DECIMAL: {
                BigDecimal decValue = null;
                dataLen = (int)fd.getDataLen();
                decValue = fd.isUnsigned() ? this.getUnsignedDecimal(fd.getPrecision(), fd.getScale(), (int)fd.getDataLen()) : this.getSignedDecimal(fd.getPrecision(), fd.getScale(), (int)fd.getDataLen());
                fieldValue = decValue;
                break;
            }
            case BINARY: {
                int bytesRead;
                dataLen = fd.isFixed() ? (int)fd.getDataLen() : (int)this.getInt(4, isLittleEndian, false);
                byte[] bytes = new byte[dataLen];
                for (int bytesConsumed = 0; bytesConsumed < dataLen; bytesConsumed += bytesRead) {
                    bytesRead = this.inputStream.read(bytes, bytesConsumed, dataLen - bytesConsumed);
                    if (bytesRead >= 0) continue;
                    IOException e = new IOException("Error, Unexpected EOS while constructing binary value.");
                    throw e;
                }
                fieldValue = bytes;
                break;
            }
            case BOOLEAN: {
                long value = this.getInt((int)fd.getDataLen(), fd.getSourceType() == HpccSrcType.LITTLE_ENDIAN, fd.isBiased());
                fieldValue = value != 0L;
                break;
            }
            case CHAR: {
                fieldValue = this.getString(fd.getSourceType(), 1, false);
                break;
            }
            case STRING: {
                boolean shouldTrim = this.shouldTrimStrings;
                int codePoints = 0;
                if (fd.isFixed()) {
                    if (fd.getDataLen() > Integer.MAX_VALUE) {
                        throw new UnparsableContentException("Data length: " + fd.getDataLen() + " exceeds max supported length: " + Integer.MAX_VALUE);
                    }
                    codePoints = (int)fd.getDataLen();
                    shouldTrim = shouldTrim || this.shouldTrimFixedLenStrings;
                } else {
                    codePoints = (int)this.getInt(4, isLittleEndian, false);
                }
                fieldValue = this.getString(fd.getSourceType(), codePoints, shouldTrim);
                break;
            }
            case VAR_STRING: {
                if (fd.isFixed()) {
                    if (fd.getDataLen() > Integer.MAX_VALUE) {
                        throw new UnparsableContentException("Data length: " + fd.getDataLen() + " exceeds max supported length: " + Integer.MAX_VALUE);
                    }
                    boolean shouldTrim = this.shouldTrimStrings || this.shouldTrimFixedLenStrings;
                    int codePoints = (int)fd.getDataLen();
                    String strValue = this.getString(fd.getSourceType(), codePoints, shouldTrim);
                    if (fd.getSourceType().isUTF16()) {
                        this.inputStream.skip(2L);
                    } else {
                        this.inputStream.skip(1L);
                    }
                    fieldValue = strValue;
                    break;
                }
                boolean shouldTrim = this.shouldTrimStrings;
                fieldValue = this.getNullTerminatedString(fd.getSourceType(), shouldTrim);
                break;
            }
            default: {
                throw new UnparsableContentException("Unexpected type: " + fd.getFieldType() + " for field: " + fd.getFieldName());
            }
        }
        return fieldValue;
    }

    private Object parseRecord(FieldDef recordDef, IRecordBuilder recordBuilder, boolean isLittleEndian) throws UnparsableContentException, IOException {
        try {
            recordBuilder.startRecord();
        }
        catch (Exception e) {
            throw new UnparsableContentException("Unable to start record with error: " + e.getMessage());
        }
        for (int fieldIndex = 0; fieldIndex < recordDef.getNumDefs(); ++fieldIndex) {
            FieldDef fd = recordDef.getDef(fieldIndex);
            ArrayList<Object> fieldValue = null;
            switch (fd.getFieldType()) {
                case FILEPOS: 
                case INTEGER: 
                case REAL: 
                case DECIMAL: 
                case BINARY: 
                case BOOLEAN: 
                case CHAR: 
                case STRING: 
                case VAR_STRING: {
                    try {
                        fieldValue = this.parseFlatField(fd, isLittleEndian);
                        break;
                    }
                    catch (Exception e) {
                        throw new IOException("Error while parsing field: " + fd.getFieldName() + " of type: " + fd.getFieldType() + ": ", e);
                    }
                }
                case RECORD: {
                    IRecordBuilder childRecordBuilder = recordBuilder.getChildRecordBuilder(fieldIndex);
                    if (childRecordBuilder == null) {
                        throw new UnparsableContentException("Recieved null child IRecordBulder for field:" + fd.getFieldName());
                    }
                    fieldValue = this.parseRecord(fd, childRecordBuilder, isLittleEndian);
                    break;
                }
                case SET: {
                    this.inputStream.skip(1L);
                }
                case DATASET: {
                    if (fd.getNumDefs() != 1) {
                        throw new UnparsableContentException("Set should have a single child type." + fd.getNumDefs() + " child types found.");
                    }
                    int dataLen = (int)this.getInt(4, isLittleEndian, false);
                    int childCountGuess = 1;
                    if (fd.getDataLen() > 0L) {
                        childCountGuess = dataLen / (int)fd.getDataLen();
                    }
                    FieldDef childFd = fd.getDef(0);
                    ArrayList<Object> ws = new ArrayList<Object>(childCountGuess);
                    switch (childFd.getFieldType()) {
                        case FILEPOS: 
                        case INTEGER: 
                        case REAL: 
                        case DECIMAL: 
                        case BINARY: 
                        case BOOLEAN: 
                        case CHAR: 
                        case STRING: 
                        case VAR_STRING: {
                            long setEndPos = this.inputStream.getStreamPosition() + (long)dataLen;
                            while (this.inputStream.getStreamPosition() < setEndPos) {
                                try {
                                    ws.add(this.parseFlatField(childFd, isLittleEndian));
                                }
                                catch (Exception e) {
                                    throw new IOException("Error while parsing field: " + fd.getFieldName() + " of type: " + fd.getFieldType() + ": ", e);
                                }
                            }
                            break;
                        }
                        case RECORD: {
                            IRecordBuilder childRecordBuilder = recordBuilder.getChildRecordBuilder(fieldIndex);
                            if (childRecordBuilder == null) {
                                throw new UnparsableContentException("Recieved null child IRecordBulder for field:" + fd.getFieldName());
                            }
                            long setEndPos = this.inputStream.getStreamPosition() + (long)dataLen;
                            while (this.inputStream.getStreamPosition() < setEndPos) {
                                ws.add(this.parseRecord(childFd, childRecordBuilder, isLittleEndian));
                            }
                            break;
                        }
                        default: {
                            String msg = "Dataset unhandled child type: " + childFd.getFieldType();
                            throw new UnparsableContentException(msg);
                        }
                    }
                    fieldValue = ws;
                    break;
                }
                default: {
                    String msg = "Unhandled type: " + fd.getFieldType();
                    throw new UnparsableContentException(msg);
                }
            }
            try {
                recordBuilder.setFieldValue(fieldIndex, fieldValue);
                continue;
            }
            catch (Exception e) {
                throw new UnparsableContentException("Unable to set field value for field: " + fd.getFieldName() + " with error: " + e.getMessage());
            }
        }
        try {
            return recordBuilder.finalizeRecord();
        }
        catch (Exception e) {
            throw new UnparsableContentException("Unable to finalize record with error: " + e.getMessage());
        }
    }

    private void ensureScratchBufferCapacity(int requiredCapacity) {
        if (this.scratchBuffer.length < requiredCapacity) {
            this.scratchBuffer = Arrays.copyOf(this.scratchBuffer, requiredCapacity + 8192);
        }
    }

    private void readIntoScratchBuffer(int offset, int dataLen) throws IOException {
        int bytesRead;
        int requiredCapacity = offset + dataLen;
        this.ensureScratchBufferCapacity(requiredCapacity);
        int position = offset;
        for (int bytesConsumed = 0; bytesConsumed < dataLen; bytesConsumed += bytesRead) {
            bytesRead = this.inputStream.read(this.scratchBuffer, position, dataLen - bytesConsumed);
            if (bytesRead < 0) {
                IOException e = new IOException("Unexpected end of stream: dataLen: " + dataLen + " bytesConsumed: " + bytesConsumed + " streamPos: " + this.inputStream.streamPos);
                e.printStackTrace();
                throw e;
            }
            position += bytesRead;
        }
    }

    private long getInt(int len, boolean little_endian, boolean shouldCorrectBias) throws IOException {
        long negMask;
        long v = this.getUnsigned(len, little_endian);
        if ((v & (negMask = 128L << (len - 1) * 8)) != 0L) {
            for (int i = len; i < 8; ++i) {
                v |= 255L << i * 8;
            }
        }
        if (this.isIndex && shouldCorrectBias) {
            v += negMask;
        }
        return v;
    }

    private long getUnsigned(int len, boolean little_endian) throws IOException {
        this.readIntoScratchBuffer(0, len);
        long v = 0L;
        for (int i = 0; i < len; ++i) {
            int idx = little_endian ? len - 1 - i : i;
            v = v << 8 | (long)(this.scratchBuffer[idx] & 0xFF);
        }
        return v;
    }

    private double getReal(int len, boolean little_endian) throws IOException {
        this.readIntoScratchBuffer(0, len);
        double u = 0.0;
        if (len == 4) {
            int u4 = 0;
            for (int i = 0; i < 4; ++i) {
                int idx = little_endian ? len - 1 - i : i;
                u4 = u4 << 8 | this.scratchBuffer[idx] & 0xFF;
            }
            u = Float.intBitsToFloat(u4);
        } else if (len == 8) {
            long u8 = 0L;
            for (int i = 0; i < 8; ++i) {
                int idx = little_endian ? len - 1 - i : i;
                u8 = u8 << 8 | (long)(this.scratchBuffer[idx] & 0xFF);
            }
            u = Double.longBitsToDouble(u8);
        }
        return u;
    }

    private BigDecimal getUnsignedDecimal(int numDigits, int precision, int dataLen) throws IOException {
        this.readIntoScratchBuffer(0, dataLen);
        BigDecimal ret = new BigDecimal(0);
        int idx = 0;
        int curDigit = numDigits - 1;
        while (idx < dataLen) {
            long value = 0L;
            int numToConsume = 8;
            if (idx + numToConsume > dataLen) {
                numToConsume = dataLen - idx;
            }
            int j = 0;
            while (j < numToConsume) {
                value += powTable[15 - (j * 2 + 0)] * (long)(this.scratchBuffer[idx] >> 4 & 0xF);
                value += powTable[15 - (j * 2 + 1)] * (long)(this.scratchBuffer[idx] & 0xF);
                ++j;
                ++idx;
            }
            int scale = curDigit - precision - 15;
            ret = ret.add(new BigDecimal(BigInteger.valueOf(value), -scale, MathContext.UNLIMITED));
            curDigit -= numToConsume * 2;
        }
        return ret;
    }

    private BigDecimal getSignedDecimal(int numDigits, int precision, int dataLen) throws IOException {
        this.readIntoScratchBuffer(0, dataLen);
        int zeroDigit = 32;
        int lsb = 32 - precision;
        int msb = lsb + numDigits;
        byte lastByte = this.scratchBuffer[dataLen - 1];
        long signMul = 1L;
        if (signMap[lastByte & 0xF] == -1) {
            signMul = -1L;
        }
        int idx = 0;
        int curDigit = numDigits;
        long value = lastByte >> 4 & 0xF;
        BigDecimal ret = new BigDecimal(BigInteger.valueOf(value *= signMul), precision, MathContext.UNLIMITED);
        if (numDigits % 2 == 1) {
            --curDigit;
        }
        if (msb == 32) {
            value = powTable[15] * (long)this.scratchBuffer[idx] & 0xFL;
            int scale = curDigit - precision - 15;
            ret = ret.add(new BigDecimal(BigInteger.valueOf(value *= signMul), -scale, MathContext.UNLIMITED));
            ++idx;
            --curDigit;
        }
        while (idx < dataLen - 1) {
            value = 0L;
            int numToConsume = 8;
            if (idx + numToConsume > dataLen - 1) {
                numToConsume = dataLen - 1 - idx;
            }
            int j = 0;
            while (j < numToConsume) {
                value += powTable[15 - (j * 2 + 0)] * (long)(this.scratchBuffer[idx] >> 4 & 0xF);
                value += powTable[15 - (j * 2 + 1)] * (long)(this.scratchBuffer[idx] & 0xF);
                ++j;
                ++idx;
            }
            int scale = curDigit - precision - 15;
            BigDecimal decVal = new BigDecimal(BigInteger.valueOf(value *= signMul), -scale, MathContext.UNLIMITED);
            ret = ret.add(decVal);
            curDigit -= numToConsume * 2;
        }
        return ret;
    }

    private void trimStringInScratchBuffer(boolean isUnicode, int[] range) {
        if (isUnicode) {
            int codePoint;
            while (range[0] < range[1] - 1 && Character.isWhitespace(codePoint = this.scratchBuffer[range[0]] & 0xFF | (this.scratchBuffer[range[0] + 1] & 0xFF) << 8)) {
                range[0] = range[0] + 2;
            }
            while (range[1] > range[0] && (Character.isWhitespace(codePoint = this.scratchBuffer[range[1] - 2] & 0xFF | (this.scratchBuffer[range[1] - 1] & 0xFF) << 8) || codePoint == 0)) {
                range[1] = range[1] - 2;
            }
        } else {
            int codePoint;
            while (range[0] < range[1] && Character.isWhitespace(codePoint = this.scratchBuffer[range[0]] & 0xFF)) {
                range[0] = range[0] + 1;
            }
            while (range[1] > range[0] && (Character.isWhitespace(codePoint = this.scratchBuffer[range[1] - 1] & 0xFF) || codePoint == 0)) {
                range[1] = range[1] - 1;
            }
        }
    }

    private String getNullTerminatedString(HpccSrcType stype, boolean shouldTrim) throws IOException {
        int j;
        int readSize;
        Charset charset = sbcSet;
        switch (stype) {
            case SINGLE_BYTE_CHAR: {
                charset = sbcSet;
                break;
            }
            case UTF16BE: {
                charset = utf16beSet;
                break;
            }
            case UTF16LE: {
                charset = utf16leSet;
                break;
            }
            default: {
                throw new IOException("Unsupported source type for null terminated string: " + stype);
            }
        }
        int eosLocation = -1;
        int strByteLen = 0;
        if (stype.isUTF16()) {
            while (eosLocation < 0) {
                readSize = 0;
                try {
                    readSize = this.inputStream.available();
                }
                catch (Exception e) {
                    throw new IOException("Error, unexpected EOS while constructing UTF16 string.");
                }
                readSize = (readSize + 1) / 2 * 2;
                if (readSize > 32) {
                    readSize = 32;
                }
                this.inputStream.mark(readSize);
                this.readIntoScratchBuffer(strByteLen, readSize);
                for (j = 0; j < readSize - 1; j += 2) {
                    if (this.scratchBuffer[strByteLen + j] != 0 || this.scratchBuffer[strByteLen + j + 1] != 0) continue;
                    eosLocation = j;
                    break;
                }
                if (eosLocation != -1) {
                    strByteLen += eosLocation;
                    this.inputStream.reset();
                    this.inputStream.skip(eosLocation + 2);
                    break;
                }
                strByteLen += readSize;
            }
        } else {
            while (eosLocation < 0) {
                readSize = 0;
                try {
                    readSize = this.inputStream.available();
                }
                catch (IOException e) {
                    throw new IOException("Error, encountered EOS while constructing var string.");
                }
                if (readSize > 32) {
                    readSize = 32;
                }
                this.inputStream.mark(readSize);
                this.readIntoScratchBuffer(strByteLen, readSize);
                for (j = 0; j < readSize; ++j) {
                    if (this.scratchBuffer[strByteLen + j] != 0) continue;
                    eosLocation = j;
                    break;
                }
                if (eosLocation != -1) {
                    strByteLen += eosLocation;
                    this.inputStream.reset();
                    this.inputStream.skip(eosLocation + 1);
                    break;
                }
                strByteLen += readSize;
            }
        }
        int[] strRange = new int[]{0, strByteLen};
        if (shouldTrim) {
            boolean isUnicode = stype == HpccSrcType.UTF16BE || stype == HpccSrcType.UTF16LE;
            this.trimStringInScratchBuffer(isUnicode, strRange);
        }
        if ((strByteLen = strRange[1] - strRange[0]) == 0 && this.convertEmptyStringsToNull) {
            return null;
        }
        return new String(this.scratchBuffer, strRange[0], strByteLen, charset);
    }

    private String getString(HpccSrcType styp, int codePoints, boolean shouldTrim) throws IOException {
        Charset charset = utf8Set;
        switch (styp) {
            case UTF8: {
                charset = utf8Set;
                break;
            }
            case SINGLE_BYTE_CHAR: {
                charset = sbcSet;
                break;
            }
            case UTF16BE: {
                charset = utf16beSet;
                break;
            }
            case UTF16LE: {
                charset = utf16leSet;
                break;
            }
            case QSTRING: {
                charset = sbcSet;
                break;
            }
            default: {
                throw new IOException("Unknown source type");
            }
        }
        if (codePoints <= 0) {
            return new String(this.scratchBuffer, 0, 0, charset);
        }
        int strByteLen = 0;
        this.ensureScratchBufferCapacity(codePoints * 2);
        switch (styp) {
            case UTF8: {
                int remainingCodePoints = codePoints;
                while (remainingCodePoints > 0) {
                    int bytesToRead = remainingCodePoints;
                    this.readIntoScratchBuffer(strByteLen, bytesToRead);
                    int bytesScanned = 0;
                    while (bytesScanned < bytesToRead) {
                        if ((this.scratchBuffer[strByteLen + bytesScanned] & 0x80) == 0) {
                            ++bytesScanned;
                        } else if ((this.scratchBuffer[strByteLen + bytesScanned] & 0xE0) == 192) {
                            bytesScanned += 2;
                        } else if ((this.scratchBuffer[strByteLen + bytesScanned] & 0xF0) == 224) {
                            bytesScanned += 3;
                        } else if ((this.scratchBuffer[strByteLen + bytesScanned] & 0xF8) == 240) {
                            bytesScanned += 4;
                        } else {
                            throw new IOException("Illegal UTF-8 sequence");
                        }
                        --remainingCodePoints;
                    }
                    strByteLen += bytesToRead;
                    int misalignedBytes = bytesScanned - bytesToRead;
                    if (misalignedBytes <= 0) continue;
                    this.readIntoScratchBuffer(strByteLen, misalignedBytes);
                    strByteLen += misalignedBytes;
                }
                break;
            }
            case SINGLE_BYTE_CHAR: 
            case UTF16BE: 
            case UTF16LE: {
                int bytesToRead = this.getLenFromCodePoints(styp, codePoints);
                this.readIntoScratchBuffer(strByteLen, bytesToRead);
                strByteLen += bytesToRead;
                break;
            }
            case QSTRING: {
                int expandedLen = codePoints;
                int compressedLen = expandedLen * 3 + 3;
                this.ensureScratchBufferCapacity(expandedLen + (compressedLen /= 4));
                int compressedBytesRead = 0;
                int compressedBytesConsumed = 0;
                while (compressedBytesRead < compressedLen) {
                    int bytesToRead = compressedLen;
                    int availableBytes = 0;
                    try {
                        availableBytes = this.inputStream.available();
                    }
                    catch (Exception e) {
                        throw new IOException("Error, unexpected EOS while constructing QString.");
                    }
                    if (bytesToRead > availableBytes) {
                        bytesToRead = availableBytes;
                    }
                    int readPos = expandedLen + compressedBytesConsumed;
                    this.readIntoScratchBuffer(readPos, bytesToRead);
                    int charsToWrite = expandedLen / 4 * 4;
                    int writePos = 0;
                    while (writePos < charsToWrite) {
                        int b0 = this.scratchBuffer[readPos] & 0xFF;
                        int b1 = this.scratchBuffer[readPos + 1] & 0xFF;
                        int b2 = this.scratchBuffer[readPos + 2] & 0xFF;
                        this.scratchBuffer[strByteLen + writePos + 0] = (byte)(32 + (b0 >> 2));
                        this.scratchBuffer[strByteLen + writePos + 1] = (byte)(32 + ((b0 & 3) << 4 | b1 >> 4));
                        this.scratchBuffer[strByteLen + writePos + 2] = (byte)(32 + ((b1 & 0xF) << 2 | b2 >> 6));
                        this.scratchBuffer[strByteLen + writePos + 3] = (byte)(32 + (b2 & 0x3F));
                        compressedBytesConsumed += 3;
                        writePos += 4;
                        readPos += 3;
                    }
                    compressedBytesRead += bytesToRead;
                    strByteLen += writePos;
                }
                int writePos = 0;
                int readPos = expandedLen + compressedBytesConsumed;
                int remainingChars = expandedLen - strByteLen;
                switch (remainingChars) {
                    case 3: {
                        int b1 = this.scratchBuffer[readPos + 1] & 0xFF;
                        int b2 = this.scratchBuffer[readPos + 2] & 0xFF;
                        this.scratchBuffer[strByteLen + writePos + 2] = (byte)(32 + ((b1 & 0xF) << 2 | b2 >> 6));
                    }
                    case 2: {
                        int b0 = this.scratchBuffer[readPos] & 0xFF;
                        int b1 = this.scratchBuffer[readPos + 1] & 0xFF;
                        this.scratchBuffer[strByteLen + writePos + 1] = (byte)(32 + ((b0 & 3) << 4 | b1 >> 4));
                    }
                    case 1: {
                        int b0 = this.scratchBuffer[readPos] & 0xFF;
                        this.scratchBuffer[strByteLen + writePos + 0] = (byte)(32 + (b0 >> 2));
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IOException("Error while parsing QSTR invalid number of residual bytes: " + remainingChars);
                    }
                }
                strByteLen += writePos + remainingChars;
                break;
            }
            default: {
                throw new IOException("Unknown source type");
            }
        }
        int[] strRange = new int[]{0, strByteLen};
        if (shouldTrim) {
            boolean isUnicode = styp == HpccSrcType.UTF16BE || styp == HpccSrcType.UTF16LE;
            this.trimStringInScratchBuffer(isUnicode, strRange);
        }
        if ((strByteLen = strRange[1] - strRange[0]) == 0 && this.convertEmptyStringsToNull) {
            return null;
        }
        return new String(this.scratchBuffer, strRange[0], strByteLen, charset);
    }

    private int getLenFromCodePoints(HpccSrcType styp, int cp) throws IOException {
        int bytes = 0;
        switch (styp) {
            case UTF8: {
                throw new IOException("BinaryRecordReader: getCodeUnits does not support scanning utf8 strings.");
            }
            case QSTRING: {
                bytes = (cp + 1) * 3 / 4;
                break;
            }
            case SINGLE_BYTE_CHAR: {
                bytes = cp;
                break;
            }
            case UTF16BE: {
                bytes = cp * 2;
                break;
            }
            case UTF16LE: {
                bytes = cp * 2;
                break;
            }
            default: {
                throw new IOException("Unknown data source type for a string of: " + styp.toString());
            }
        }
        return bytes;
    }
}

