/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import com.google.common.io.BaseEncoding;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CheckSum {
    private static final int BUFFER_SIZE = 65536;
    private MessageDigest digest;

    public CheckSum(String digestAlgorithm) throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(digestAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getChecksumBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            this.digest.reset();
            this.readStream(fis);
            byte[] byArray = this.digest.digest();
            return byArray;
        }
        finally {
            Closeables.closeQuietly((InputStream)fis);
        }
    }

    public String getChecksum(File file) throws IOException {
        return BaseEncoding.base16().encode(this.getChecksumBytes(file));
    }

    private void readStream(FileInputStream fis) throws IOException {
        int bytes;
        FileChannel fileChannel = fis.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        while ((bytes = fileChannel.read(byteBuffer)) >= 0) {
            byteBuffer.flip();
            this.digest.update(byteBuffer);
            byteBuffer.clear();
        }
    }
}

