/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.xjc.plugin;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.util.List;
import org.hisrc.jsonix.args4j.PartialCmdLineParser;
import org.hisrc.jsonix.configuration.PluginCustomizations;
import org.hisrc.jsonix.execution.JsonixInvoker;
import org.hisrc.jsonix.settings.Settings;
import org.hisrc.jsonix.xjc.plugin.CodeModelJsonStructureWriter;
import org.hisrc.jsonix.xjc.plugin.CodeModelProgramWriter;
import org.kohsuke.args4j.CmdLineException;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JsonixPlugin
extends Plugin {
    private final PluginCustomizations pluginCustomizations = new PluginCustomizations();
    public static final String OPTION_NAME = "Xjsonix";
    public static final String OPTION = "-Xjsonix";
    private Settings settings = new Settings();

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xjsonix :  Generates Jsonix mappings.\n                    See https://github.com/highsource/jsonix";
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        PartialCmdLineParser cmdLineParser = new PartialCmdLineParser(this.getSettings());
        try {
            return cmdLineParser.parseArgument(args, i);
        }
        catch (CmdLineException clex) {
            throw new BadCommandLineException("Error parsing arguments.", (Throwable)clex);
        }
    }

    public void onActivated(Options opts) throws BadCommandLineException {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory instanceof NOPLoggerFactory) {
            System.err.println("You seem to be using the NOP provider of the SLF4j logging facade. With this configuration, log messages will be completely suppressed. Please consider adding a SLF4j provider (for instance slf4j-simple) to enable logging.");
        }
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
    }

    public List<String> getCustomizationURIs() {
        return this.pluginCustomizations.getCustomizationURIs();
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return this.pluginCustomizations.isCustomizationTagName(nsUri, localName);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        Model model = outline.getModel();
        JCodeModel codeModel = outline.getCodeModel();
        CodeModelProgramWriter programWriter = new CodeModelProgramWriter(codeModel, errorHandler);
        CodeModelJsonStructureWriter jsonStructureWriter = new CodeModelJsonStructureWriter(codeModel, errorHandler);
        new JsonixInvoker().execute(this.getSettings(), model, programWriter, jsonStructureWriter);
        return true;
    }
}

