/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.xjc.plugin;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.fmt.JTextFile;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.spi.JsonProvider;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.compilation.jsonschema.JsonStructureWriter;
import org.hisrc.jsonix.definition.Module;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CodeModelJsonStructureWriter
implements JsonStructureWriter<NType, NClass> {
    private final JCodeModel codeModel;
    private final ErrorHandler errorHandler;
    private final JsonProvider provider = JsonProvider.provider();

    public CodeModelJsonStructureWriter(JCodeModel codeModel, ErrorHandler errorHandler) {
        this.codeModel = (JCodeModel)Validate.notNull((Object)codeModel);
        this.errorHandler = (ErrorHandler)Validate.notNull((Object)errorHandler);
    }

    @Override
    public void writeJsonStructure(Module<NType, NClass> module, JsonStructure structure, String fileName) {
        try {
            JPackage _package = this.codeModel._package("");
            _package.addResourceFile((JResourceFile)this.createTextFile(fileName, structure));
        }
        catch (IOException ioex) {
            try {
                this.errorHandler.error(new SAXParseException(MessageFormat.format("Could not create the code for the module [{0}].", module.getName()), null, ioex));
            }
            catch (SAXException ignored) {
                // empty catch block
            }
        }
    }

    private JTextFile createTextFile(String fileName, JsonStructure jsonStructure) throws IOException {
        Validate.notNull((Object)fileName);
        JTextFile textFile = new JTextFile(fileName);
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = this.provider.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE)).createWriter((Writer)stringWriter);
        jsonWriter.write(jsonStructure);
        textFile.setContents(stringWriter.toString());
        return textFile;
    }
}

