/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.definition;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.configuration.exception.AmbiguousPackageMappingNameException;
import org.hisrc.jsonix.configuration.exception.AmbiguousPackageSchemaIdException;
import org.hisrc.jsonix.context.JsonixContext;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.Module;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.slf4j.Logger;

public class Modules<T, C extends T> {
    private final Logger logger;
    private final Collection<Module<T, C>> modules;
    private final Map<String, String> packageMappingNameMap = new HashMap<String, String>();
    private final Map<String, String> packageSchemaIdMap = new HashMap<String, String>();
    private final MModelInfo<T, C> modelInfo;

    public Modules(JsonixContext context, MModelInfo<T, C> modelInfo, Collection<Module<T, C>> modules) {
        Validate.notNull(modelInfo);
        Validate.noNullElements(modules);
        this.logger = ((JsonixContext)Validate.notNull((Object)context)).getLoggerFactory().getLogger(Modules.class.getName());
        this.modelInfo = modelInfo;
        this.modules = modules;
        for (Module<T, C> module : modules) {
            for (Mapping<T, C> mapping : module.getMappings()) {
                String packageName = mapping.getPackageName();
                String mappingName = mapping.getMappingName();
                String knownMappingName = this.packageMappingNameMap.get(packageName);
                if (knownMappingName == null) {
                    this.packageMappingNameMap.put(packageName, mappingName);
                } else if (!knownMappingName.equals(mappingName)) {
                    this.logger.warn(MessageFormat.format("Package [{0}] is mapped using at least two different mapping names [{1}] and [{2}]. Packages may be mapped by several mappings but they have to have equal names.", packageName, knownMappingName, mappingName));
                    throw new AmbiguousPackageMappingNameException(packageName, knownMappingName, mappingName);
                }
                String mappingSchemaId = mapping.getSchemaId();
                String knownSchemaId = this.packageSchemaIdMap.get(packageName);
                if (knownSchemaId == null) {
                    this.packageSchemaIdMap.put(packageName, mappingSchemaId);
                    continue;
                }
                if (knownSchemaId.equals(mappingSchemaId)) continue;
                this.logger.warn(MessageFormat.format("Package [{0}] is mapped using at least two different schema ids [{1}] and [{2}]. Packages may be mapped by several mappings but they have to have equal schema ids. Please use the [jsonix:module/@schemaId] or [jsonix:mapping/@schemaId] attribute and specify the same schema id in both mappings.", packageName, knownSchemaId, mappingSchemaId));
                throw new AmbiguousPackageSchemaIdException(packageName, knownSchemaId, mappingSchemaId);
            }
        }
    }

    public MModelInfo<T, C> getModelInfo() {
        return this.modelInfo;
    }

    public String getMappingName(String packageName) {
        return this.packageMappingNameMap.get(packageName);
    }

    public String getSchemaId(String packageName) {
        return this.packageSchemaIdMap.get(packageName);
    }

    public Collection<Module<T, C>> getModules() {
        return this.modules;
    }

    public String toString() {
        return this.modules.toString();
    }
}

