/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.definition;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.definition.JsonSchema;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.Output;

public class Module<T, C extends T> {
    private final String name;
    private final String schemaId;
    private final List<Mapping<T, C>> mappings;
    private final List<Output> outputs;
    private final List<JsonSchema> jsonSchemas;

    public Module(String name, String schemaId, List<Mapping<T, C>> mappings, List<Output> outputs, List<JsonSchema> jsonSchemas) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)schemaId);
        Validate.noNullElements(mappings);
        Validate.noNullElements(outputs);
        Validate.noNullElements(jsonSchemas);
        this.name = name;
        this.schemaId = schemaId;
        this.mappings = mappings;
        this.outputs = outputs;
        this.jsonSchemas = jsonSchemas;
    }

    public boolean isEmpty() {
        for (Mapping<T, C> mapping : this.getMappings()) {
            if (mapping.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public List<Mapping<T, C>> getMappings() {
        return this.mappings;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public List<JsonSchema> getJsonSchemas() {
        return this.jsonSchemas;
    }

    public String toString() {
        return MessageFormat.format("Module [{0}].", this.name);
    }
}

