/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.configuration;

import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.Model;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.configuration.DependenciesOfMappingConfiguration;
import org.hisrc.jsonix.configuration.ElementInfoConfiguration;
import org.hisrc.jsonix.configuration.ExcludesConfiguration;
import org.hisrc.jsonix.configuration.IncludesConfiguration;
import org.hisrc.jsonix.configuration.JsonSchemaConfiguration;
import org.hisrc.jsonix.configuration.MappingConfiguration;
import org.hisrc.jsonix.configuration.ModuleConfiguration;
import org.hisrc.jsonix.configuration.ModulesConfiguration;
import org.hisrc.jsonix.configuration.OutputConfiguration;
import org.hisrc.jsonix.configuration.PackageMapping;
import org.hisrc.jsonix.configuration.PropertyInfoConfiguration;
import org.hisrc.jsonix.configuration.TypeInfoConfiguration;
import org.hisrc.jsonix.configuration.exception.ConfigurationUnmarshallingException;
import org.hisrc.jsonix.context.JsonixContext;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ModulesConfigurationUnmarshaller {
    private final Logger logger;
    private final JsonixContext context;
    private final JAXBContext jaxbContext;
    public static final List<String> CUSTOMIZATION_URIS = Collections.singletonList("http://jsonix.highsource.org/customizations");
    private static final Set<String> CUSTOMIZATION_LOCAL_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("packageMapping", "modules", "module", "mapping", "output", "jsonSchema", "includes", "excludes", "dependencies-of-mapping", "type", "element", "property"));

    public ModulesConfigurationUnmarshaller(JsonixContext context) {
        this.context = (JsonixContext)Validate.notNull((Object)context);
        this.logger = this.context.getLoggerFactory().getLogger(ModuleConfiguration.class.getName());
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ModulesConfiguration.class, ModuleConfiguration.class, MappingConfiguration.class, OutputConfiguration.class, JsonSchemaConfiguration.class, PackageMapping.class, IncludesConfiguration.class, ExcludesConfiguration.class, TypeInfoConfiguration.class, ElementInfoConfiguration.class, PropertyInfoConfiguration.class, DependenciesOfMappingConfiguration.class});
        }
        catch (JAXBException jaxbex) {
            throw new ExceptionInInitializerError(jaxbex);
        }
    }

    public List<String> getCustomizationURIs() {
        return CUSTOMIZATION_URIS;
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return CUSTOMIZATION_URIS.contains(nsUri) && CUSTOMIZATION_LOCAL_ELEMENT_NAMES.contains(localName);
    }

    private <T> T unmarshal(CPluginCustomization customization, String description) {
        try {
            Object value = this.jaxbContext.createUnmarshaller().unmarshal((Node)customization.element);
            return (T)value;
        }
        catch (JAXBException jaxbex) {
            throw customization.locator == null ? new ConfigurationUnmarshallingException(description) : new ConfigurationUnmarshallingException(description, customization.locator);
        }
    }

    public ModulesConfiguration unmarshal(Model model, OutputConfiguration defaultOutputConfiguration, JsonSchemaConfiguration defaultJsonSchemaConfiguration) {
        Validate.notNull((Object)model);
        Validate.notNull((Object)defaultOutputConfiguration);
        ModulesConfiguration modulesConfiguration = new ModulesConfiguration();
        for (CPluginCustomization customization : CustomizationUtils.findCustomizations((Model)model, (QName)PackageMapping.PACKAGE_MAPPING_NAME)) {
            modulesConfiguration.getMappingConfigurations().add(this.unmarshalPackageMapping(customization));
        }
        for (CPluginCustomization customization : CustomizationUtils.findCustomizations((Model)model, (QName)ModuleConfiguration.MODULE_NAME)) {
            modulesConfiguration.getModuleConfigurations().add(this.unmarshalModuleConfiguration(customization));
        }
        for (CPluginCustomization customization : CustomizationUtils.findCustomizations((Model)model, (QName)MappingConfiguration.MAPPING_NAME)) {
            modulesConfiguration.getMappingConfigurations().add(this.unmarshalMappingConfiguration(customization));
        }
        for (CPluginCustomization customization : CustomizationUtils.findCustomizations((Model)model, (QName)OutputConfiguration.OUTPUT_NAME)) {
            modulesConfiguration.getOutputConfigurations().add(this.unmarshalOutputConfiguration(customization));
        }
        if (modulesConfiguration.getOutputConfigurations().isEmpty()) {
            modulesConfiguration.getOutputConfigurations().add(defaultOutputConfiguration);
        }
        for (CPluginCustomization customization : CustomizationUtils.findCustomizations((Model)model, (QName)JsonSchemaConfiguration.JSON_SCHEMA_NAME)) {
            modulesConfiguration.getJsonSchemaConfigurations().add(this.unmarshalJsonSchemaConfiguration(customization));
        }
        if (modulesConfiguration.getJsonSchemaConfigurations().isEmpty() && defaultJsonSchemaConfiguration != null) {
            modulesConfiguration.getJsonSchemaConfigurations().add(defaultJsonSchemaConfiguration);
        }
        return modulesConfiguration;
    }

    private MappingConfiguration unmarshalPackageMapping(CPluginCustomization customization) {
        PackageMapping packageMapping = (PackageMapping)this.unmarshal(customization, "package mapping");
        this.logger.warn("The [packageMapping] customization is deprecated, please use the [mapping] customization in the future.");
        MappingConfiguration mappingConfiguration = new MappingConfiguration();
        mappingConfiguration.setName(packageMapping.getSpaceName());
        mappingConfiguration.setPackage(packageMapping.getPackageName());
        mappingConfiguration.setDefaultElementNamespaceURI(packageMapping.getDefaultElementNamespaceURI());
        mappingConfiguration.setDefaultAttributeNamespaceURI(packageMapping.getDefaultAttributeNamespaceURI());
        return mappingConfiguration;
    }

    private ModuleConfiguration unmarshalModuleConfiguration(CPluginCustomization customization) {
        return (ModuleConfiguration)this.unmarshal(customization, "module configuration");
    }

    private MappingConfiguration unmarshalMappingConfiguration(CPluginCustomization customization) {
        return (MappingConfiguration)this.unmarshal(customization, "mapping configuration");
    }

    private OutputConfiguration unmarshalOutputConfiguration(CPluginCustomization customization) {
        return (OutputConfiguration)this.unmarshal(customization, "output configuration");
    }

    private JsonSchemaConfiguration unmarshalJsonSchemaConfiguration(CPluginCustomization customization) {
        return (JsonSchemaConfiguration)this.unmarshal(customization, "JSON Schema configuration");
    }
}

