/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping.typeinfo;

import com.sun.xml.xsom.XmlString;
import org.apache.commons.lang3.Validate;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSArrayLiteral;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jsonix.compilation.mapping.IsLiteralEquals;
import org.hisrc.jsonix.compilation.mapping.MappingCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.TypeInfoCompiler;
import org.hisrc.jsonix.naming.Naming;
import org.jvnet.jaxb2_commons.xml.bind.model.MList;

public class ListCompiler<T, C extends T>
implements TypeInfoCompiler<T, C> {
    private final MList<T, C> typeInfo;
    private final TypeInfoCompiler<T, C> itemTypeInfoCompiler;

    public ListCompiler(MList<T, C> typeInfo, TypeInfoCompiler<T, C> itemTypeInfoCompiler) {
        Validate.notNull(typeInfo);
        Validate.notNull(itemTypeInfoCompiler);
        this.typeInfo = typeInfo;
        this.itemTypeInfoCompiler = itemTypeInfoCompiler;
    }

    @Override
    public JSAssignmentExpression createTypeInfoDeclaration(MappingCompiler<T, C> mappingCompiler) {
        Validate.notNull(mappingCompiler);
        JSCodeModel codeModel = mappingCompiler.getCodeModel();
        Naming naming = mappingCompiler.getNaming();
        JSObjectLiteral list = codeModel.object();
        list.append(naming.type(), (JSAssignmentExpression)codeModel.string(naming.list()));
        JSAssignmentExpression typeInfoDeclaration = this.itemTypeInfoCompiler.createTypeInfoDeclaration(mappingCompiler);
        if (!((Boolean)typeInfoDeclaration.acceptExpressionVisitor((JSExpressionVisitor)new IsLiteralEquals("String"))).booleanValue()) {
            list.append(naming.baseTypeInfo(), typeInfoDeclaration);
        }
        return list;
    }

    @Override
    public JSAssignmentExpression createValue(MappingCompiler<T, C> mappingCompiler, XmlString item) {
        JSCodeModel codeModel = mappingCompiler.getCodeModel();
        String[] values = item.value.split(" ");
        JSArrayLiteral result = codeModel.array();
        for (String value : values) {
            JSAssignmentExpression v = this.itemTypeInfoCompiler.createValue(mappingCompiler, new XmlString(value, item.context));
            if (v == null) {
                return null;
            }
            result.append(new JSAssignmentExpression[]{v});
        }
        return result;
    }

    @Override
    public JSAssignmentExpression createValue(MappingCompiler<T, C> mappingCompiler, String item) {
        JSCodeModel codeModel = mappingCompiler.getCodeModel();
        String[] values = item.split(" ");
        JSArrayLiteral result = codeModel.array();
        for (String value : values) {
            JSAssignmentExpression v = this.itemTypeInfoCompiler.createValue(mappingCompiler, value);
            if (v == null) {
                return null;
            }
            result.append(new JSAssignmentExpression[]{v});
        }
        return result;
    }

    @Override
    public JSObjectLiteral compile(MappingCompiler<T, C> mappingCompiler) {
        throw new UnsupportedOperationException();
    }
}

