/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping.typeinfo;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSArrayLiteral;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jscm.codemodel.literal.JSNullLiteral;
import org.hisrc.jsonix.compilation.mapping.MappingCompiler;
import org.hisrc.jsonix.compilation.mapping.PropertyInfoVisitor;
import org.hisrc.jsonix.compilation.mapping.typeinfo.PackagedTypeInfoCompiler;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.naming.Naming;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackagedTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;

public class ClassInfoCompiler<T, C extends T>
extends PackagedTypeInfoCompiler<T, C> {
    private MClassInfo<T, C> classInfo;

    public ClassInfoCompiler(MClassInfo<T, C> classInfo) {
        super((MPackagedTypeInfo)Validate.notNull(classInfo));
        this.classInfo = classInfo;
    }

    @Override
    public JSObjectLiteral compile(MappingCompiler<T, C> mappingCompiler) {
        JSArrayLiteral ps;
        MClassTypeInfo baseTypeInfo;
        JSCodeModel codeModel = mappingCompiler.getCodeModel();
        Mapping<T, C> mapping = mappingCompiler.getMapping();
        Naming naming = mappingCompiler.getNaming();
        JSObjectLiteral classInfoMapping = codeModel.object();
        String localName = this.classInfo.getContainerLocalName(".");
        classInfoMapping.append(naming.localName(), (JSAssignmentExpression)codeModel.string(localName));
        String targetNamespace = mapping.getTargetNamespaceURI();
        QName defaultTypeName = new QName(targetNamespace, localName);
        QName typeName = this.classInfo.getTypeName();
        if (!defaultTypeName.equals(typeName)) {
            JSNullLiteral typeNameExpression;
            if (typeName == null) {
                typeNameExpression = codeModel._null();
            } else if (defaultTypeName.getNamespaceURI().equals(typeName.getNamespaceURI())) {
                typeNameExpression = codeModel.string(typeName.getLocalPart());
            } else {
                JSObjectLiteral typeNameObject = codeModel.object();
                typeNameObject.append(naming.namespaceURI(), (JSAssignmentExpression)codeModel.string(typeName.getNamespaceURI()));
                typeNameObject.append(naming.localPart(), (JSAssignmentExpression)codeModel.string(typeName.getLocalPart()));
                if (!"".equals(typeName.getPrefix())) {
                    typeNameObject.append(naming.prefix(), (JSAssignmentExpression)codeModel.string(typeName.getPrefix()));
                }
                typeNameExpression = typeNameObject;
            }
            classInfoMapping.append(naming.typeName(), (JSAssignmentExpression)typeNameExpression);
        }
        if ((baseTypeInfo = this.classInfo.getBaseTypeInfo()) != null) {
            classInfoMapping.append(naming.baseTypeInfo(), mappingCompiler.getTypeInfoCompiler(this.classInfo, (MTypeInfo<T, C>)baseTypeInfo).createTypeInfoDeclaration(mappingCompiler));
        }
        if (!(ps = this.compilePropertyInfos(mappingCompiler)).getElements().isEmpty()) {
            classInfoMapping.append(naming.propertyInfos(), (JSAssignmentExpression)ps);
        }
        return classInfoMapping;
    }

    private JSArrayLiteral compilePropertyInfos(MappingCompiler<T, C> mappingCompiler) {
        JSCodeModel codeModel = mappingCompiler.getCodeModel();
        Mapping<T, C> mapping = mappingCompiler.getMapping();
        JSArrayLiteral propertyInfoMappings = codeModel.array();
        for (MPropertyInfo propertyInfo : this.classInfo.getProperties()) {
            if (!mapping.getPropertyInfos().contains(propertyInfo)) continue;
            propertyInfoMappings.append(new JSAssignmentExpression[]{(JSAssignmentExpression)propertyInfo.acceptPropertyInfoVisitor(new PropertyInfoVisitor<T, C>(mappingCompiler))});
        }
        return propertyInfoMappings;
    }
}

