/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping;

import com.sun.tools.xjc.model.Multiplicity;
import com.sun.xml.xsom.visitor.XSFunction;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSArrayLiteral;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSMemberExpression;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jsonix.compilation.mapping.CreateTypeInfoDelaration;
import org.hisrc.jsonix.compilation.mapping.IsLiteralEquals;
import org.hisrc.jsonix.compilation.mapping.MappingCompiler;
import org.hisrc.jsonix.naming.Naming;
import org.hisrc.jsonix.xml.xsom.ParticleMultiplicityCounter;
import org.hisrc.xml.xsom.XSFunctionApplier;
import org.jvnet.jaxb2_commons.xml.bind.model.MAnyAttributePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MAnyElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MAttributePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementRefPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementRefsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementTypeInfos;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MMixable;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MSingleTypePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MValuePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MWildcard;
import org.jvnet.jaxb2_commons.xml.bind.model.MWrappable;

public final class PropertyInfoVisitor<T, C extends T>
implements MPropertyInfoVisitor<T, C, JSObjectLiteral> {
    private final JSCodeModel codeModel;
    private final MappingCompiler<T, C> mappingCompiler;
    private final Naming naming;
    private final XSFunctionApplier<Multiplicity> multiplicityCounter = new XSFunctionApplier((XSFunction)ParticleMultiplicityCounter.INSTANCE);

    public PropertyInfoVisitor(MappingCompiler<T, C> mappingCompiler) {
        Validate.notNull(mappingCompiler);
        this.codeModel = mappingCompiler.getCodeModel();
        this.mappingCompiler = mappingCompiler;
        this.naming = mappingCompiler.getNaming();
    }

    private void createPropertyInfoOptions(MPropertyInfo<T, C> propertyInfo, JSObjectLiteral options) {
        options.append(this.naming.name(), (JSAssignmentExpression)this.codeModel.string(propertyInfo.getPrivateName()));
        Multiplicity multiplicity = (Multiplicity)this.multiplicityCounter.apply(propertyInfo.getOrigin());
        if (multiplicity != null) {
            if (multiplicity.min != null && !BigInteger.ZERO.equals(multiplicity.min)) {
                options.append(this.naming.required(), (JSAssignmentExpression)this.codeModel._boolean(true));
            }
            if (propertyInfo.isCollection()) {
                if (multiplicity.min != null && !BigInteger.ONE.equals(multiplicity.min)) {
                    options.append(this.naming.minOccurs(), (JSAssignmentExpression)this.codeModel.integer(multiplicity.min.longValue()));
                }
                if (multiplicity.max != null) {
                    options.append(this.naming.maxOccurs(), (JSAssignmentExpression)this.codeModel.integer(multiplicity.max.longValue()));
                }
            }
        }
        if (propertyInfo.isCollection()) {
            options.append(this.naming.collection(), (JSAssignmentExpression)this.codeModel._boolean(true));
        }
    }

    private <M extends MElementTypeInfo<T, C, O>, O> void createTypedOptions(M elementTypeInfo, JSObjectLiteral options) {
        MTypeInfo typeInfo = elementTypeInfo.getTypeInfo();
        typeInfo.acceptTypeInfoVisitor(new CreateTypeInfoDelaration(this.mappingCompiler, elementTypeInfo, options));
    }

    private void createTypedOptions(MSingleTypePropertyInfo<T, C> propertyInfo, JSObjectLiteral options) {
        MTypeInfo typeInfo = propertyInfo.getTypeInfo();
        typeInfo.acceptTypeInfoVisitor(new CreateTypeInfoDelaration(this.mappingCompiler, propertyInfo, options));
    }

    private void createWrappableOptions(MWrappable info, JSObjectLiteral options) {
        QName wrapperElementName = info.getWrapperElementName();
        if (wrapperElementName != null) {
            options.append(this.naming.wrapperElementName(), (JSAssignmentExpression)this.mappingCompiler.createElementNameExpression(wrapperElementName));
        }
    }

    private <M extends MElementTypeInfo<T, C, O>, O> void createElementTypeInfoOptions(M info, JSObjectLiteral options) {
        QName elementName = info.getElementName();
        options.append(this.naming.elementName(), (JSAssignmentExpression)this.mappingCompiler.createElementNameExpression(elementName));
        this.createTypedOptions(info, options);
    }

    private <M extends MElementTypeInfo<T, C, O>, O> void createElementTypeInfoOptions(M info, String privateName, QName elementName, JSObjectLiteral options) {
        JSMemberExpression elementNameExpression = this.mappingCompiler.createElementNameExpression(elementName);
        if (!((Boolean)elementNameExpression.acceptExpressionVisitor((JSExpressionVisitor)new IsLiteralEquals(privateName))).booleanValue()) {
            options.append(this.naming.elementName(), (JSAssignmentExpression)elementNameExpression);
        }
        this.createTypedOptions(info, options);
    }

    private void createWildcardOptions(MWildcard info, JSObjectLiteral options) {
        if (!info.isDomAllowed()) {
            options.append(this.naming.allowDom(), (JSAssignmentExpression)this.codeModel._boolean(false));
        }
        if (!info.isTypedObjectAllowed()) {
            options.append(this.naming.allowTypedObject(), (JSAssignmentExpression)this.codeModel._boolean(false));
        }
    }

    private void createMixableOptions(MMixable info, JSObjectLiteral options) {
        if (!info.isMixed()) {
            options.append(this.naming.mixed(), (JSAssignmentExpression)this.codeModel._boolean(false));
        }
    }

    public JSObjectLiteral visitElementPropertyInfo(MElementPropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createWrappableOptions((MWrappable)info, options);
        this.createElementTypeInfoOptions((MElementTypeInfo)info, info.getPrivateName(), info.getElementName(), options);
        return options;
    }

    public JSObjectLiteral visitElementsPropertyInfo(MElementsPropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createWrappableOptions((MWrappable)info, options);
        this.createElementTypeInfosOptions((MElementTypeInfos)info, options);
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.elements()));
        return options;
    }

    private <M extends MElementTypeInfo<T, C, O>, O> void createElementTypeInfosOptions(MElementTypeInfos<T, C, M, O> info, JSObjectLiteral options) {
        if (!info.getElementTypeInfos().isEmpty()) {
            JSArrayLiteral elementTypeInfos = this.codeModel.array();
            options.append(this.naming.elementTypeInfos(), (JSAssignmentExpression)elementTypeInfos);
            for (MElementTypeInfo elementTypeInfo : info.getElementTypeInfos()) {
                JSObjectLiteral elementTypeInfoOptions = this.codeModel.object();
                this.createElementTypeInfoOptions(elementTypeInfo, elementTypeInfoOptions);
                elementTypeInfos.append(new JSAssignmentExpression[]{elementTypeInfoOptions});
            }
        }
    }

    public JSObjectLiteral visitAnyElementPropertyInfo(MAnyElementPropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createWildcardOptions((MWildcard)info, options);
        this.createMixableOptions((MMixable)info, options);
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.anyElement()));
        return options;
    }

    public JSObjectLiteral visitAttributePropertyInfo(MAttributePropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createTypedOptions((MSingleTypePropertyInfo<T, C>)info, options);
        JSMemberExpression attributeNameExpression = this.mappingCompiler.createAttributeNameExpression(info.getAttributeName());
        if (!((Boolean)attributeNameExpression.acceptExpressionVisitor((JSExpressionVisitor)new IsLiteralEquals(info.getPrivateName()))).booleanValue()) {
            options.append(this.naming.attributeName(), (JSAssignmentExpression)attributeNameExpression);
        }
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.attribute()));
        return options;
    }

    public JSObjectLiteral visitAnyAttributePropertyInfo(MAnyAttributePropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.anyAttribute()));
        return options;
    }

    public JSObjectLiteral visitValuePropertyInfo(MValuePropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createTypedOptions((MSingleTypePropertyInfo<T, C>)info, options);
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.value()));
        return options;
    }

    public JSObjectLiteral visitElementRefPropertyInfo(MElementRefPropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createMixableOptions((MMixable)info, options);
        this.createWrappableOptions((MWrappable)info, options);
        this.createWildcardOptions((MWildcard)info, options);
        this.createElementTypeInfoOptions((MElementTypeInfo)info, info.getPrivateName(), info.getElementName(), options);
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.elementRef()));
        return options;
    }

    public JSObjectLiteral visitElementRefsPropertyInfo(MElementRefsPropertyInfo<T, C> info) {
        JSObjectLiteral options = this.codeModel.object();
        this.createPropertyInfoOptions((MPropertyInfo<T, C>)info, options);
        this.createMixableOptions((MMixable)info, options);
        this.createWrappableOptions((MWrappable)info, options);
        this.createWildcardOptions((MWildcard)info, options);
        this.createElementTypeInfosOptions((MElementTypeInfos)info, options);
        options.append(this.naming.type(), (JSAssignmentExpression)this.codeModel.string(this.naming.elementRefs()));
        return options;
    }
}

