/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.args4j;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.args4j.Messages;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Localizable;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;

public class PartialCmdLineParser
extends CmdLineParser {
    private OptionHandler<?> currentOptionHandler;

    public PartialCmdLineParser(Object bean) {
        super(bean);
    }

    public PartialCmdLineParser(Object bean, ParserProperties parserProperties) {
        super(bean, parserProperties);
    }

    public int parseArgument(String[] args, int position) throws CmdLineException {
        Validate.noNullElements((Object[])args);
        this.currentOptionHandler = null;
        CmdLineImpl cmdLine = new CmdLineImpl(args, position);
        HashSet present = new HashSet();
        int argIndex = position;
        int consumed = 0;
        while (cmdLine.hasMore()) {
            String arg = cmdLine.getCurrentToken();
            if (this.isOption(arg)) {
                boolean isKeyValuePair = arg.contains(this.getProperties().getOptionValueDelimiter()) || arg.indexOf(61) != -1;
                OptionHandler<?> optionHandler = this.currentOptionHandler = isKeyValuePair ? this.findOptionHandler(arg) : this.findOptionByName(arg);
                if (this.currentOptionHandler == null) {
                    return consumed;
                }
                if (isKeyValuePair) {
                    cmdLine.splitToken();
                } else {
                    cmdLine.proceed(1);
                    ++consumed;
                }
            } else {
                if (argIndex >= this.getArguments().size()) {
                    return consumed;
                }
                this.currentOptionHandler = (OptionHandler)this.getArguments().get(argIndex);
                if (this.currentOptionHandler == null) {
                    throw new IllegalStateException("@Argument with index=" + argIndex + " is undefined");
                }
                if (!this.currentOptionHandler.option.isMultiValued()) {
                    ++argIndex;
                }
            }
            int diff = this.currentOptionHandler.parseArguments((Parameters)cmdLine);
            cmdLine.proceed(diff);
            consumed += diff;
            present.add(this.currentOptionHandler);
        }
        boolean helpSet = false;
        for (OptionHandler handler : this.getOptions()) {
            if (!handler.option.help() || !present.contains(handler)) continue;
            helpSet = true;
        }
        if (!helpSet) {
            this.checkRequiredOptionsAndArguments(present);
        }
        return consumed;
    }

    private OptionHandler<?> findOptionHandler(String name) {
        int pos = name.indexOf(this.getProperties().getOptionValueDelimiter());
        if (pos < 0) {
            pos = name.indexOf(61);
        }
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return this.findOptionByName(name);
    }

    private OptionHandler<?> findOptionByName(String name) {
        for (OptionHandler h : this.getOptions()) {
            NamedOptionDef option = (NamedOptionDef)h.option;
            if (name.equals(option.name())) {
                return h;
            }
            for (String alias : option.aliases()) {
                if (!name.equals(alias)) continue;
                return h;
            }
        }
        return null;
    }

    private void checkRequiredOptionsAndArguments(Set<OptionHandler<?>> present) throws CmdLineException {
        for (OptionHandler optionHandler : this.getOptions()) {
            if (!optionHandler.option.required() || present.contains(optionHandler)) continue;
            throw new CmdLineException((CmdLineParser)this, (Localizable)Messages.REQUIRED_OPTION_MISSING, new String[]{optionHandler.option.toString()});
        }
        for (OptionHandler optionHandler : this.getOptions()) {
            if (!optionHandler.option.required() || present.contains(optionHandler)) continue;
            throw new CmdLineException((CmdLineParser)this, (Localizable)Messages.REQUIRED_ARGUMENT_MISSING, new String[]{optionHandler.option.toString()});
        }
        for (OptionHandler optionHandler : present) {
            if (!(optionHandler.option instanceof NamedOptionDef) || this.isHandlerHasHisOptions((NamedOptionDef)optionHandler.option, present)) continue;
            throw new CmdLineException((CmdLineParser)this, (Localizable)Messages.REQUIRES_OPTION_MISSING, new String[]{optionHandler.option.toString(), Arrays.toString(((NamedOptionDef)optionHandler.option).depends())});
        }
        for (OptionHandler optionHandler : present) {
            if (!(optionHandler.option instanceof NamedOptionDef) || this.isHandlerAllowOtherOptions((NamedOptionDef)optionHandler.option, present)) continue;
            throw new CmdLineException((CmdLineParser)this, (Localizable)Messages.FORBIDDEN_OPTION_PRESENT, new String[]{optionHandler.option.toString(), Arrays.toString(((NamedOptionDef)optionHandler.option).forbids())});
        }
    }

    private boolean isHandlerHasHisOptions(NamedOptionDef option, Set<OptionHandler<?>> present) {
        for (String depend : option.depends()) {
            if (present.contains(this.findOptionHandler(depend))) continue;
            return false;
        }
        return true;
    }

    private boolean isHandlerAllowOtherOptions(NamedOptionDef option, Set<OptionHandler<?>> present) {
        for (String forbid : option.forbids()) {
            if (!present.contains(this.findOptionHandler(forbid))) continue;
            return false;
        }
        return true;
    }

    private String getOptionName() {
        return this.currentOptionHandler.option.toString();
    }

    private class CmdLineImpl
    implements Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] args, int position) {
            this.args = args;
            this.pos = position;
        }

        protected boolean hasMore() {
            return this.pos < this.args.length;
        }

        protected String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        public String getParameter(int idx) throws CmdLineException {
            if (this.pos + idx >= this.args.length || this.pos + idx < 0) {
                throw new CmdLineException((CmdLineParser)PartialCmdLineParser.this, (Localizable)Messages.MISSING_OPERAND, new String[]{PartialCmdLineParser.this.getOptionName()});
            }
            return this.args[this.pos + idx];
        }

        public int size() {
            return this.args.length - this.pos;
        }

        void splitToken() {
            int idx;
            if (this.pos < this.args.length && this.pos >= 0 && (idx = this.args[this.pos].indexOf("=")) > 0) {
                this.args[this.pos] = this.args[this.pos].substring(idx + 1);
            }
        }
    }
}

