/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.analysis;

import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.DependencyEdge;
import org.hisrc.jsonix.analysis.DependencyType;
import org.hisrc.jsonix.analysis.ElementInfoVertex;
import org.hisrc.jsonix.analysis.InfoVertex;
import org.hisrc.jsonix.analysis.ModelInfoGraphAnalyzer;
import org.hisrc.jsonix.analysis.PackageInfoVertex;
import org.hisrc.jsonix.analysis.PropertyInfoGraphBuilder;
import org.hisrc.jsonix.analysis.PropertyInfoVertex;
import org.hisrc.jsonix.analysis.TypeInfoGraphBuilder;
import org.hisrc.jsonix.analysis.TypeInfoVertex;
import org.hisrc.jsonix.context.JsonixContext;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.slf4j.Logger;

public class ModelInfoGraphBuilder<T, C extends T> {
    private final Logger logger;
    private final MModelInfo<T, C> modelInfo;
    private final EdgeFactory<InfoVertex<T, C>, DependencyEdge> edgeFactory = new EdgeFactory<InfoVertex<T, C>, DependencyEdge>(){

        public DependencyEdge createEdge(InfoVertex<T, C> sourceVertex, InfoVertex<T, C> targetVertex) {
            return new DependencyEdge(DependencyType.HARD);
        }
    };
    private final DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph;

    public ModelInfoGraphBuilder(JsonixContext context, MModelInfo<T, C> modelInfo) {
        Validate.notNull(modelInfo);
        this.logger = ((JsonixContext)Validate.notNull((Object)context)).getLoggerFactory().getLogger(ModelInfoGraphAnalyzer.class.getName());
        this.modelInfo = modelInfo;
        this.graph = new DefaultDirectedGraph(this.edgeFactory);
    }

    public DirectedGraph<InfoVertex<T, C>, DependencyEdge> build() {
        for (MClassInfo info : this.modelInfo.getClassInfos()) {
            this.typeInfo(info.getPackageInfo(), (MTypeInfo<T, C>)info);
        }
        for (MClassInfo info : this.modelInfo.getEnumLeafInfos()) {
            this.typeInfo(info.getPackageInfo(), (MTypeInfo<T, C>)info);
        }
        for (MClassInfo info : this.modelInfo.getElementInfos()) {
            this.elementInfo((MElementInfo<T, C>)info);
        }
        return this.graph;
    }

    public PackageInfoVertex<T, C> packageInfo(MPackageInfo info) {
        PackageInfoVertex packageInfoVertex = new PackageInfoVertex(info);
        this.addInfoVertex(packageInfoVertex);
        return packageInfoVertex;
    }

    public ElementInfoVertex<T, C> elementInfo(MElementInfo<T, C> info) {
        ElementInfoVertex<T, C> elementInfoVertex = new ElementInfoVertex<T, C>(info);
        if (this.addInfoVertex(elementInfoVertex)) {
            TypeInfoVertex<T, C> typeInfoVertex = this.typeInfo(info.getPackageInfo(), info.getTypeInfo());
            this.addHardDependency(elementInfoVertex, typeInfoVertex);
            PackageInfoVertex<T, C> packageInfoVertex = this.packageInfo(info.getPackageInfo());
            this.addSoftDependency(packageInfoVertex, elementInfoVertex);
        }
        return elementInfoVertex;
    }

    public TypeInfoVertex<T, C> typeInfo(MPackageInfo packageInfo, MTypeInfo<T, C> info) {
        return (TypeInfoVertex)info.acceptTypeInfoVisitor(new TypeInfoGraphBuilder(this, packageInfo));
    }

    public PropertyInfoVertex<T, C> propertyInfo(MPropertyInfo<T, C> info) {
        PropertyInfoVertex<T, C> propertyInfoVertex = new PropertyInfoVertex<T, C>(info);
        if (this.addInfoVertex(propertyInfoVertex)) {
            MClassInfo classInfo = info.getClassInfo();
            MPackageInfo packageInfo = classInfo.getPackageInfo();
            TypeInfoVertex classInfoVertex = new TypeInfoVertex(packageInfo, classInfo);
            this.addHardDependency(propertyInfoVertex, classInfoVertex);
            info.acceptPropertyInfoVisitor(new PropertyInfoGraphBuilder<T, C>(this, this.modelInfo, propertyInfoVertex));
        }
        return propertyInfoVertex;
    }

    public boolean addInfoVertex(InfoVertex<T, C> vertex) {
        Validate.notNull(vertex);
        boolean added = this.graph.addVertex(vertex);
        if (added) {
            this.logger.trace(MessageFormat.format("Added ({0}).", vertex.toString()));
        }
        return added;
    }

    public boolean addHardDependency(InfoVertex<T, C> source, InfoVertex<T, C> target) {
        Validate.notNull(source);
        Validate.notNull(target);
        boolean added = this.graph.addEdge(source, target, (Object)new DependencyEdge(DependencyType.HARD));
        if (added) {
            this.logger.trace(MessageFormat.format("Added hard dependency ({0})->({1}).", source.toString(), target.toString()));
        }
        return added;
    }

    public boolean addSoftDependency(InfoVertex<T, C> source, InfoVertex<T, C> target) {
        Validate.notNull(source);
        Validate.notNull(target);
        boolean added = this.graph.addEdge(source, target, (Object)new DependencyEdge(DependencyType.SOFT));
        if (added) {
            this.logger.trace(MessageFormat.format("Added soft dependency ({0})->({1}).", source.toString(), target.toString()));
        }
        return added;
    }
}

