/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.statement.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.statement.JSStatement;
import org.hisrc.jscm.codemodel.statement.JSStatementVisitor;
import org.hisrc.jscm.codemodel.statement.JSSwitchStatement;
import org.hisrc.jscm.codemodel.statement.impl.StatementGeneratorImpl;
import org.hisrc.jscm.codemodel.statement.impl.StatementImpl;

public class SwitchStatementImpl
extends StatementImpl
implements JSSwitchStatement {
    private final JSExpression expression;
    private final List<JSSwitchStatement.JSCaseClause> firstCaseClauses = new ArrayList<JSSwitchStatement.JSCaseClause>();
    private final List<JSSwitchStatement.JSCaseClause> unmodifiableFirstCaseClauses = Collections.unmodifiableList(this.firstCaseClauses);
    private JSSwitchStatement.JSDefaultClause defaultClause;
    private final List<JSSwitchStatement.JSCaseClause> secondCaseClauses = new ArrayList<JSSwitchStatement.JSCaseClause>();
    private final List<JSSwitchStatement.JSCaseClause> unmodifiableSecondCaseClauses = Collections.unmodifiableList(this.secondCaseClauses);

    public SwitchStatementImpl(JSCodeModel codeModel, JSExpression expression) {
        super(codeModel);
        Validate.notNull(expression);
        this.expression = expression;
    }

    @Override
    public JSSwitchStatement.JSCaseClause _case(JSExpression expression) {
        CaseClauseImpl caseClause = new CaseClauseImpl(this.getCodeModel(), expression);
        if (this.defaultClause == null) {
            this.firstCaseClauses.add(caseClause);
        } else {
            this.secondCaseClauses.add(caseClause);
        }
        return caseClause;
    }

    @Override
    public JSSwitchStatement.JSDefaultClause _default() {
        if (this.defaultClause == null) {
            this.defaultClause = new DefaultClauseImpl(this.getCodeModel());
        }
        return this.defaultClause;
    }

    @Override
    public JSExpression getExpression() {
        return this.expression;
    }

    @Override
    public List<JSSwitchStatement.JSCaseClause> getFirstCaseClauses() {
        return this.unmodifiableFirstCaseClauses;
    }

    @Override
    public JSSwitchStatement.JSDefaultClause getDefaultClause() {
        return this.defaultClause;
    }

    @Override
    public List<JSSwitchStatement.JSCaseClause> getSecondCaseClauses() {
        return this.unmodifiableSecondCaseClauses;
    }

    @Override
    public <V, E extends Exception> V acceptStatementVisitor(JSStatementVisitor<V, E> visitor) throws E {
        return visitor.visitSwitch(this);
    }

    public static class CaseClauseImpl
    extends StatementGeneratorImpl
    implements JSSwitchStatement.JSCaseClause {
        private final JSExpression expression;
        private final List<JSStatement> statements = new ArrayList<JSStatement>();
        private final List<JSStatement> unmodifiableStatements = Collections.unmodifiableList(this.statements);

        public CaseClauseImpl(JSCodeModel codeModel, JSExpression expression) {
            super(codeModel);
            Validate.notNull(expression);
            this.expression = expression;
        }

        @Override
        public JSExpression getExpression() {
            return this.expression;
        }

        @Override
        public List<JSStatement> getStatements() {
            return this.unmodifiableStatements;
        }

        @Override
        protected <S extends JSStatement> S add(S statement) {
            this.statements.add(statement);
            return statement;
        }
    }

    public static class DefaultClauseImpl
    extends StatementGeneratorImpl
    implements JSSwitchStatement.JSDefaultClause {
        private final List<JSStatement> statements = new ArrayList<JSStatement>();
        private final List<JSStatement> unmodifiableStatements = Collections.unmodifiableList(this.statements);

        public DefaultClauseImpl(JSCodeModel codeModel) {
            super(codeModel);
        }

        @Override
        public List<JSStatement> getStatements() {
            return this.unmodifiableStatements;
        }

        @Override
        protected <S extends JSStatement> S add(S statement) {
            this.statements.add(statement);
            return statement;
        }
    }
}

