/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.statement.impl;

import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSSourceElementVisitor;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.statement.JSLabelledStatement;
import org.hisrc.jscm.codemodel.statement.JSStatement;
import org.hisrc.jscm.codemodel.statement.JSStatementVisitor;
import org.hisrc.jscm.codemodel.statement.impl.EmptyStatementImpl;
import org.hisrc.jscm.codemodel.statement.impl.StatementGeneratorImpl;

public class LabelledStatementImpl
extends StatementGeneratorImpl
implements JSLabelledStatement {
    private final JSLabelledStatement.JSLabel label;
    private JSStatement statement;

    public LabelledStatementImpl(JSCodeModel codeModel, String label) {
        super(codeModel);
        Validate.notNull(label);
        this.label = new LabelImpl(label);
        this.statement = new EmptyStatementImpl(codeModel);
    }

    @Override
    protected <S extends JSStatement> S add(S statement) {
        Validate.notNull(statement);
        this.statement = statement;
        return statement;
    }

    @Override
    public JSLabelledStatement.JSLabel getLabel() {
        return this.label;
    }

    @Override
    public JSStatement getStatement() {
        return this.statement;
    }

    @Override
    public <V, E extends Exception> V acceptStatementVisitor(JSStatementVisitor<V, E> visitor) throws E {
        return visitor.visitLabelled(this);
    }

    @Override
    public <V, E extends Exception> V acceptSourceElementVisitor(JSSourceElementVisitor<V, E> visitor) throws E {
        return visitor.visitStatement(this);
    }

    private class LabelImpl
    implements JSLabelledStatement.JSLabel {
        private final String name;

        public LabelImpl(String name) {
            Validate.notNull(name);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

