/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.lang;

import java.util.Locale;

public class StringEscapeUtils {
    private StringEscapeUtils() {
    }

    public static final String escapeEcmaScript(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder();
        block11: for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            int codePoint = string.codePointAt(index);
            switch (character) {
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '/': {
                    sb.append("\\/");
                    continue block11;
                }
                default: {
                    if (codePoint < 32 || codePoint > 127) {
                        if (codePoint > 65535) {
                            sb.append("\\u");
                        } else if (codePoint > 4095) {
                            sb.append("\\u");
                        } else if (codePoint > 255) {
                            sb.append("\\u0");
                        } else if (codePoint > 15) {
                            sb.append("\\u00");
                        } else {
                            sb.append("\\u000");
                        }
                        sb.append(Integer.toHexString(codePoint).toUpperCase(Locale.ENGLISH));
                        continue block11;
                    }
                    sb.append(character);
                }
            }
        }
        return sb.toString();
    }
}

