/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.io;

import java.io.IOException;
import org.hisrc.jscm.codemodel.io.IndentedAppendable;
import org.hisrc.jscm.codemodel.lang.Validate;

public abstract class AbstractIndentedAppendable
implements IndentedAppendable {
    private final Appendable appendable;

    public AbstractIndentedAppendable(Appendable appendable) {
        Validate.notNull(appendable);
        this.appendable = appendable;
    }

    protected abstract String getIndentation();

    protected abstract boolean isLineTerminator();

    protected abstract void setLineTerminator(boolean var1);

    protected abstract boolean isWhiteSpace();

    protected abstract void setWhiteSpace(boolean var1);

    private void pre() throws IOException {
        if (this.isLineTerminator()) {
            this.setLineTerminator(false);
            this.setWhiteSpace(false);
            this.appendable.append('\n');
            this.appendable.append(this.getIndentation());
        } else if (this.isWhiteSpace()) {
            this.setLineTerminator(false);
            this.setWhiteSpace(false);
            this.appendable.append(' ');
        }
    }

    @Override
    public IndentedAppendable append(CharSequence str) throws IOException {
        this.pre();
        this.appendable.append(str);
        return this;
    }

    @Override
    public IndentedAppendable append(CharSequence charSequence, int start, int end) throws IOException {
        this.pre();
        this.appendable.append(charSequence, start, end);
        return this;
    }

    @Override
    public synchronized IndentedAppendable append(char c) throws IOException {
        this.pre();
        this.appendable.append(c);
        return this;
    }

    @Override
    public IndentedAppendable indent(CharSequence indentation) {
        Validate.notNull(indentation);
        final CharSequence _indentation = indentation;
        return new AbstractIndentedAppendable(this.appendable){
            private final String indentation;
            {
                super(x0);
                this.indentation = AbstractIndentedAppendable.this.getIndentation() + _indentation;
            }

            @Override
            protected void setWhiteSpace(boolean value) {
                AbstractIndentedAppendable.this.setWhiteSpace(value);
            }

            @Override
            protected void setLineTerminator(boolean value) {
                AbstractIndentedAppendable.this.setLineTerminator(value);
            }

            @Override
            protected boolean isWhiteSpace() {
                return AbstractIndentedAppendable.this.isWhiteSpace();
            }

            @Override
            protected boolean isLineTerminator() {
                return AbstractIndentedAppendable.this.isLineTerminator();
            }

            @Override
            protected String getIndentation() {
                return this.indentation;
            }
        };
    }

    @Override
    public IndentedAppendable whiteSpace() {
        this.setWhiteSpace(true);
        return this;
    }

    @Override
    public IndentedAppendable lineTerminator() {
        this.setLineTerminator(true);
        return this;
    }
}

