/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.expression.impl;

import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSRelationalExpression;
import org.hisrc.jscm.codemodel.expression.JSShiftExpression;
import org.hisrc.jscm.codemodel.expression.impl.EqualityExpressionImpl;
import org.hisrc.jscm.codemodel.lang.Validate;
import org.hisrc.jscm.codemodel.operator.JSBinaryOperator;
import org.hisrc.jscm.codemodel.operator.impl.KeywordRelationalOperator;
import org.hisrc.jscm.codemodel.operator.impl.RelationalOperator;

public abstract class RelationalExpressionImpl
extends EqualityExpressionImpl
implements JSRelationalExpression {
    public RelationalExpressionImpl(JSCodeModel codeModel) {
        super(codeModel);
    }

    @Override
    public JSRelationalExpression.Relational lt(JSShiftExpression value) {
        return new RelationalImpl(this.getCodeModel(), this, value, RelationalOperator.LT);
    }

    @Override
    public JSRelationalExpression.Relational gt(JSShiftExpression value) {
        return new RelationalImpl(this.getCodeModel(), this, value, RelationalOperator.GT);
    }

    @Override
    public JSRelationalExpression.Relational le(JSShiftExpression value) {
        return new RelationalImpl(this.getCodeModel(), this, value, RelationalOperator.LE);
    }

    @Override
    public JSRelationalExpression.Relational ge(JSShiftExpression value) {
        return new RelationalImpl(this.getCodeModel(), this, value, RelationalOperator.GE);
    }

    @Override
    public JSRelationalExpression.Relational _instanceof(JSShiftExpression value) {
        return new RelationalImpl(this.getCodeModel(), this, value, KeywordRelationalOperator.INSTANCEOF);
    }

    @Override
    public JSRelationalExpression.Relational in(JSShiftExpression value) {
        return new RelationalImpl(this.getCodeModel(), this, value, KeywordRelationalOperator.IN);
    }

    public static class RelationalImpl
    extends RelationalExpressionImpl
    implements JSRelationalExpression.Relational {
        private final JSRelationalExpression left;
        private final JSShiftExpression right;
        private final JSBinaryOperator operator;

        public RelationalImpl(JSCodeModel codeModel, JSRelationalExpression left, JSShiftExpression right, JSBinaryOperator operator) {
            super(codeModel);
            Validate.notNull(left);
            Validate.notNull(right);
            Validate.notNull(operator);
            this.left = left;
            this.right = right;
            this.operator = operator;
        }

        @Override
        public JSRelationalExpression getLeft() {
            return this.left;
        }

        @Override
        public JSShiftExpression getRight() {
            return this.right;
        }

        @Override
        public JSBinaryOperator getOperator() {
            return this.operator;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitRelational(this);
        }
    }
}

