/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.expression.impl;

import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSPrimaryExpression;
import org.hisrc.jscm.codemodel.expression.impl.PrimaryExpressionImpl;
import org.hisrc.jscm.codemodel.lang.Validate;

public abstract class ExpressionImpl
implements JSExpression {
    private final JSCodeModel codeModel;

    public ExpressionImpl(JSCodeModel codeModel) {
        Validate.notNull(codeModel);
        this.codeModel = codeModel;
    }

    public JSCodeModel getCodeModel() {
        return this.codeModel;
    }

    @Override
    public JSPrimaryExpression.Brackets brackets() {
        return new PrimaryExpressionImpl.BracketsImpl(this.getCodeModel(), this);
    }

    @Override
    public JSExpression.Comma comma(JSAssignmentExpression expression) {
        return new CommaImpl(this.getCodeModel(), this, expression);
    }

    public static class CommaImpl
    extends ExpressionImpl
    implements JSExpression.Comma {
        private final JSExpression first;
        private final JSAssignmentExpression second;

        public CommaImpl(JSCodeModel codeModel, JSExpression first, JSAssignmentExpression second) {
            super(codeModel);
            Validate.notNull(first);
            Validate.notNull(second);
            this.first = first;
            this.second = second;
        }

        @Override
        public JSExpression getLeft() {
            return this.first;
        }

        @Override
        public JSAssignmentExpression getRight() {
            return this.second;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitComma(this);
        }
    }
}

