/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jscm.codemodel.expression.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSPropertyName;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSCallExpression;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.expression.JSExpressionVisitor;
import org.hisrc.jscm.codemodel.expression.JSMemberExpression;
import org.hisrc.jscm.codemodel.expression.impl.LeftHandSideExpressionImpl;
import org.hisrc.jscm.codemodel.impl.IdentifierNameImpl;
import org.hisrc.jscm.codemodel.lang.Validate;

public abstract class CallExpressionImpl
extends LeftHandSideExpressionImpl
implements JSCallExpression {
    public CallExpressionImpl(JSCodeModel codeModel) {
        super(codeModel);
    }

    @Override
    public JSCallExpression.CallArgs i() {
        return this.invoke();
    }

    @Override
    public JSCallExpression.CallArgs invoke() {
        return new CallArgsImpl(this.getCodeModel(), this);
    }

    @Override
    public JSCallExpression.CallElement e(JSExpression index) {
        return this.element(index);
    }

    @Override
    public JSCallExpression.CallElement element(JSExpression index) {
        return new CallElementImpl(this.getCodeModel(), this, index);
    }

    @Override
    public JSCallExpression.CallProperty p(String name) {
        return this.property(name);
    }

    @Override
    public JSCallExpression.CallProperty property(String name) {
        return new CallPropertyImpl(this.getCodeModel(), this, new IdentifierNameImpl(name));
    }

    @Override
    public JSCallExpression.CallProperty p(JSPropertyName name) {
        return this.property(name);
    }

    @Override
    public JSCallExpression.CallProperty property(JSPropertyName name) {
        return new CallPropertyImpl(this.getCodeModel(), this, name);
    }

    public static class MemberCallImpl
    extends CallExpressionImpl
    implements JSCallExpression.MemberCall {
        private final List<JSAssignmentExpression> args = new ArrayList<JSAssignmentExpression>();
        private final List<JSAssignmentExpression> unmodifiableArgs = Collections.unmodifiableList(this.args);
        private final JSMemberExpression base;

        public MemberCallImpl(JSCodeModel codeModel, JSMemberExpression base) {
            super(codeModel);
            Validate.notNull(base);
            this.base = base;
        }

        @Override
        public JSCallExpression.MemberCall args(JSAssignmentExpression ... args) {
            Validate.noNullElements(args);
            this.args.addAll(Arrays.asList(args));
            return this;
        }

        @Override
        public JSMemberExpression getBase() {
            return this.base;
        }

        @Override
        public List<JSAssignmentExpression> getArgs() {
            return this.unmodifiableArgs;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitMemberCall(this);
        }
    }

    public static class CallPropertyImpl
    extends CallImpl
    implements JSCallExpression.CallProperty {
        private final JSPropertyName name;

        public CallPropertyImpl(JSCodeModel codeModel, JSCallExpression base, JSPropertyName name) {
            super(codeModel, base);
            Validate.notNull(name);
            this.name = name;
        }

        @Override
        public JSPropertyName getName() {
            return this.name;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitCallProperty(this);
        }
    }

    public static class CallElementImpl
    extends CallImpl
    implements JSCallExpression.CallElement {
        private final JSExpression index;

        public CallElementImpl(JSCodeModel codeModel, JSCallExpression base, JSExpression index) {
            super(codeModel, base);
            Validate.notNull(index);
            this.index = index;
        }

        @Override
        public JSExpression getIndex() {
            return this.index;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitCallElement(this);
        }
    }

    public static class CallArgsImpl
    extends CallImpl
    implements JSCallExpression.CallArgs {
        private final List<JSAssignmentExpression> args = new ArrayList<JSAssignmentExpression>();
        private final List<JSAssignmentExpression> unmodifiableArgs = Collections.unmodifiableList(this.args);

        public CallArgsImpl(JSCodeModel codeModel, JSCallExpression base) {
            super(codeModel, base);
        }

        @Override
        public JSCallExpression.CallArgs args(JSAssignmentExpression ... args) {
            Validate.noNullElements(args);
            this.args.addAll(Arrays.asList(args));
            return this;
        }

        @Override
        public List<JSAssignmentExpression> getArgs() {
            return this.unmodifiableArgs;
        }

        @Override
        public <V, E extends Exception> V acceptExpressionVisitor(JSExpressionVisitor<V, E> visitor) throws E {
            return visitor.visitCallArgs(this);
        }
    }

    public static abstract class CallImpl
    extends CallExpressionImpl
    implements JSCallExpression.Call {
        private final JSCallExpression base;

        public CallImpl(JSCodeModel codeModel, JSCallExpression base) {
            super(codeModel);
            this.base = base;
            Validate.notNull(base);
        }

        @Override
        public JSCallExpression getBase() {
            return this.base;
        }
    }
}

