/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.io.Serializable;
import java.util.Arrays;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.PivotingStrategy;

public class KthSelector
implements Serializable {
    private static final long serialVersionUID = 20140713L;
    private static final int MIN_SELECT_SIZE = 15;
    private final PivotingStrategy pivotingStrategy;

    public KthSelector() {
        this.pivotingStrategy = PivotingStrategy.MEDIAN_OF_3;
    }

    public KthSelector(PivotingStrategy pivotingStrategy) throws NullArgumentException {
        MathUtils.checkNotNull((Object)pivotingStrategy);
        this.pivotingStrategy = pivotingStrategy;
    }

    public PivotingStrategy getPivotingStrategy() {
        return this.pivotingStrategy;
    }

    public double select(double[] work, int[] pivotsHeap, int k) {
        boolean usePivotsHeap;
        int begin = 0;
        int end = work.length;
        int node = 0;
        boolean bl = usePivotsHeap = pivotsHeap != null;
        while (end - begin > 15) {
            int pivot;
            if (usePivotsHeap && node < pivotsHeap.length && pivotsHeap[node] >= 0) {
                pivot = pivotsHeap[node];
            } else {
                pivot = this.partition(work, begin, end, this.pivotingStrategy.pivotIndex(work, begin, end));
                if (usePivotsHeap && node < pivotsHeap.length) {
                    pivotsHeap[node] = pivot;
                }
            }
            if (k == pivot) {
                return work[k];
            }
            if (k < pivot) {
                end = pivot;
                node = FastMath.min(2 * node + 1, usePivotsHeap ? pivotsHeap.length : end);
                continue;
            }
            begin = pivot + 1;
            node = FastMath.min(2 * node + 2, usePivotsHeap ? pivotsHeap.length : end);
        }
        Arrays.sort(work, begin, end);
        return work[k];
    }

    private int partition(double[] work, int begin, int end, int pivot) {
        double value = work[pivot];
        work[pivot] = work[begin];
        int i = begin + 1;
        int j = end - 1;
        while (i < j) {
            while (i < j && Double.compare(work[j], value) > 0) {
                --j;
            }
            while (i < j && Double.compare(work[i], value) < 0) {
                ++i;
            }
            if (i >= j) continue;
            double tmp = work[i];
            work[i++] = work[j];
            work[j--] = tmp;
        }
        if (i >= end || Double.compare(work[i], value) > 0) {
            --i;
        }
        work[begin] = work[i];
        work[i] = value;
        return i;
    }
}

