/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldTuple<T extends CalculusFieldElement<T>>
implements CalculusFieldElement<FieldTuple<T>> {
    private final T[] values;
    private final transient FieldTupleField<T> field;

    @SafeVarargs
    public FieldTuple(T ... x) {
        this(new FieldTupleField(x[0].getField(), x.length), (CalculusFieldElement[])x.clone());
    }

    private FieldTuple(FieldTupleField<T> field, T[] x) {
        this.values = x;
        this.field = field;
    }

    @Override
    public FieldTuple<T> newInstance(double value) {
        return ((FieldTuple)this.field.getZero()).add(value);
    }

    public int getDimension() {
        return this.values.length;
    }

    public T getComponent(int index) {
        return this.values[index];
    }

    public T[] getComponents() {
        return (CalculusFieldElement[])this.values.clone();
    }

    @Override
    public Field<FieldTuple<T>> getField() {
        return this.field;
    }

    @Override
    public FieldTuple<T> add(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].add(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> subtract(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].subtract(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> negate() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].negate();
        }
        return result;
    }

    @Override
    public FieldTuple<T> multiply(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].multiply(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> multiply(int n) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].multiply(n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> divide(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].divide(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> reciprocal() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].reciprocal();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldTuple) {
            FieldTuple that = (FieldTuple)obj;
            if (this.getDimension() == that.getDimension()) {
                boolean equals = true;
                for (int i = 0; i < this.values.length; ++i) {
                    equals &= this.values[i].equals(that.values[i]);
                }
                return equals;
            }
        }
        return false;
    }

    public int hashCode() {
        return 1492524517 + Arrays.hashCode(this.values);
    }

    @Override
    public double getReal() {
        return this.values[0].getReal();
    }

    @Override
    public FieldTuple<T> getAddendum() {
        CalculusFieldElement[] addendum = (CalculusFieldElement[])this.values.clone();
        addendum[0] = (CalculusFieldElement)addendum[0].getField().getZero();
        for (int i = 1; i < addendum.length; ++i) {
            addendum[i] = (CalculusFieldElement)addendum[i].subtract(this.values[0]);
        }
        return new FieldTuple(this.field, addendum);
    }

    @Override
    public FieldTuple<T> add(double a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].add(a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> subtract(double a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].subtract((double)a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> multiply(double a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].multiply(a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> square() {
        return this.multiply(this);
    }

    @Override
    public FieldTuple<T> divide(double a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].divide((double)a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> remainder(double a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].remainder((double)a);
        }
        return result;
    }

    @Override
    public FieldTuple<T> remainder(FieldTuple<T> a) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].remainder(a.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> abs() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].abs();
        }
        return result;
    }

    @Override
    public FieldTuple<T> ceil() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].ceil();
        }
        return result;
    }

    @Override
    public FieldTuple<T> floor() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].floor();
        }
        return result;
    }

    @Override
    public FieldTuple<T> rint() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].rint();
        }
        return result;
    }

    @Override
    public FieldTuple<T> sign() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].sign();
        }
        return result;
    }

    @Override
    public FieldTuple<T> copySign(FieldTuple<T> sign) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].copySign(sign.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> copySign(double sign) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].copySign(sign);
        }
        return result;
    }

    @Override
    public FieldTuple<T> scalb(int n) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].scalb(n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> ulp() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].ulp();
        }
        return result;
    }

    @Override
    public FieldTuple<T> hypot(FieldTuple<T> y) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].hypot(y.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> sqrt() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].sqrt();
        }
        return result;
    }

    @Override
    public FieldTuple<T> cbrt() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].cbrt();
        }
        return result;
    }

    @Override
    public FieldTuple<T> rootN(int n) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].rootN(n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> pow(double p) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].pow((double)p);
        }
        return result;
    }

    @Override
    public FieldTuple<T> pow(int n) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].pow((int)n);
        }
        return result;
    }

    @Override
    public FieldTuple<T> pow(FieldTuple<T> e) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].pow(e.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> exp() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].exp();
        }
        return result;
    }

    @Override
    public FieldTuple<T> expm1() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].expm1();
        }
        return result;
    }

    @Override
    public FieldTuple<T> log() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].log();
        }
        return result;
    }

    @Override
    public FieldTuple<T> log1p() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].log1p();
        }
        return result;
    }

    @Override
    public FieldTuple<T> log10() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].log10();
        }
        return result;
    }

    @Override
    public FieldTuple<T> cos() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].cos();
        }
        return result;
    }

    @Override
    public FieldTuple<T> sin() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].sin();
        }
        return result;
    }

    @Override
    public FieldSinCos<FieldTuple<T>> sinCos() {
        FieldTuple sin = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        FieldTuple cos = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            FieldSinCos<T> sc = FastMath.sinCos(this.values[i]);
            sin.values[i] = (CalculusFieldElement)sc.sin();
            cos.values[i] = (CalculusFieldElement)sc.cos();
        }
        return new FieldSinCos<FieldTuple<T>>(sin, cos);
    }

    @Override
    public FieldTuple<T> tan() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].tan();
        }
        return result;
    }

    @Override
    public FieldTuple<T> acos() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].acos();
        }
        return result;
    }

    @Override
    public FieldTuple<T> asin() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].asin();
        }
        return result;
    }

    @Override
    public FieldTuple<T> atan() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].atan();
        }
        return result;
    }

    @Override
    public FieldTuple<T> atan2(FieldTuple<T> x) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].atan2(x.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> cosh() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].cosh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> sinh() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].sinh();
        }
        return result;
    }

    @Override
    public FieldSinhCosh<FieldTuple<T>> sinhCosh() {
        FieldTuple sinh = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        FieldTuple cosh = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            FieldSinhCosh<T> sc = FastMath.sinhCosh(this.values[i]);
            sinh.values[i] = (CalculusFieldElement)sc.sinh();
            cosh.values[i] = (CalculusFieldElement)sc.cosh();
        }
        return new FieldSinhCosh<FieldTuple<T>>(sinh, cosh);
    }

    @Override
    public FieldTuple<T> tanh() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].tanh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> acosh() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].acosh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> asinh() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].asinh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> atanh() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].atanh();
        }
        return result;
    }

    @Override
    public FieldTuple<T> toDegrees() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].toDegrees();
        }
        return result;
    }

    @Override
    public FieldTuple<T> toRadians() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)this.values[i].toRadians();
        }
        return result;
    }

    public FieldTuple<T> linearCombination(FieldTuple<T>[] a, FieldTuple<T>[] b) throws MathIllegalArgumentException {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        MathUtils.checkDimension(a.length, b.length);
        FieldElement[] aT = (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)a.length);
        FieldElement[] bT = (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)b.length);
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                aT[j] = a[j].values[i];
                bT[j] = b[j].values[i];
            }
            result.values[i] = (CalculusFieldElement)aT[0].linearCombination(aT, bT);
        }
        return result;
    }

    public FieldTuple<T> linearCombination(double[] a, FieldTuple<T>[] b) throws MathIllegalArgumentException {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        MathUtils.checkDimension(a.length, b.length);
        FieldElement[] bT = (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)b.length);
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                bT[j] = b[j].values[i];
            }
            result.values[i] = (CalculusFieldElement)bT[0].linearCombination(a, bT);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(FieldTuple<T> a1, FieldTuple<T> b1, FieldTuple<T> a2, FieldTuple<T> b2) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)a1.values[0].linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(double a1, FieldTuple<T> b1, double a2, FieldTuple<T> b2) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)b1.values[0].linearCombination(a1, b1.values[i], a2, b2.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(FieldTuple<T> a1, FieldTuple<T> b1, FieldTuple<T> a2, FieldTuple<T> b2, FieldTuple<T> a3, FieldTuple<T> b3) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)a1.values[0].linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i], a3.values[i], b3.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(double a1, FieldTuple<T> b1, double a2, FieldTuple<T> b2, double a3, FieldTuple<T> b3) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)b1.values[0].linearCombination(a1, b1.values[i], a2, b2.values[i], a3, b3.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(FieldTuple<T> a1, FieldTuple<T> b1, FieldTuple<T> a2, FieldTuple<T> b2, FieldTuple<T> a3, FieldTuple<T> b3, FieldTuple<T> a4, FieldTuple<T> b4) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)a1.values[0].linearCombination(a1.values[i], b1.values[i], a2.values[i], b2.values[i], a3.values[i], b3.values[i], a4.values[i], b4.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> linearCombination(double a1, FieldTuple<T> b1, double a2, FieldTuple<T> b2, double a3, FieldTuple<T> b3, double a4, FieldTuple<T> b4) {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        for (int i = 0; i < this.values.length; ++i) {
            result.values[i] = (CalculusFieldElement)b1.values[0].linearCombination(a1, b1.values[i], a2, b2.values[i], a3, b3.values[i], a4, b4.values[i]);
        }
        return result;
    }

    @Override
    public FieldTuple<T> getPi() {
        FieldTuple result = new FieldTuple(this.field, (CalculusFieldElement[])MathArrays.buildArray(this.values[0].getField(), (int)this.values.length));
        Arrays.fill(result.values, this.values[0].getPi());
        return result;
    }

    private static class FieldTupleField<T extends CalculusFieldElement<T>>
    implements Field<FieldTuple<T>> {
        private final FieldTuple<T> zero;
        private final FieldTuple<T> one;

        FieldTupleField(Field<T> field, int dimension) {
            Object[] zeroData = (CalculusFieldElement[])MathArrays.buildArray(field, (int)dimension);
            Arrays.fill(zeroData, field.getZero());
            Object[] oneData = (CalculusFieldElement[])MathArrays.buildArray(field, (int)dimension);
            Arrays.fill(oneData, field.getOne());
            this.zero = new FieldTuple(this, (CalculusFieldElement[])zeroData);
            this.one = new FieldTuple(this, (CalculusFieldElement[])oneData);
        }

        @Override
        public FieldTuple<T> getZero() {
            return this.zero;
        }

        @Override
        public FieldTuple<T> getOne() {
            return this.one;
        }

        @Override
        public Class<FieldTuple<T>> getRuntimeClass() {
            return this.zero.getClass();
        }

        public boolean equals(Object other) {
            if (other instanceof FieldTupleField) {
                FieldTupleField that = (FieldTupleField)other;
                return this.zero.getDimension() == that.zero.getDimension();
            }
            return false;
        }

        public int hashCode() {
            return 0xB4A533E1 ^ this.zero.getDimension();
        }
    }
}

