/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.linear.SemiDefinitePositiveCholeskyDecomposition;
import org.hipparchus.util.UnscentedTransformProvider;

public abstract class AbstractUnscentedTransform
implements UnscentedTransformProvider {
    protected AbstractUnscentedTransform(int stateDim) {
        if (stateDim == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ZERO_STATE_SIZE, new Object[0]);
        }
    }

    @Override
    public RealVector[] unscentedTransform(RealVector state, RealMatrix covariance) {
        int n = state.getDimension();
        RealVector[] sigmaPoints = new ArrayRealVector[2 * n + 1];
        sigmaPoints[0] = state;
        double factor = this.getMultiplicationFactor();
        RealMatrix temp = covariance.scalarMultiply(factor);
        RealMatrix L = new SemiDefinitePositiveCholeskyDecomposition(temp).getL();
        for (int i = 1; i <= n; ++i) {
            sigmaPoints[i] = sigmaPoints[0].add(L.getColumnVector(i - 1));
            sigmaPoints[i + n] = sigmaPoints[0].subtract(L.getColumnVector(i - 1));
        }
        return sigmaPoints;
    }

    protected abstract double getMultiplicationFactor();
}

