/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.legendre;

import java.util.function.DoubleFunction;
import java.util.function.Function;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.ComplexUnivariateIntegrator;
import org.hipparchus.complex.FieldComplex;
import org.hipparchus.complex.FieldComplexField;
import org.hipparchus.complex.FieldComplexUnivariateIntegrator;
import org.hipparchus.special.elliptic.carlson.CarlsonEllipticIntegral;
import org.hipparchus.util.FastMath;

public class LegendreEllipticIntegral {
    private LegendreEllipticIntegral() {
    }

    public static double nome(double m) {
        if (m < 1.0E-16) {
            double m16 = m * 0.0625;
            return m16 * (1.0 + 8.0 * m16);
        }
        return FastMath.exp(-Math.PI * LegendreEllipticIntegral.bigKPrime(m) / LegendreEllipticIntegral.bigK(m));
    }

    public static <T extends CalculusFieldElement<T>> T nome(T m) {
        CalculusFieldElement one = (CalculusFieldElement)m.getField().getOne();
        if (m.norm() < 100.0 * ((CalculusFieldElement)one.ulp()).getReal()) {
            CalculusFieldElement m16 = (CalculusFieldElement)m.multiply(0.0625);
            return (T)m16.multiply((CalculusFieldElement)((CalculusFieldElement)m16.multiply(8)).add(1.0));
        }
        return (T)FastMath.exp(((CalculusFieldElement)LegendreEllipticIntegral.bigKPrime(m).divide(LegendreEllipticIntegral.bigK(m))).multiply((CalculusFieldElement)((CalculusFieldElement)one.getPi()).negate()));
    }

    public static double bigK(double m) {
        if (m < 1.0E-8) {
            return (1.0 + 0.25 * m) * 1.5707963267948966;
        }
        return CarlsonEllipticIntegral.rF(0.0, 1.0 - m, 1.0);
    }

    public static <T extends CalculusFieldElement<T>> T bigK(T m) {
        CalculusFieldElement zero = (CalculusFieldElement)m.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)m.getField().getOne();
        if (m.norm() < 1.0E7 * ((CalculusFieldElement)one.ulp()).getReal()) {
            return (T)one.add((CalculusFieldElement)m.multiply(0.25)).multiply((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(0.5));
        }
        return (T)CarlsonEllipticIntegral.rF(zero, one.subtract(m), one);
    }

    public static Complex bigK(Complex m) {
        if (m.norm() < 1.0E-8) {
            return Complex.ONE.add(m.multiply(0.25)).multiply(1.5707963267948966);
        }
        return CarlsonEllipticIntegral.rF(Complex.ZERO, Complex.ONE.subtract(m), Complex.ONE);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigK(FieldComplex<T> m) {
        FieldElement zero = ((FieldComplexField)m.getField()).getZero();
        FieldElement one = ((FieldComplexField)m.getField()).getOne();
        if (m.norm() < 1.0E7 * ((FieldComplex)((FieldComplex)one).ulp()).getReal()) {
            return ((FieldComplex)one).add(m.multiply(0.25)).multiply(((FieldComplex)((FieldComplex)zero).getPi()).multiply(0.5));
        }
        return CarlsonEllipticIntegral.rF(zero, ((FieldComplex)one).subtract(m), one);
    }

    public static double bigKPrime(double m) {
        return CarlsonEllipticIntegral.rF(0.0, m, 1.0);
    }

    public static <T extends CalculusFieldElement<T>> T bigKPrime(T m) {
        CalculusFieldElement zero = (CalculusFieldElement)m.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)m.getField().getOne();
        return (T)CarlsonEllipticIntegral.rF(zero, m, one);
    }

    public static Complex bigKPrime(Complex m) {
        return CarlsonEllipticIntegral.rF(Complex.ZERO, m, Complex.ONE);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigKPrime(FieldComplex<T> m) {
        FieldElement zero = ((FieldComplexField)m.getField()).getZero();
        FieldElement one = ((FieldComplexField)m.getField()).getOne();
        return CarlsonEllipticIntegral.rF(zero, m, one);
    }

    public static double bigE(double m) {
        return CarlsonEllipticIntegral.rG(0.0, 1.0 - m, 1.0) * 2.0;
    }

    public static <T extends CalculusFieldElement<T>> T bigE(T m) {
        CalculusFieldElement zero = (CalculusFieldElement)m.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)m.getField().getOne();
        return (T)((CalculusFieldElement)CarlsonEllipticIntegral.rG(zero, one.subtract(m), one).multiply(2));
    }

    public static Complex bigE(Complex m) {
        return CarlsonEllipticIntegral.rG(Complex.ZERO, Complex.ONE.subtract(m), Complex.ONE).multiply(2);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigE(FieldComplex<T> m) {
        FieldElement zero = ((FieldComplexField)m.getField()).getZero();
        FieldElement one = ((FieldComplexField)m.getField()).getOne();
        return CarlsonEllipticIntegral.rG(zero, ((FieldComplex)one).subtract(m), one).multiply(2);
    }

    public static double bigD(double m) {
        return CarlsonEllipticIntegral.rD(0.0, 1.0 - m, 1.0) / 3.0;
    }

    public static <T extends CalculusFieldElement<T>> T bigD(T m) {
        CalculusFieldElement zero = (CalculusFieldElement)m.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)m.getField().getOne();
        return (T)((CalculusFieldElement)CarlsonEllipticIntegral.rD(zero, one.subtract(m), one).divide(3.0));
    }

    public static Complex bigD(Complex m) {
        return CarlsonEllipticIntegral.rD(Complex.ZERO, Complex.ONE.subtract(m), Complex.ONE).divide(3.0);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigD(FieldComplex<T> m) {
        FieldElement zero = ((FieldComplexField)m.getField()).getZero();
        FieldElement one = ((FieldComplexField)m.getField()).getOne();
        return CarlsonEllipticIntegral.rD(zero, ((FieldComplex)one).subtract(m), one).divide(3.0);
    }

    public static double bigPi(double n, double m) {
        double kPrime2 = 1.0 - m;
        double delta = n * (m - n) * (n - 1.0);
        return CarlsonEllipticIntegral.rF(0.0, kPrime2, 1.0) + CarlsonEllipticIntegral.rJ(0.0, kPrime2, 1.0, 1.0 - n, delta) * n / 3.0;
    }

    public static <T extends CalculusFieldElement<T>> T bigPi(T n, T m) {
        CalculusFieldElement zero = (CalculusFieldElement)m.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)m.getField().getOne();
        T kPrime2 = one.subtract(m);
        CalculusFieldElement delta = n.multiply((CalculusFieldElement)((CalculusFieldElement)m.subtract(n))).multiply((CalculusFieldElement)n.subtract((double)1.0));
        return (T)CarlsonEllipticIntegral.rF(zero, kPrime2, one).add((CalculusFieldElement)CarlsonEllipticIntegral.rJ(zero, kPrime2, one, one.subtract(n), delta).multiply(n).divide((double)3.0));
    }

    public static Complex bigPi(Complex n, Complex m) {
        Complex kPrime2 = Complex.ONE.subtract(m);
        Complex delta = n.multiply(m.subtract(n)).multiply(n.subtract(1.0));
        return CarlsonEllipticIntegral.rF(Complex.ZERO, kPrime2, Complex.ONE).add(CarlsonEllipticIntegral.rJ(Complex.ZERO, kPrime2, Complex.ONE, Complex.ONE.subtract(n), delta).multiply(n).divide(3.0));
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigPi(FieldComplex<T> n, FieldComplex<T> m) {
        FieldElement zero = ((FieldComplexField)m.getField()).getZero();
        FieldElement one = ((FieldComplexField)m.getField()).getOne();
        FieldComplex<FieldComplex<T>> kPrime2 = ((FieldComplex)one).subtract(m);
        FieldComplex<FieldElement> delta = n.multiply(m.subtract(n)).multiply((FieldComplex<FieldComplex<FieldElement>>)n.subtract(1.0));
        return CarlsonEllipticIntegral.rF(zero, kPrime2, one).add((FieldComplex<FieldElement>)CarlsonEllipticIntegral.rJ(zero, kPrime2, one, ((FieldComplex)one).subtract(n), delta).multiply((FieldElement)n).divide(3.0));
    }

    public static double bigF(double phi, double m) {
        DoubleArgumentReduction ar = new DoubleArgumentReduction(phi, m, LegendreEllipticIntegral::bigK);
        double cM1 = ar.csc2 - 1.0;
        double cMm = ar.csc2 - m;
        double incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, ar.csc2);
        return ar.negate ? ar.complete - incomplete : ar.complete + incomplete;
    }

    public static <T extends CalculusFieldElement<T>> T bigF(T phi, T m) {
        FieldArgumentReduction<CalculusFieldElement> ar = new FieldArgumentReduction<CalculusFieldElement>(phi, m, LegendreEllipticIntegral::bigK);
        CalculusFieldElement cM1 = (CalculusFieldElement)((FieldArgumentReduction)ar).csc2.subtract(1.0);
        T cMm = ((FieldArgumentReduction)ar).csc2.subtract(m);
        CalculusFieldElement incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, ((FieldArgumentReduction)ar).csc2);
        return (T)(((FieldArgumentReduction)ar).negate ? ((FieldArgumentReduction)ar).complete.subtract(incomplete) : ((FieldArgumentReduction)ar).complete.add(incomplete));
    }

    public static Complex bigF(Complex phi, Complex m) {
        FieldArgumentReduction<Complex> ar = new FieldArgumentReduction<Complex>(phi, m, LegendreEllipticIntegral::bigK);
        Complex cM1 = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        Complex cMm = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(m);
        Complex incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, (Complex)((FieldArgumentReduction)ar).csc2);
        return ((FieldArgumentReduction)ar).negate ? ((Complex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((Complex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static Complex bigF(Complex phi, Complex m, ComplexUnivariateIntegrator integrator, int maxEval) {
        return integrator.integrate(maxEval, (CalculusFieldUnivariateFunction<Complex>)new First<Complex>(m), phi.getField().getZero(), phi);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigF(FieldComplex<T> phi, FieldComplex<T> m) {
        FieldArgumentReduction<FieldComplex> ar = new FieldArgumentReduction<FieldComplex>(phi, m, LegendreEllipticIntegral::bigK);
        FieldElement cM1 = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        FieldComplex<FieldComplex<T>> cMm = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(m);
        FieldComplex<FieldComplex<T>> incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, (FieldComplex)((FieldArgumentReduction)ar).csc2);
        return ((FieldArgumentReduction)ar).negate ? ((FieldComplex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((FieldComplex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigF(FieldComplex<T> phi, FieldComplex<T> m, FieldComplexUnivariateIntegrator<T> integrator, int maxEval) {
        return integrator.integrate(maxEval, (CalculusFieldUnivariateFunction<FieldComplex<T>>)new First<FieldComplex<T>>(m), (FieldComplex<T>)((FieldComplexField)phi.getField()).getZero(), phi);
    }

    public static double bigE(double phi, double m) {
        DoubleArgumentReduction ar = new DoubleArgumentReduction(phi, m, LegendreEllipticIntegral::bigE);
        double cM1 = ar.csc2 - 1.0;
        double cMm = ar.csc2 - m;
        double incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, ar.csc2) - CarlsonEllipticIntegral.rD(cM1, cMm, ar.csc2) * (m / 3.0);
        return ar.negate ? ar.complete - incomplete : ar.complete + incomplete;
    }

    public static <T extends CalculusFieldElement<T>> T bigE(T phi, T m) {
        FieldArgumentReduction<CalculusFieldElement> ar = new FieldArgumentReduction<CalculusFieldElement>(phi, (CalculusFieldElement)m, LegendreEllipticIntegral::bigE);
        CalculusFieldElement cM1 = (CalculusFieldElement)((FieldArgumentReduction)ar).csc2.subtract(1.0);
        T cMm = ((FieldArgumentReduction)ar).csc2.subtract(m);
        CalculusFieldElement incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, ((FieldArgumentReduction)ar).csc2).subtract(CarlsonEllipticIntegral.rD(cM1, cMm, ((FieldArgumentReduction)ar).csc2).multiply((CalculusFieldElement)m.divide((double)3.0)));
        return (T)(((FieldArgumentReduction)ar).negate ? ((FieldArgumentReduction)ar).complete.subtract(incomplete) : ((FieldArgumentReduction)ar).complete.add(incomplete));
    }

    public static Complex bigE(Complex phi, Complex m) {
        FieldArgumentReduction<Complex> ar = new FieldArgumentReduction<Complex>(phi, m, LegendreEllipticIntegral::bigE);
        Complex cM1 = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        Complex cMm = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(m);
        Complex incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, (Complex)((FieldArgumentReduction)ar).csc2).subtract(CarlsonEllipticIntegral.rD(cM1, cMm, (Complex)((FieldArgumentReduction)ar).csc2).multiply(m.divide(3.0)));
        return ((FieldArgumentReduction)ar).negate ? ((Complex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((Complex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static Complex bigE(Complex phi, Complex m, ComplexUnivariateIntegrator integrator, int maxEval) {
        return integrator.integrate(maxEval, (CalculusFieldUnivariateFunction<Complex>)new Second<Complex>(m), phi.getField().getZero(), phi);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigE(FieldComplex<T> phi, FieldComplex<T> m) {
        FieldArgumentReduction<FieldComplex> ar = new FieldArgumentReduction<FieldComplex>(phi, m, LegendreEllipticIntegral::bigE);
        FieldElement cM1 = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        FieldComplex<FieldComplex<T>> cMm = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(m);
        FieldComplex<FieldComplex<FieldElement>> incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, (FieldComplex)((FieldArgumentReduction)ar).csc2).subtract((FieldComplex<FieldComplex<FieldElement>>)CarlsonEllipticIntegral.rD(cM1, cMm, (FieldComplex)((FieldArgumentReduction)ar).csc2).multiply((FieldComplex<FieldElement>)m.divide(3.0)));
        return ((FieldArgumentReduction)ar).negate ? ((FieldComplex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((FieldComplex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigE(FieldComplex<T> phi, FieldComplex<T> m, FieldComplexUnivariateIntegrator<T> integrator, int maxEval) {
        return integrator.integrate(maxEval, (CalculusFieldUnivariateFunction<FieldComplex<T>>)new Second<FieldComplex<T>>(m), (FieldComplex<T>)((FieldComplexField)phi.getField()).getZero(), phi);
    }

    public static double bigD(double phi, double m) {
        DoubleArgumentReduction ar = new DoubleArgumentReduction(phi, m, LegendreEllipticIntegral::bigD);
        double cM1 = ar.csc2 - 1.0;
        double cMm = ar.csc2 - m;
        double incomplete = CarlsonEllipticIntegral.rD(cM1, cMm, ar.csc2) / 3.0;
        return ar.negate ? ar.complete - incomplete : ar.complete + incomplete;
    }

    public static <T extends CalculusFieldElement<T>> T bigD(T phi, T m) {
        FieldArgumentReduction<CalculusFieldElement> ar = new FieldArgumentReduction<CalculusFieldElement>(phi, m, LegendreEllipticIntegral::bigD);
        CalculusFieldElement cM1 = (CalculusFieldElement)((FieldArgumentReduction)ar).csc2.subtract(1.0);
        T cMm = ((FieldArgumentReduction)ar).csc2.subtract(m);
        CalculusFieldElement incomplete = (CalculusFieldElement)CarlsonEllipticIntegral.rD(cM1, cMm, ((FieldArgumentReduction)ar).csc2).divide(3.0);
        return (T)(((FieldArgumentReduction)ar).negate ? ((FieldArgumentReduction)ar).complete.subtract(incomplete) : ((FieldArgumentReduction)ar).complete.add(incomplete));
    }

    public static Complex bigD(Complex phi, Complex m) {
        FieldArgumentReduction<Complex> ar = new FieldArgumentReduction<Complex>(phi, m, LegendreEllipticIntegral::bigD);
        Complex cM1 = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        Complex cMm = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(m);
        Complex incomplete = CarlsonEllipticIntegral.rD(cM1, cMm, (Complex)((FieldArgumentReduction)ar).csc2).divide(3.0);
        return ((FieldArgumentReduction)ar).negate ? ((Complex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((Complex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigD(FieldComplex<T> phi, FieldComplex<T> m) {
        FieldArgumentReduction<FieldComplex> ar = new FieldArgumentReduction<FieldComplex>(phi, m, LegendreEllipticIntegral::bigD);
        FieldElement cM1 = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        FieldComplex<FieldComplex<T>> cMm = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(m);
        FieldElement incomplete = CarlsonEllipticIntegral.rD(cM1, cMm, (FieldComplex)((FieldArgumentReduction)ar).csc2).divide(3.0);
        return ((FieldArgumentReduction)ar).negate ? ((FieldComplex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((FieldComplex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static double bigPi(double n, double phi, double m) {
        DoubleArgumentReduction ar = new DoubleArgumentReduction(phi, m, parameter -> LegendreEllipticIntegral.bigPi(n, parameter));
        double cM1 = ar.csc2 - 1.0;
        double cMm = ar.csc2 - m;
        double cMn = ar.csc2 - n;
        double delta = n * (m - n) * (n - 1.0);
        double incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, ar.csc2) + CarlsonEllipticIntegral.rJ(cM1, cMm, ar.csc2, cMn, delta) * n / 3.0;
        return ar.negate ? ar.complete - incomplete : ar.complete + incomplete;
    }

    public static <T extends CalculusFieldElement<T>> T bigPi(T n, T phi, T m) {
        FieldArgumentReduction<CalculusFieldElement> ar = new FieldArgumentReduction<CalculusFieldElement>(phi, m, parameter -> LegendreEllipticIntegral.bigPi(n, parameter));
        CalculusFieldElement cM1 = (CalculusFieldElement)((FieldArgumentReduction)ar).csc2.subtract(1.0);
        T cMm = ((FieldArgumentReduction)ar).csc2.subtract(m);
        T cMn = ((FieldArgumentReduction)ar).csc2.subtract(n);
        CalculusFieldElement delta = n.multiply((CalculusFieldElement)((CalculusFieldElement)m.subtract(n))).multiply((CalculusFieldElement)n.subtract((double)1.0));
        CalculusFieldElement incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, ((FieldArgumentReduction)ar).csc2).add((CalculusFieldElement)CarlsonEllipticIntegral.rJ(cM1, cMm, ((FieldArgumentReduction)ar).csc2, cMn, delta).multiply(n).divide((double)3.0));
        return (T)(((FieldArgumentReduction)ar).negate ? ((FieldArgumentReduction)ar).complete.subtract(incomplete) : ((FieldArgumentReduction)ar).complete.add(incomplete));
    }

    public static Complex bigPi(Complex n, Complex phi, Complex m) {
        FieldArgumentReduction<Complex> ar = new FieldArgumentReduction<Complex>(phi, m, parameter -> LegendreEllipticIntegral.bigPi(n, parameter));
        Complex cM1 = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        Complex cMm = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(m);
        Complex cMn = ((Complex)((FieldArgumentReduction)ar).csc2).subtract(n);
        Complex delta = n.multiply(m.subtract(n)).multiply(n.subtract(1.0));
        Complex incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, (Complex)((FieldArgumentReduction)ar).csc2).add(CarlsonEllipticIntegral.rJ(cM1, cMm, (Complex)((FieldArgumentReduction)ar).csc2, cMn, delta).multiply(n).divide(3.0));
        return ((FieldArgumentReduction)ar).negate ? ((Complex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((Complex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static Complex bigPi(Complex n, Complex phi, Complex m, ComplexUnivariateIntegrator integrator, int maxEval) {
        return integrator.integrate(maxEval, (CalculusFieldUnivariateFunction<Complex>)new Third<Complex>(n, m), phi.getField().getZero(), phi);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigPi(FieldComplex<T> n, FieldComplex<T> phi, FieldComplex<T> m) {
        FieldArgumentReduction<FieldComplex> ar = new FieldArgumentReduction<FieldComplex>(phi, m, parameter -> LegendreEllipticIntegral.bigPi(n, parameter));
        FieldElement cM1 = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(1.0);
        FieldComplex<FieldComplex<T>> cMm = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(m);
        FieldComplex<FieldComplex<T>> cMn = ((FieldComplex)((FieldArgumentReduction)ar).csc2).subtract(n);
        FieldComplex<FieldElement> delta = n.multiply(m.subtract(n)).multiply((FieldComplex<FieldComplex<FieldElement>>)n.subtract(1.0));
        FieldComplex<FieldElement> incomplete = CarlsonEllipticIntegral.rF(cM1, cMm, (FieldComplex)((FieldArgumentReduction)ar).csc2).add((FieldComplex<FieldElement>)CarlsonEllipticIntegral.rJ(cM1, cMm, (FieldComplex)((FieldArgumentReduction)ar).csc2, cMn, delta).multiply((FieldElement)n).divide(3.0));
        return ((FieldArgumentReduction)ar).negate ? ((FieldComplex)((FieldArgumentReduction)ar).complete).subtract(incomplete) : ((FieldComplex)((FieldArgumentReduction)ar).complete).add(incomplete);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> bigPi(FieldComplex<T> n, FieldComplex<T> phi, FieldComplex<T> m, FieldComplexUnivariateIntegrator<T> integrator, int maxEval) {
        return integrator.integrate(maxEval, (CalculusFieldUnivariateFunction<FieldComplex<T>>)new Third<FieldComplex<T>>(n, m), (FieldComplex<T>)((FieldComplexField)phi.getField()).getZero(), phi);
    }

    private static class Third<T extends CalculusFieldElement<T>>
    implements CalculusFieldUnivariateFunction<T> {
        private final T n;
        private final T m;

        Third(T n, T m) {
            this.n = n;
            this.m = m;
        }

        @Override
        public T value(T theta) {
            CalculusFieldElement sin = (CalculusFieldElement)theta.sin();
            CalculusFieldElement sin2 = sin.multiply(sin);
            CalculusFieldElement d1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sin2.multiply(this.m)).negate()).add(1.0)).sqrt();
            CalculusFieldElement da = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sin2.multiply(this.n)).negate()).add(1.0);
            return (T)((CalculusFieldElement)d1.multiply(da).reciprocal());
        }
    }

    private static class Second<T extends CalculusFieldElement<T>>
    implements CalculusFieldUnivariateFunction<T> {
        private final T m;

        Second(T m) {
            this.m = m;
        }

        @Override
        public T value(T theta) {
            CalculusFieldElement sin = (CalculusFieldElement)theta.sin();
            CalculusFieldElement sin2 = sin.multiply(sin);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sin2.multiply(this.m)).negate()).add(1.0)).sqrt());
        }
    }

    private static class First<T extends CalculusFieldElement<T>>
    implements CalculusFieldUnivariateFunction<T> {
        private final T m;

        First(T m) {
            this.m = m;
        }

        @Override
        public T value(T theta) {
            CalculusFieldElement sin = (CalculusFieldElement)theta.sin();
            CalculusFieldElement sin2 = sin.multiply(sin);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sin2.multiply(this.m)).negate()).add(1.0)).sqrt()).reciprocal());
        }
    }

    private static class FieldArgumentReduction<T extends CalculusFieldElement<T>> {
        private final T complete;
        private final T csc2;
        private boolean negate;

        FieldArgumentReduction(T phi, T m, Function<T, T> integral) {
            T sin = FastMath.sin(phi);
            int p = (int)FastMath.rint(phi.getReal() / Math.PI);
            this.complete = p == 0 ? (CalculusFieldElement)phi.getField().getZero() : (CalculusFieldElement)((CalculusFieldElement)integral.apply(m)).multiply(2 * p);
            this.negate = sin.getReal() < 0.0 ^ (p & 1) == 1;
            this.csc2 = (CalculusFieldElement)((CalculusFieldElement)sin.multiply(sin)).reciprocal();
        }
    }

    private static class DoubleArgumentReduction {
        private final double complete;
        private final double csc2;
        private boolean negate;

        DoubleArgumentReduction(double phi, double m, DoubleFunction<Double> integral) {
            double sin = FastMath.sin(phi);
            int p = (int)FastMath.rint(phi / Math.PI);
            this.complete = p == 0 ? 0.0 : integral.apply(m) * 2.0 * (double)p;
            this.negate = sin < 0.0 ^ (p & 1) == 1;
            this.csc2 = 1.0 / (sin * sin);
        }
    }
}

