/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.carlson.FieldDuplication;
import org.hipparchus.special.elliptic.carlson.RcFieldDuplication;
import org.hipparchus.util.FastMath;

class RjFieldDuplication<T extends CalculusFieldElement<T>>
extends FieldDuplication<T> {
    private T delta;
    private T sM;

    RjFieldDuplication(T x, T y, T z, T p, T delta) {
        super(new CalculusFieldElement[]{x, y, z, p});
        this.delta = delta;
    }

    @Override
    protected void initialMeanPoint(T[] va) {
        va[4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)va[0].add(va[1])).add(va[2])).add((CalculusFieldElement)va[3].multiply(2)).divide(5.0);
    }

    @Override
    protected T convergenceCriterion(T r, T max) {
        return (T)max.divide((CalculusFieldElement)FastMath.sqrt(FastMath.sqrt(FastMath.sqrt((CalculusFieldElement)r.multiply(0.25)))));
    }

    @Override
    protected void update(int m, T[] vaM, T[] sqrtM, double fourM) {
        CalculusFieldElement dM = ((CalculusFieldElement)sqrtM[3].add(sqrtM[0])).multiply((CalculusFieldElement)sqrtM[3].add(sqrtM[1])).multiply((CalculusFieldElement)sqrtM[3].add(sqrtM[2]));
        if (m == 0) {
            this.sM = (CalculusFieldElement)dM.multiply(0.5);
        } else {
            CalculusFieldElement rM = this.sM.multiply((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.delta.divide((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sM.multiply(this.sM)).multiply(fourM))).add(1.0)).sqrt()).add(1.0)));
            this.sM = dM.multiply(rM).subtract((CalculusFieldElement)this.delta.divide((double)(fourM * fourM))).divide((CalculusFieldElement)dM.add((CalculusFieldElement)rM.divide(fourM)).multiply(2));
        }
        CalculusFieldElement lambdaA = (CalculusFieldElement)sqrtM[0].multiply(sqrtM[1]);
        CalculusFieldElement lambdaB = (CalculusFieldElement)sqrtM[0].multiply(sqrtM[2]);
        CalculusFieldElement lambdaC = (CalculusFieldElement)sqrtM[1].multiply(sqrtM[2]);
        vaM[0] = vaM[0].linearCombination(0.25, vaM[0], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[1] = vaM[1].linearCombination(0.25, vaM[1], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[2] = vaM[2].linearCombination(0.25, vaM[2], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[3] = vaM[3].linearCombination(0.25, vaM[3], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[4] = vaM[4].linearCombination(0.25, vaM[4], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
    }

    @Override
    protected T evaluate(T[] va0, T aM, double fourM) {
        CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)aM.multiply(fourM)).reciprocal();
        CalculusFieldElement bigX = ((CalculusFieldElement)va0[4].subtract(va0[0])).multiply(inv);
        CalculusFieldElement bigY = ((CalculusFieldElement)va0[4].subtract(va0[1])).multiply(inv);
        CalculusFieldElement bigZ = ((CalculusFieldElement)va0[4].subtract(va0[2])).multiply(inv);
        CalculusFieldElement bigP = (CalculusFieldElement)bigX.add(bigY).add(bigZ).multiply(-0.5);
        CalculusFieldElement bigP2 = bigP.multiply(bigP);
        CalculusFieldElement xyz = bigX.multiply(bigY).multiply(bigZ);
        CalculusFieldElement e2 = bigX.multiply(bigY.add(bigZ)).add(bigY.multiply(bigZ)).subtract((CalculusFieldElement)bigP.multiply(bigP).multiply(3));
        CalculusFieldElement e3 = xyz.add(((CalculusFieldElement)bigP.multiply(2)).multiply(e2.add((CalculusFieldElement)bigP2.multiply(2))));
        CalculusFieldElement e4 = ((CalculusFieldElement)xyz.multiply(2)).add(bigP.multiply(e2.add((CalculusFieldElement)bigP2.multiply(3)))).multiply(bigP);
        CalculusFieldElement e5 = xyz.multiply(bigP2);
        CalculusFieldElement e2e2 = e2.multiply(e2);
        CalculusFieldElement e2e3 = e2.multiply(e3);
        CalculusFieldElement e2e4 = e2.multiply(e4);
        CalculusFieldElement e2e5 = e2.multiply(e5);
        CalculusFieldElement e3e3 = e3.multiply(e3);
        CalculusFieldElement e3e4 = e3.multiply(e4);
        CalculusFieldElement e2e2e2 = e2e2.multiply(e2);
        CalculusFieldElement e2e2e3 = e2e2.multiply(e3);
        CalculusFieldElement poly = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e3e4.add(e2e5).multiply(-540540.0)).add((CalculusFieldElement)e2e2e3.multiply(675675.0)).add((CalculusFieldElement)e2e4.multiply(612612.0)).add((CalculusFieldElement)e3e3.multiply(306306.0)).add((CalculusFieldElement)e2e2e2.multiply(-255255.0)).add((CalculusFieldElement)e5.multiply(471240.0)).add((CalculusFieldElement)e2e3.multiply(-706860.0)).add((CalculusFieldElement)e4.multiply(-556920.0)).add((CalculusFieldElement)e2e2.multiply(417690.0)).add((CalculusFieldElement)e3.multiply(680680.0)).add((CalculusFieldElement)e2.multiply(-875160.0)).add(4084080.0)).divide(4084080.0);
        CalculusFieldElement polyTerm = poly.divide((CalculusFieldElement)((CalculusFieldElement)aM.multiply(FastMath.sqrt(aM))).multiply(fourM));
        CalculusFieldElement rcTerm = (CalculusFieldElement)((CalculusFieldElement)new RcFieldDuplication<CalculusFieldElement>((CalculusFieldElement)poly.getField().getOne(), (CalculusFieldElement)this.delta.divide((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sM.multiply(this.sM)).multiply(fourM))).add(1.0)).integral().multiply(3)).divide(this.sM);
        return (T)polyTerm.add(rcTerm);
    }
}

