/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.special.elliptic.carlson.RealDuplication;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

class RdRealDuplication
extends RealDuplication {
    static final double CONSTANT = 4084080.0;
    static final double E2 = -875160.0;
    static final double E3 = 680680.0;
    static final double E2_E2 = 417690.0;
    static final double E4 = -556920.0;
    static final double E2_E3 = -706860.0;
    static final double E5 = 471240.0;
    static final double E2_E2_E2 = -255255.0;
    static final double E3_E3 = 306306.0;
    static final double E2_E4 = 612612.0;
    static final double E2_E2_E3 = 675675.0;
    static final double E3_E4_P_E2_E5 = -540540.0;
    static final double DENOMINATOR = 4084080.0;
    private double sum = 0.0;

    RdRealDuplication(double x, double y, double z) {
        super(x, y, z);
    }

    @Override
    protected void initialMeanPoint(double[] va) {
        va[3] = (va[0] + va[1] + va[2] * 3.0) / 5.0;
    }

    @Override
    protected double convergenceCriterion(double r, double max) {
        return max / FastMath.sqrt(FastMath.sqrt(FastMath.sqrt(r * 0.25)));
    }

    @Override
    protected void update(int m, double[] vaM, double[] sqrtM, double fourM) {
        double lambdaA = sqrtM[0] * sqrtM[1];
        double lambdaB = sqrtM[0] * sqrtM[2];
        double lambdaC = sqrtM[1] * sqrtM[2];
        double lambda = lambdaA + lambdaB + lambdaC;
        this.sum += 1.0 / ((vaM[2] + lambda) * sqrtM[2] * fourM);
        vaM[0] = MathArrays.linearCombination(0.25, vaM[0], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[1] = MathArrays.linearCombination(0.25, vaM[1], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[2] = MathArrays.linearCombination(0.25, vaM[2], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
        vaM[3] = MathArrays.linearCombination(0.25, vaM[3], 0.25, lambdaA, 0.25, lambdaB, 0.25, lambdaC);
    }

    @Override
    protected double evaluate(double[] va0, double aM, double fourM) {
        double inv = 1.0 / (aM * fourM);
        double bigX = (va0[3] - va0[0]) * inv;
        double bigY = (va0[3] - va0[1]) * inv;
        double bigZ = (bigX + bigY) / -3.0;
        double bigXY = bigX * bigY;
        double bigZ2 = bigZ * bigZ;
        double e2 = bigXY - bigZ2 * 6.0;
        double e3 = (bigXY * 3.0 - bigZ2 * 8.0) * bigZ;
        double e4 = (bigXY - bigZ2) * 3.0 * bigZ2;
        double e5 = bigXY * bigZ2 * bigZ;
        double e2e2 = e2 * e2;
        double e2e3 = e2 * e3;
        double e2e4 = e2 * e4;
        double e2e5 = e2 * e5;
        double e3e3 = e3 * e3;
        double e3e4 = e3 * e4;
        double e2e2e2 = e2e2 * e2;
        double e2e2e3 = e2e2 * e3;
        double poly = ((e3e4 + e2e5) * -540540.0 + e2e2e3 * 675675.0 + e2e4 * 612612.0 + e3e3 * 306306.0 + e2e2e2 * -255255.0 + e5 * 471240.0 + e2e3 * -706860.0 + e4 * -556920.0 + e2e2 * 417690.0 + e3 * 680680.0 + e2 * -875160.0 + 4084080.0) / 4084080.0;
        double polyTerm = poly / (aM * FastMath.sqrt(aM) * fourM);
        return polyTerm + this.sum * 3.0;
    }
}

