/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.Arrays;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;

public class SemiDefinitePositiveCholeskyDecomposition {
    public static final double POSITIVITY_THRESHOLD = 1.0E-15;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public SemiDefinitePositiveCholeskyDecomposition(RealMatrix matrix) {
        this(matrix, 1.0E-15);
    }

    public SemiDefinitePositiveCholeskyDecomposition(RealMatrix matrix, double positivityThreshold) {
        int i;
        if (!matrix.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int order = matrix.getRowDimension();
        double[][] lTData = matrix.getData();
        this.cachedL = MatrixUtils.createRealMatrix(lTData);
        int def = 1;
        double[] zeroArray = new double[order];
        Arrays.fill(zeroArray, 0.0);
        for (i = 0; i < order; ++i) {
            this.cachedL.setColumn(i, zeroArray);
        }
        for (i = 0; i < order; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                double s = lTData[i][j];
                for (int k = 0; k < j; ++k) {
                    s -= this.cachedL.getEntry(i, k) * this.cachedL.getEntry(j, k);
                }
                if (j < i) {
                    if (this.cachedL.getEntry(j, j) > FastMath.ulp(1.0)) {
                        this.cachedL.setEntry(i, j, s / this.cachedL.getEntry(j, j));
                        continue;
                    }
                    this.cachedL.setEntry(i, j, 0.0);
                    continue;
                }
                if (s < -positivityThreshold) {
                    s = 0.0;
                    def = -1;
                } else if (s < positivityThreshold) {
                    s = 0.0;
                    def = FastMath.min(0, def);
                }
                this.cachedL.setEntry(j, j, FastMath.sqrt(s));
            }
        }
        this.cachedLT = this.cachedL.transpose();
        if (def < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NEGATIVE_DEFINITE_MATRIX, new Object[0]);
        }
    }

    public RealMatrix getL() {
        return this.cachedL;
    }

    public RealMatrix getLT() {
        return this.cachedLT;
    }
}

