/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.ComplexField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.SchurTransformer;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class EigenDecompositionNonSymmetric {
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private final double epsilon;
    private Complex[] eigenvalues;
    private List<FieldVector<Complex>> eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVInv;

    public EigenDecompositionNonSymmetric(RealMatrix matrix) {
        this(matrix, 1.0E-12);
    }

    public EigenDecompositionNonSymmetric(RealMatrix matrix, double epsilon) throws MathRuntimeException {
        this.epsilon = epsilon;
        this.findEigenVectorsFromSchur(this.transformToSchur(matrix));
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int m = this.eigenvectors.size();
            this.cachedV = MatrixUtils.createRealMatrix(m, m);
            for (int k = 0; k < m; ++k) {
                int l;
                FieldVector<Complex> ek = this.eigenvectors.get(k);
                if (this.eigenvalues[k].getImaginaryPart() >= 0.0) {
                    for (l = 0; l < m; ++l) {
                        this.cachedV.setEntry(l, k, ek.getEntry(l).getRealPart());
                    }
                    continue;
                }
                for (l = 0; l < m; ++l) {
                    this.cachedV.setEntry(l, k, -ek.getEntry(l).getImaginaryPart());
                }
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealMatrix(this.eigenvalues.length, this.eigenvalues.length);
            for (int i = 0; i < this.eigenvalues.length; ++i) {
                this.cachedD.setEntry(i, i, this.eigenvalues[i].getRealPart());
                if (Precision.compareTo(this.eigenvalues[i].getImaginaryPart(), 0.0, this.epsilon) > 0) {
                    this.cachedD.setEntry(i, i + 1, this.eigenvalues[i].getImaginaryPart());
                    continue;
                }
                if (Precision.compareTo(this.eigenvalues[i].getImaginaryPart(), 0.0, this.epsilon) >= 0) continue;
                this.cachedD.setEntry(i, i - 1, this.eigenvalues[i].getImaginaryPart());
            }
        }
        return this.cachedD;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public RealMatrix getVInv() {
        if (this.cachedVInv == null) {
            this.cachedVInv = MatrixUtils.inverse(this.getV(), this.epsilon);
        }
        return this.cachedVInv;
    }

    public Complex[] getEigenvalues() {
        return (Complex[])this.eigenvalues.clone();
    }

    public Complex getEigenvalue(int i) {
        return this.eigenvalues[i];
    }

    public FieldVector<Complex> getEigenvector(int i) {
        return this.eigenvectors.get(i).copy();
    }

    public Complex getDeterminant() {
        Complex determinant = Complex.ONE;
        for (Complex eigenvalue : this.eigenvalues) {
            determinant = determinant.multiply(eigenvalue);
        }
        return determinant;
    }

    private SchurTransformer transformToSchur(RealMatrix matrix) {
        SchurTransformer schurTransform = new SchurTransformer(matrix, this.epsilon);
        double[][] matT = schurTransform.getT().getData();
        double norm = matrix.getNorm1();
        this.eigenvalues = new Complex[matT.length];
        int i = 0;
        while (i < this.eigenvalues.length) {
            if (i == this.eigenvalues.length - 1 || Precision.equals(matT[i + 1][i], 0.0, norm * this.epsilon)) {
                this.eigenvalues[i] = new Complex(matT[i][i]);
                ++i;
                continue;
            }
            double x = matT[i + 1][i + 1];
            double p = 0.5 * (matT[i][i] - x);
            double z = FastMath.sqrt(FastMath.abs(p * p + matT[i + 1][i] * matT[i][i + 1]));
            this.eigenvalues[i++] = new Complex(x + p, z);
            this.eigenvalues[i++] = new Complex(x + p, -z);
        }
        return schurTransform;
    }

    private Complex cdiv(double xr, double xi, double yr, double yi) {
        return new Complex(xr, xi).divide(new Complex(yr, yi));
    }

    private void findEigenVectorsFromSchur(SchurTransformer schur) throws MathRuntimeException {
        double[][] matrixT = schur.getT().getData();
        double[][] matrixP = schur.getP().getData();
        int n = matrixT.length;
        double norm = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = FastMath.max(i - 1, 0); j < n; ++j) {
                norm += FastMath.abs(matrixT[i][j]);
            }
        }
        if (norm == 0.0) {
            throw new MathRuntimeException(LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        for (int idx = n - 1; idx >= 0; --idx) {
            double t;
            int i;
            int l;
            double p = this.eigenvalues[idx].getRealPart();
            double q = this.eigenvalues[idx].getImaginaryPart();
            if (Precision.equals(q, 0.0)) {
                l = idx;
                matrixT[idx][idx] = 1.0;
                for (i = idx - 1; i >= 0; --i) {
                    double w = matrixT[i][i] - p;
                    r = 0.0;
                    for (int j = l; j <= idx; ++j) {
                        r += matrixT[i][j] * matrixT[j][idx];
                    }
                    if (Precision.compareTo(this.eigenvalues[i].getImaginaryPart(), 0.0, this.epsilon) < 0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (Precision.equals(this.eigenvalues[i].getImaginaryPart(), 0.0)) {
                        matrixT[i][idx] = w != 0.0 ? -r / w : -r / (Precision.EPSILON * norm);
                    } else {
                        double x = matrixT[i][i + 1];
                        double y = matrixT[i + 1][i];
                        q = (this.eigenvalues[i].getRealPart() - p) * (this.eigenvalues[i].getRealPart() - p) + this.eigenvalues[i].getImaginaryPart() * this.eigenvalues[i].getImaginaryPart();
                        matrixT[i][idx] = t = (x * s - z * r) / q;
                        matrixT[i + 1][idx] = FastMath.abs(x) > FastMath.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    double t2 = FastMath.abs(matrixT[i][idx]);
                    if (!(Precision.EPSILON * t2 * t2 > 1.0)) continue;
                    for (int j = i; j <= idx; ++j) {
                        double[] dArray = matrixT[j];
                        int n2 = idx;
                        dArray[n2] = dArray[n2] / t2;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = idx - 1;
            if (FastMath.abs(matrixT[idx][idx - 1]) > FastMath.abs(matrixT[idx - 1][idx])) {
                matrixT[idx - 1][idx - 1] = q / matrixT[idx][idx - 1];
                matrixT[idx - 1][idx] = -(matrixT[idx][idx] - p) / matrixT[idx][idx - 1];
            } else {
                Complex result = this.cdiv(0.0, -matrixT[idx - 1][idx], matrixT[idx - 1][idx - 1] - p, q);
                matrixT[idx - 1][idx - 1] = result.getReal();
                matrixT[idx - 1][idx] = result.getImaginary();
            }
            matrixT[idx][idx - 1] = 0.0;
            matrixT[idx][idx] = 1.0;
            for (i = idx - 2; i >= 0; --i) {
                double ra = 0.0;
                double sa = 0.0;
                for (int j = l; j <= idx; ++j) {
                    ra += matrixT[i][j] * matrixT[j][idx - 1];
                    sa += matrixT[i][j] * matrixT[j][idx];
                }
                double w = matrixT[i][i] - p;
                if (Precision.compareTo(this.eigenvalues[i].getImaginaryPart(), 0.0, this.epsilon) < 0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (Precision.equals(this.eigenvalues[i].getImaginaryPart(), 0.0)) {
                    Complex c = this.cdiv(-ra, -sa, w, q);
                    matrixT[i][idx - 1] = c.getReal();
                    matrixT[i][idx] = c.getImaginary();
                } else {
                    double x = matrixT[i][i + 1];
                    double y = matrixT[i + 1][i];
                    double vr = (this.eigenvalues[i].getRealPart() - p) * (this.eigenvalues[i].getRealPart() - p) + this.eigenvalues[i].getImaginaryPart() * this.eigenvalues[i].getImaginaryPart() - q * q;
                    double vi = (this.eigenvalues[i].getRealPart() - p) * 2.0 * q;
                    if (Precision.equals(vr, 0.0) && Precision.equals(vi, 0.0)) {
                        vr = Precision.EPSILON * norm * (FastMath.abs(w) + FastMath.abs(q) + FastMath.abs(x) + FastMath.abs(y) + FastMath.abs(z));
                    }
                    Complex c = this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    matrixT[i][idx - 1] = c.getReal();
                    matrixT[i][idx] = c.getImaginary();
                    if (FastMath.abs(x) > FastMath.abs(z) + FastMath.abs(q)) {
                        matrixT[i + 1][idx - 1] = (-ra - w * matrixT[i][idx - 1] + q * matrixT[i][idx]) / x;
                        matrixT[i + 1][idx] = (-sa - w * matrixT[i][idx] - q * matrixT[i][idx - 1]) / x;
                    } else {
                        Complex c2 = this.cdiv(-r - y * matrixT[i][idx - 1], -s - y * matrixT[i][idx], z, q);
                        matrixT[i + 1][idx - 1] = c2.getReal();
                        matrixT[i + 1][idx] = c2.getImaginary();
                    }
                }
                t = FastMath.max(FastMath.abs(matrixT[i][idx - 1]), FastMath.abs(matrixT[i][idx]));
                if (!(Precision.EPSILON * t * t > 1.0)) continue;
                for (int j = i; j <= idx; ++j) {
                    double[] dArray = matrixT[j];
                    int n3 = idx - 1;
                    dArray[n3] = dArray[n3] / t;
                    double[] dArray2 = matrixT[j];
                    int n4 = idx;
                    dArray2[n4] = dArray2[n4] / t;
                }
            }
        }
        for (int j = n - 1; j >= 0; --j) {
            for (int i = 0; i <= n - 1; ++i) {
                z = 0.0;
                for (int k = 0; k <= FastMath.min(j, n - 1); ++k) {
                    z += matrixP[i][k] * matrixT[k][j];
                }
                matrixP[i][j] = z;
            }
        }
        this.eigenvectors = new ArrayList<FieldVector<Complex>>(n);
        for (int i = 0; i < n; ++i) {
            ArrayFieldVector<Complex> ei = new ArrayFieldVector<Complex>(ComplexField.getInstance(), n);
            for (int j = 0; j < n; ++j) {
                if (Precision.compareTo(this.eigenvalues[i].getImaginaryPart(), 0.0, this.epsilon) > 0) {
                    ei.setEntry(j, new Complex(matrixP[j][i], matrixP[j][i + 1]));
                    continue;
                }
                if (Precision.compareTo(this.eigenvalues[i].getImaginaryPart(), 0.0, this.epsilon) < 0) {
                    ei.setEntry(j, new Complex(matrixP[j][i - 1], -matrixP[j][i]));
                    continue;
                }
                ei.setEntry(j, new Complex(matrixP[j][i]));
            }
            this.eigenvectors.add(ei);
        }
    }
}

