/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.fraction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.fraction.BigFractionField;
import org.hipparchus.fraction.ConvergentsIterator;
import org.hipparchus.util.ArithmeticUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Pair;
import org.hipparchus.util.Precision;

public class BigFraction
extends Number
implements FieldElement<BigFraction>,
Comparable<BigFraction>,
Serializable {
    public static final BigFraction TWO = new BigFraction(2);
    public static final BigFraction ONE = new BigFraction(1);
    public static final BigFraction ZERO = new BigFraction(0);
    public static final BigFraction MINUS_ONE = new BigFraction(-1);
    public static final BigFraction FOUR_FIFTHS = new BigFraction(4, 5);
    public static final BigFraction ONE_FIFTH = new BigFraction(1, 5);
    public static final BigFraction ONE_HALF = new BigFraction(1, 2);
    public static final BigFraction ONE_QUARTER = new BigFraction(1, 4);
    public static final BigFraction ONE_THIRD = new BigFraction(1, 3);
    public static final BigFraction THREE_FIFTHS = new BigFraction(3, 5);
    public static final BigFraction THREE_QUARTERS = new BigFraction(3, 4);
    public static final BigFraction TWO_FIFTHS = new BigFraction(2, 5);
    public static final BigFraction TWO_QUARTERS = new BigFraction(2, 4);
    public static final BigFraction TWO_THIRDS = new BigFraction(2, 3);
    private static final long serialVersionUID = -5630213147331578515L;
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    private static final Function<ConvergentsIterator.ConvergenceStep, BigFraction> STEP_TO_FRACTION = s -> new BigFraction(s.getNumerator(), s.getDenominator());
    private final BigInteger numerator;
    private final BigInteger denominator;

    public BigFraction(BigInteger num) {
        this(num, BigInteger.ONE);
    }

    public BigFraction(BigInteger num, BigInteger den) {
        MathUtils.checkNotNull(num, LocalizedCoreFormats.NUMERATOR, new Object[0]);
        MathUtils.checkNotNull(den, LocalizedCoreFormats.DENOMINATOR, new Object[0]);
        if (den.signum() == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (num.signum() == 0) {
            this.numerator = BigInteger.ZERO;
            this.denominator = BigInteger.ONE;
        } else {
            BigInteger gcd = num.gcd(den);
            if (BigInteger.ONE.compareTo(gcd) < 0) {
                num = num.divide(gcd);
                den = den.divide(gcd);
            }
            if (den.signum() == -1) {
                num = num.negate();
                den = den.negate();
            }
            this.numerator = num;
            this.denominator = den;
        }
    }

    public BigFraction(double value) throws MathIllegalArgumentException {
        if (Double.isNaN(value)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NAN_VALUE_CONVERSION, new Object[0]);
        }
        if (Double.isInfinite(value)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INFINITE_VALUE_CONVERSION, new Object[0]);
        }
        long bits = Double.doubleToLongBits(value);
        long sign = bits & Long.MIN_VALUE;
        long exponent = bits & 0x7FF0000000000000L;
        long m = bits & 0xFFFFFFFFFFFFFL;
        if (exponent != 0L) {
            m |= 0x10000000000000L;
        }
        if (sign != 0L) {
            m = -m;
        }
        int k = (int)(exponent >> 52) - 1075;
        while ((m & 0x1FFFFFFFFFFFFEL) != 0L && (m & 1L) == 0L) {
            m >>= 1;
            ++k;
        }
        if (k < 0) {
            this.numerator = BigInteger.valueOf(m);
            this.denominator = BigInteger.ZERO.flipBit(-k);
        } else {
            this.numerator = BigInteger.valueOf(m).multiply(BigInteger.ZERO.flipBit(k));
            this.denominator = BigInteger.ONE;
        }
    }

    public BigFraction(double value, double epsilon, int maxIterations) throws MathIllegalStateException {
        ConvergentsIterator.ConvergenceStep converged = ConvergentsIterator.convergent(value, maxIterations, (ConvergentsIterator.ConvergenceStep s) -> {
            double quotient = s.getFractionValue();
            return Precision.equals(quotient, value, 1) || FastMath.abs(quotient - value) < epsilon;
        }).getKey();
        if (!(FastMath.abs(converged.getFractionValue() - value) < epsilon)) {
            throw new MathIllegalStateException(LocalizedCoreFormats.FAILED_FRACTION_CONVERSION, value, maxIterations);
        }
        this.numerator = BigInteger.valueOf(converged.getNumerator());
        this.denominator = BigInteger.valueOf(converged.getDenominator());
    }

    public BigFraction(double value, long maxDenominator) throws MathIllegalStateException {
        int maxIterations = 100;
        ConvergentsIterator.ConvergenceStep[] lastValid = new ConvergentsIterator.ConvergenceStep[1];
        ConvergentsIterator.convergent(value, 100, (ConvergentsIterator.ConvergenceStep s) -> {
            if (s.getDenominator() < maxDenominator) {
                lastValid[0] = s;
            }
            return Precision.equals(s.getFractionValue(), value, 1);
        });
        if (lastValid[0] == null) {
            throw new MathIllegalStateException(LocalizedCoreFormats.FAILED_FRACTION_CONVERSION, value, 100);
        }
        this.numerator = BigInteger.valueOf(lastValid[0].getNumerator());
        this.denominator = BigInteger.valueOf(lastValid[0].getDenominator());
    }

    public BigFraction(int num) {
        this(BigInteger.valueOf(num), BigInteger.ONE);
    }

    public BigFraction(int num, int den) {
        this(BigInteger.valueOf(num), BigInteger.valueOf(den));
    }

    public BigFraction(long num) {
        this(BigInteger.valueOf(num), BigInteger.ONE);
    }

    public BigFraction(long num, long den) {
        this(BigInteger.valueOf(num), BigInteger.valueOf(den));
    }

    public static Stream<BigFraction> convergents(double value, int maxConvergents) {
        return ConvergentsIterator.convergents(value, maxConvergents).map(STEP_TO_FRACTION);
    }

    public static Pair<BigFraction, Boolean> convergent(double value, int maxConvergents, ConvergenceTest convergenceTest) {
        Pair<ConvergentsIterator.ConvergenceStep, Boolean> converged = ConvergentsIterator.convergent(value, maxConvergents, (ConvergentsIterator.ConvergenceStep s) -> convergenceTest.test(s.getNumerator(), s.getDenominator()));
        return Pair.create(STEP_TO_FRACTION.apply(converged.getKey()), converged.getValue());
    }

    @Override
    public double getReal() {
        return this.doubleValue();
    }

    public static BigFraction getReducedFraction(int numerator, int denominator) {
        if (numerator == 0) {
            return ZERO;
        }
        return new BigFraction(numerator, denominator);
    }

    public BigFraction abs() {
        return this.numerator.signum() == 1 ? this : this.negate();
    }

    public boolean isInteger() {
        return this.denominator.equals(BigInteger.ONE);
    }

    public int signum() {
        return this.numerator.signum();
    }

    @Override
    public BigFraction add(BigInteger bg) throws NullArgumentException {
        MathUtils.checkNotNull(bg);
        if (this.numerator.signum() == 0) {
            return new BigFraction(bg);
        }
        if (bg.signum() == 0) {
            return this;
        }
        return new BigFraction(this.numerator.add(this.denominator.multiply(bg)), this.denominator);
    }

    @Override
    public BigFraction add(int i) {
        return this.add(BigInteger.valueOf(i));
    }

    @Override
    public BigFraction add(long l) {
        return this.add(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction add(BigFraction fraction) {
        BigInteger den;
        BigInteger num;
        MathUtils.checkNotNull(fraction, LocalizedCoreFormats.FRACTION, new Object[0]);
        if (fraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return fraction;
        }
        if (this.denominator.equals(fraction.denominator)) {
            num = this.numerator.add(fraction.numerator);
            den = this.denominator;
        } else {
            num = this.numerator.multiply(fraction.denominator).add(fraction.numerator.multiply(this.denominator));
            den = this.denominator.multiply(fraction.denominator);
        }
        if (num.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(num, den);
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal bigDecimalValue(RoundingMode roundingMode) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), roundingMode);
    }

    public BigDecimal bigDecimalValue(int scale, RoundingMode roundingMode) {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), scale, roundingMode);
    }

    @Override
    public int compareTo(BigFraction object) {
        int rhsSigNum;
        int lhsSigNum = this.numerator.signum();
        if (lhsSigNum != (rhsSigNum = object.numerator.signum())) {
            return lhsSigNum > rhsSigNum ? 1 : -1;
        }
        if (lhsSigNum == 0) {
            return 0;
        }
        BigInteger nOd = this.numerator.multiply(object.denominator);
        BigInteger dOn = this.denominator.multiply(object.numerator);
        return nOd.compareTo(dOn);
    }

    @Override
    public BigFraction divide(BigInteger bg) {
        MathUtils.checkNotNull(bg);
        if (bg.signum() == 0) {
            throw new MathRuntimeException(LocalizedCoreFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator, this.denominator.multiply(bg));
    }

    @Override
    public BigFraction divide(int i) {
        return this.divide(BigInteger.valueOf(i));
    }

    @Override
    public BigFraction divide(long l) {
        return this.divide(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction divide(BigFraction fraction) {
        MathUtils.checkNotNull(fraction, LocalizedCoreFormats.FRACTION, new Object[0]);
        if (fraction.numerator.signum() == 0) {
            throw new MathRuntimeException(LocalizedCoreFormats.ZERO_DENOMINATOR, new Object[0]);
        }
        if (this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(fraction.reciprocal());
    }

    @Override
    public double doubleValue() {
        double result = this.numerator.doubleValue() / this.denominator.doubleValue();
        if (Double.isInfinite(result) || Double.isNaN(result)) {
            int shift = FastMath.max(this.numerator.bitLength(), this.denominator.bitLength()) - FastMath.getExponent(Double.MAX_VALUE);
            result = this.numerator.shiftRight(shift).doubleValue() / this.denominator.shiftRight(shift).doubleValue();
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (this == other) {
            ret = true;
        } else if (other instanceof BigFraction) {
            BigFraction rhs = (BigFraction)other;
            ret = this.numerator.equals(rhs.numerator) && this.denominator.equals(rhs.denominator);
        }
        return ret;
    }

    @Override
    public float floatValue() {
        float result = this.numerator.floatValue() / this.denominator.floatValue();
        if (Double.isNaN(result)) {
            int shift = FastMath.max(this.numerator.bitLength(), this.denominator.bitLength()) - FastMath.getExponent(Float.MAX_VALUE);
            result = this.numerator.shiftRight(shift).floatValue() / this.denominator.shiftRight(shift).floatValue();
        }
        return result;
    }

    private static BigInteger lcm(BigInteger i0, BigInteger i1) {
        if (i0.signum() == 0 && i1.signum() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger a = i0.abs();
        BigInteger b = i1.abs();
        BigInteger gcd = i0.gcd(b);
        return a.multiply(b).divide(gcd);
    }

    public BigFraction gcd(BigFraction s) {
        if (s.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return s;
        }
        BigInteger p = this.numerator.gcd(s.numerator);
        BigInteger q = BigFraction.lcm(this.denominator, s.denominator);
        return new BigFraction(p, q);
    }

    public BigFraction lcm(BigFraction s) {
        if (s.isZero()) {
            return ZERO;
        }
        if (this.isZero()) {
            return ZERO;
        }
        return new BigFraction(BigFraction.lcm(this.numerator, s.numerator), this.denominator.gcd(s.denominator));
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public int getDenominatorAsInt() {
        return this.denominator.intValue();
    }

    public long getDenominatorAsLong() {
        return this.denominator.longValue();
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public int getNumeratorAsInt() {
        return this.numerator.intValue();
    }

    public long getNumeratorAsLong() {
        return this.numerator.longValue();
    }

    public int hashCode() {
        return 37 * (629 + this.numerator.hashCode()) + this.denominator.hashCode();
    }

    @Override
    public int intValue() {
        return this.numerator.divide(this.denominator).intValue();
    }

    @Override
    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    @Override
    public BigFraction multiply(BigInteger bg) {
        MathUtils.checkNotNull(bg);
        if (this.numerator.signum() == 0 || bg.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(bg.multiply(this.numerator), this.denominator);
    }

    @Override
    public BigFraction multiply(int i) {
        if (i == 0 || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(i));
    }

    @Override
    public BigFraction multiply(long l) {
        if (l == 0L || this.numerator.signum() == 0) {
            return ZERO;
        }
        return this.multiply(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction multiply(BigFraction fraction) {
        MathUtils.checkNotNull(fraction, LocalizedCoreFormats.FRACTION, new Object[0]);
        if (this.numerator.signum() == 0 || fraction.numerator.signum() == 0) {
            return ZERO;
        }
        return new BigFraction(this.numerator.multiply(fraction.numerator), this.denominator.multiply(fraction.denominator));
    }

    @Override
    public BigFraction negate() {
        return new BigFraction(this.numerator.negate(), this.denominator);
    }

    public double percentageValue() {
        return this.multiply(ONE_HUNDRED).doubleValue();
    }

    public BigFraction pow(int exponent) {
        if (exponent == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (exponent < 0) {
            return new BigFraction(this.denominator.pow(-exponent), this.numerator.pow(-exponent));
        }
        return new BigFraction(this.numerator.pow(exponent), this.denominator.pow(exponent));
    }

    public BigFraction pow(long exponent) {
        if (exponent == 0L) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (exponent < 0L) {
            return new BigFraction(ArithmeticUtils.pow(this.denominator, -exponent), ArithmeticUtils.pow(this.numerator, -exponent));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, exponent), ArithmeticUtils.pow(this.denominator, exponent));
    }

    public BigFraction pow(BigInteger exponent) {
        if (exponent.signum() == 0) {
            return ONE;
        }
        if (this.numerator.signum() == 0) {
            return this;
        }
        if (exponent.signum() == -1) {
            BigInteger eNeg = exponent.negate();
            return new BigFraction(ArithmeticUtils.pow(this.denominator, eNeg), ArithmeticUtils.pow(this.numerator, eNeg));
        }
        return new BigFraction(ArithmeticUtils.pow(this.numerator, exponent), ArithmeticUtils.pow(this.denominator, exponent));
    }

    public double pow(double exponent) {
        return FastMath.pow(this.numerator.doubleValue(), exponent) / FastMath.pow(this.denominator.doubleValue(), exponent);
    }

    @Override
    public BigFraction reciprocal() {
        return new BigFraction(this.denominator, this.numerator);
    }

    public BigFraction reduce() {
        BigInteger gcd = this.numerator.gcd(this.denominator);
        if (BigInteger.ONE.compareTo(gcd) < 0) {
            return new BigFraction(this.numerator.divide(gcd), this.denominator.divide(gcd));
        }
        return this;
    }

    @Override
    public BigFraction subtract(BigInteger bg) {
        MathUtils.checkNotNull(bg);
        if (bg.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return new BigFraction(bg.negate());
        }
        return new BigFraction(this.numerator.subtract(this.denominator.multiply(bg)), this.denominator);
    }

    @Override
    public BigFraction subtract(int i) {
        return this.subtract(BigInteger.valueOf(i));
    }

    @Override
    public BigFraction subtract(long l) {
        return this.subtract(BigInteger.valueOf(l));
    }

    @Override
    public BigFraction subtract(BigFraction fraction) {
        BigInteger den;
        BigInteger num;
        MathUtils.checkNotNull(fraction, LocalizedCoreFormats.FRACTION, new Object[0]);
        if (fraction.numerator.signum() == 0) {
            return this;
        }
        if (this.numerator.signum() == 0) {
            return fraction.negate();
        }
        if (this.denominator.equals(fraction.denominator)) {
            num = this.numerator.subtract(fraction.numerator);
            den = this.denominator;
        } else {
            num = this.numerator.multiply(fraction.denominator).subtract(fraction.numerator.multiply(this.denominator));
            den = this.denominator.multiply(fraction.denominator);
        }
        return new BigFraction(num, den);
    }

    public String toString() {
        if (BigInteger.ONE.equals(this.denominator)) {
            return this.numerator.toString();
        }
        if (BigInteger.ZERO.equals(this.numerator)) {
            return "0";
        }
        return this.numerator + " / " + this.denominator;
    }

    public BigFractionField getField() {
        return BigFractionField.getInstance();
    }

    @FunctionalInterface
    public static interface ConvergenceTest {
        public boolean test(long var1, long var3);
    }
}

