/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.complex.FieldComplexField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class FieldComplex<T extends CalculusFieldElement<T>>
implements CalculusFieldElement<FieldComplex<T>> {
    private static final double LOG10 = 2.302585092994046;
    private final T imaginary;
    private final T real;
    private final transient boolean isNaN;
    private final transient boolean isInfinite;

    public FieldComplex(T real) {
        this((CalculusFieldElement)real, (CalculusFieldElement)real.getField().getZero());
    }

    public FieldComplex(T real, T imaginary) {
        this.real = real;
        this.imaginary = imaginary;
        this.isNaN = real.isNaN() || imaginary.isNaN();
        this.isInfinite = !this.isNaN && (real.isInfinite() || imaginary.isInfinite());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getI(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)field.getZero(), (CalculusFieldElement)field.getOne());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getMinusI(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)field.getZero(), (CalculusFieldElement)((CalculusFieldElement)field.getOne()).negate());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getNaN(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.NaN), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.NaN));
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getInf(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.POSITIVE_INFINITY), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.POSITIVE_INFINITY));
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getOne(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)field.getOne(), (CalculusFieldElement)field.getZero());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getMinusOne(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)field.getOne()).negate(), (CalculusFieldElement)field.getZero());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getZero(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)field.getZero(), (CalculusFieldElement)field.getZero());
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> getPi(Field<T> field) {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)field.getZero()).getPi(), (CalculusFieldElement)field.getZero());
    }

    @Override
    public FieldComplex<T> abs() {
        return this.isNaN ? FieldComplex.getNaN(this.getPartsField()) : this.createComplex(FastMath.hypot(this.real, this.imaginary), (CalculusFieldElement)this.getPartsField().getZero());
    }

    @Override
    public FieldComplex<T> add(FieldComplex<T> addend) throws NullArgumentException {
        MathUtils.checkNotNull(addend);
        if (this.isNaN || addend.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.add(addend.getRealPart()), (CalculusFieldElement)this.imaginary.add(addend.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> add(T addend) {
        if (this.isNaN || addend.isNaN()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.add(addend), this.imaginary);
    }

    @Override
    public FieldComplex<T> add(double addend) {
        if (this.isNaN || Double.isNaN(addend)) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.add(addend), this.imaginary);
    }

    public FieldComplex<T> conjugate() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex(this.real, (CalculusFieldElement)this.imaginary.negate());
    }

    @Override
    public FieldComplex<T> divide(FieldComplex<T> divisor) throws NullArgumentException {
        MathUtils.checkNotNull(divisor);
        if (this.isNaN || divisor.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        T c = divisor.getRealPart();
        T d = divisor.getImaginaryPart();
        if (c.isZero() && d.isZero()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (divisor.isInfinite() && !this.isInfinite()) {
            return FieldComplex.getZero(this.getPartsField());
        }
        if (FastMath.abs(c).getReal() < FastMath.abs(d).getReal()) {
            CalculusFieldElement q = (CalculusFieldElement)c.divide(d);
            CalculusFieldElement invDen = (CalculusFieldElement)((CalculusFieldElement)c.multiply((CalculusFieldElement)q).add(d)).reciprocal();
            return this.createComplex(((CalculusFieldElement)this.real.multiply((CalculusFieldElement)q).add(this.imaginary)).multiply(invDen), ((CalculusFieldElement)this.imaginary.multiply((CalculusFieldElement)q).subtract(this.real)).multiply(invDen));
        }
        CalculusFieldElement q = (CalculusFieldElement)d.divide(c);
        CalculusFieldElement invDen = (CalculusFieldElement)((CalculusFieldElement)d.multiply((CalculusFieldElement)q).add(c)).reciprocal();
        return this.createComplex(((CalculusFieldElement)this.imaginary.multiply((CalculusFieldElement)q).add(this.real)).multiply(invDen), this.imaginary.subtract((CalculusFieldElement)this.real.multiply((CalculusFieldElement)q)).multiply(invDen));
    }

    @Override
    public FieldComplex<T> divide(T divisor) {
        if (this.isNaN || divisor.isNaN()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (divisor.isZero()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (divisor.isInfinite()) {
            return !this.isInfinite() ? FieldComplex.getZero(this.getPartsField()) : FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.divide(divisor), (CalculusFieldElement)this.imaginary.divide(divisor));
    }

    @Override
    public FieldComplex<T> divide(double divisor) {
        if (this.isNaN || Double.isNaN(divisor)) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (divisor == 0.0) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (Double.isInfinite(divisor)) {
            return !this.isInfinite() ? FieldComplex.getZero(this.getPartsField()) : FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.divide((double)divisor), (CalculusFieldElement)this.imaginary.divide((double)divisor));
    }

    @Override
    public FieldComplex<T> reciprocal() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.real.isZero() && this.imaginary.isZero()) {
            return FieldComplex.getInf(this.getPartsField());
        }
        if (this.isInfinite) {
            return FieldComplex.getZero(this.getPartsField());
        }
        if (FastMath.abs(this.real).getReal() < FastMath.abs(this.imaginary).getReal()) {
            CalculusFieldElement q = (CalculusFieldElement)this.real.divide(this.imaginary);
            CalculusFieldElement scale = (CalculusFieldElement)((CalculusFieldElement)this.real.multiply((CalculusFieldElement)q).add(this.imaginary)).reciprocal();
            return this.createComplex(scale.multiply(q), (CalculusFieldElement)scale.negate());
        }
        CalculusFieldElement q = (CalculusFieldElement)this.imaginary.divide(this.real);
        CalculusFieldElement scale = (CalculusFieldElement)((CalculusFieldElement)this.imaginary.multiply((CalculusFieldElement)q).add(this.real)).reciprocal();
        return this.createComplex(scale, ((CalculusFieldElement)scale.negate()).multiply(q));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FieldComplex) {
            FieldComplex c = (FieldComplex)other;
            if (c.isNaN) {
                return this.isNaN;
            }
            return this.real.equals(c.real) && this.imaginary.equals(c.imaginary);
        }
        return false;
    }

    public static <T extends CalculusFieldElement<T>> boolean equals(FieldComplex<T> x, FieldComplex<T> y, int maxUlps) {
        return Precision.equals(x.real.getReal(), y.real.getReal(), maxUlps) && Precision.equals(x.imaginary.getReal(), y.imaginary.getReal(), maxUlps);
    }

    public static <T extends CalculusFieldElement<T>> boolean equals(FieldComplex<T> x, FieldComplex<T> y) {
        return FieldComplex.equals(x, y, 1);
    }

    public static <T extends CalculusFieldElement<T>> boolean equals(FieldComplex<T> x, FieldComplex<T> y, double eps) {
        return Precision.equals(x.real.getReal(), y.real.getReal(), eps) && Precision.equals(x.imaginary.getReal(), y.imaginary.getReal(), eps);
    }

    public static <T extends CalculusFieldElement<T>> boolean equalsWithRelativeTolerance(FieldComplex<T> x, FieldComplex<T> y, double eps) {
        return Precision.equalsWithRelativeTolerance(x.real.getReal(), y.real.getReal(), eps) && Precision.equalsWithRelativeTolerance(x.imaginary.getReal(), y.imaginary.getReal(), eps);
    }

    public int hashCode() {
        if (this.isNaN) {
            return 7;
        }
        return 37 * (17 * this.imaginary.hashCode() + this.real.hashCode());
    }

    @Override
    public boolean isZero() {
        return this.real.isZero() && this.imaginary.isZero();
    }

    public T getImaginary() {
        return this.imaginary;
    }

    public T getImaginaryPart() {
        return this.imaginary;
    }

    @Override
    public double getReal() {
        return this.real.getReal();
    }

    @Override
    public FieldComplex<T> getAddendum() {
        return new FieldComplex<CalculusFieldElement>((CalculusFieldElement)this.real.getAddendum(), (CalculusFieldElement)this.imaginary);
    }

    public T getRealPart() {
        return this.real;
    }

    @Override
    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isReal() {
        return this.imaginary.isZero();
    }

    public boolean isMathematicalInteger() {
        return this.isReal() && Precision.isMathematicalInteger(this.real.getReal());
    }

    @Override
    public boolean isInfinite() {
        return this.isInfinite;
    }

    @Override
    public FieldComplex<T> multiply(FieldComplex<T> factor) throws NullArgumentException {
        MathUtils.checkNotNull(factor);
        if (this.isNaN || factor.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.real.isInfinite() || this.imaginary.isInfinite() || factor.real.isInfinite() || factor.imaginary.isInfinite()) {
            return FieldComplex.getInf(this.getPartsField());
        }
        return this.createComplex(this.real.linearCombination(this.real, factor.real, (CalculusFieldElement)((CalculusFieldElement)this.imaginary.negate()), factor.imaginary), (CalculusFieldElement)this.real.linearCombination(this.real, factor.imaginary, this.imaginary, factor.real));
    }

    @Override
    public FieldComplex<T> multiply(int factor) {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.real.isInfinite() || this.imaginary.isInfinite()) {
            return FieldComplex.getInf(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.multiply(factor), (CalculusFieldElement)this.imaginary.multiply(factor));
    }

    @Override
    public FieldComplex<T> multiply(double factor) {
        if (this.isNaN || Double.isNaN(factor)) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.real.isInfinite() || this.imaginary.isInfinite() || Double.isInfinite(factor)) {
            return FieldComplex.getInf(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.multiply(factor), (CalculusFieldElement)this.imaginary.multiply(factor));
    }

    @Override
    public FieldComplex<T> multiply(T factor) {
        if (this.isNaN || factor.isNaN()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.real.isInfinite() || this.imaginary.isInfinite() || factor.isInfinite()) {
            return FieldComplex.getInf(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.multiply(factor), (CalculusFieldElement)this.imaginary.multiply(factor));
    }

    public FieldComplex<T> multiplyPlusI() {
        return this.createComplex((CalculusFieldElement)this.imaginary.negate(), this.real);
    }

    public FieldComplex<T> multiplyMinusI() {
        return this.createComplex(this.imaginary, (CalculusFieldElement)this.real.negate());
    }

    @Override
    public FieldComplex<T> square() {
        return this.multiply((T)this);
    }

    @Override
    public FieldComplex<T> negate() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.negate(), (CalculusFieldElement)this.imaginary.negate());
    }

    @Override
    public FieldComplex<T> subtract(FieldComplex<T> subtrahend) throws NullArgumentException {
        MathUtils.checkNotNull(subtrahend);
        if (this.isNaN || subtrahend.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.subtract(subtrahend.getRealPart()), (CalculusFieldElement)this.imaginary.subtract(subtrahend.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> subtract(double subtrahend) {
        if (this.isNaN || Double.isNaN(subtrahend)) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.subtract((double)subtrahend), this.imaginary);
    }

    @Override
    public FieldComplex<T> subtract(T subtrahend) {
        if (this.isNaN || subtrahend.isNaN()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex((CalculusFieldElement)this.real.subtract(subtrahend), this.imaginary);
    }

    @Override
    public FieldComplex<T> acos() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return ((FieldComplex)this.add((T)this.sqrt1z().multiplyPlusI()).log()).multiplyMinusI();
    }

    @Override
    public FieldComplex<T> asin() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return ((FieldComplex)this.sqrt1z().add(this.multiplyPlusI()).log()).multiplyMinusI();
    }

    @Override
    public FieldComplex<T> atan() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        CalculusFieldElement one = (CalculusFieldElement)this.getPartsField().getOne();
        if (this.real.isZero()) {
            if (((CalculusFieldElement)this.imaginary.multiply(this.imaginary)).subtract(one).isZero()) {
                return FieldComplex.getNaN(this.getPartsField());
            }
            CalculusFieldElement zero = (CalculusFieldElement)this.getPartsField().getZero();
            FieldElement tmp = ((FieldComplex)this.createComplex(((CalculusFieldElement)one.add(this.imaginary)).divide((CalculusFieldElement)one.subtract(this.imaginary)), zero).log()).multiplyPlusI().multiply(0.5);
            return this.createComplex(FastMath.copySign(((FieldComplex)tmp).real, this.real), ((FieldComplex)tmp).imaginary);
        }
        if (this.imaginary.isZero()) {
            return this.createComplex(FastMath.atan(this.real), this.imaginary);
        }
        FieldComplex<CalculusFieldElement> n = this.createComplex((CalculusFieldElement)one.add(this.imaginary), (CalculusFieldElement)this.real.negate());
        FieldComplex<CalculusFieldElement> d = this.createComplex((CalculusFieldElement)one.subtract(this.imaginary), this.real);
        return ((FieldComplex)n.divide((CalculusFieldElement)d).log()).multiplyPlusI().multiply(0.5);
    }

    @Override
    public FieldComplex<T> cos() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        FieldSinCos<T> scr = FastMath.sinCos(this.real);
        FieldSinhCosh<T> schi = FastMath.sinhCosh(this.imaginary);
        return this.createComplex(((CalculusFieldElement)scr.cos()).multiply((CalculusFieldElement)schi.cosh()), ((CalculusFieldElement)((CalculusFieldElement)scr.sin()).negate()).multiply((CalculusFieldElement)schi.sinh()));
    }

    @Override
    public FieldComplex<T> cosh() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        FieldSinhCosh<T> schr = FastMath.sinhCosh(this.real);
        FieldSinCos<T> sci = FastMath.sinCos(this.imaginary);
        return this.createComplex(((CalculusFieldElement)schr.cosh()).multiply((CalculusFieldElement)sci.cos()), ((CalculusFieldElement)schr.sinh()).multiply((CalculusFieldElement)sci.sin()));
    }

    @Override
    public FieldComplex<T> exp() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        CalculusFieldElement expReal = FastMath.exp(this.real);
        FieldSinCos<T> sc = FastMath.sinCos(this.imaginary);
        return this.createComplex(expReal.multiply((CalculusFieldElement)((CalculusFieldElement)sc.cos())), expReal.multiply((CalculusFieldElement)((CalculusFieldElement)sc.sin())));
    }

    @Override
    public FieldComplex<T> expm1() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        CalculusFieldElement expm1Real = FastMath.expm1(this.real);
        FieldSinCos<T> sc = FastMath.sinCos(this.imaginary);
        return this.createComplex(expm1Real.multiply((CalculusFieldElement)((CalculusFieldElement)sc.cos())), expm1Real.multiply((CalculusFieldElement)((CalculusFieldElement)sc.sin())));
    }

    @Override
    public FieldComplex<T> log() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return this.createComplex(FastMath.log(FastMath.hypot(this.real, this.imaginary)), FastMath.atan2(this.imaginary, this.real));
    }

    @Override
    public FieldComplex<T> log1p() {
        return ((FieldComplex)this.add(1.0)).log();
    }

    @Override
    public FieldComplex<T> log10() {
        return ((FieldComplex)this.log()).divide(2.302585092994046);
    }

    @Override
    public FieldComplex<T> pow(FieldComplex<T> x) throws NullArgumentException {
        MathUtils.checkNotNull(x);
        if (x.imaginary.isZero()) {
            T realPow;
            int nx = (int)FastMath.rint(x.real.getReal());
            if (x.real.getReal() == (double)nx) {
                return this.pow(nx);
            }
            if (this.imaginary.isZero() && (realPow = FastMath.pow(this.real, x.real)).isFinite()) {
                return this.createComplex(realPow, (CalculusFieldElement)this.getPartsField().getZero());
            }
        }
        return ((FieldComplex)this.log()).multiply((T)x).exp();
    }

    @Override
    public FieldComplex<T> pow(T x) {
        T realPow;
        int nx = (int)FastMath.rint(x.getReal());
        if (x.getReal() == (double)nx) {
            return this.pow(nx);
        }
        if (this.imaginary.isZero() && (realPow = FastMath.pow(this.real, x)).isFinite()) {
            return this.createComplex(realPow, (CalculusFieldElement)this.getPartsField().getZero());
        }
        return ((FieldComplex)this.log()).multiply(x).exp();
    }

    @Override
    public FieldComplex<T> pow(double x) {
        T realPow;
        int nx = (int)FastMath.rint(x);
        if (x == (double)nx) {
            return this.pow(nx);
        }
        if (this.imaginary.isZero() && (realPow = FastMath.pow(this.real, x)).isFinite()) {
            return this.createComplex(realPow, (CalculusFieldElement)this.getPartsField().getZero());
        }
        return ((FieldComplex)((FieldComplex)this.log()).multiply(x)).exp();
    }

    @Override
    public FieldComplex<T> pow(int n) {
        boolean invert;
        FieldComplex<FieldComplex> result = ((FieldComplexField)this.getField()).getOne();
        int p = n;
        if (p < 0) {
            invert = true;
            p = -p;
        } else {
            invert = false;
        }
        FieldComplex<FieldComplex> square = this;
        while (p > 0) {
            if ((p & 1) > 0) {
                result = result.multiply((FieldComplex)square);
            }
            square = square.multiply((FieldComplex)square);
            p >>= 1;
        }
        return invert ? result.reciprocal() : result;
    }

    @Override
    public FieldComplex<T> sin() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        FieldSinCos<T> scr = FastMath.sinCos(this.real);
        FieldSinhCosh<T> schi = FastMath.sinhCosh(this.imaginary);
        return this.createComplex(((CalculusFieldElement)scr.sin()).multiply((CalculusFieldElement)schi.cosh()), ((CalculusFieldElement)scr.cos()).multiply((CalculusFieldElement)schi.sinh()));
    }

    @Override
    public FieldSinCos<FieldComplex<T>> sinCos() {
        if (this.isNaN) {
            return new FieldSinCos<FieldComplex<T>>(FieldComplex.getNaN(this.getPartsField()), FieldComplex.getNaN(this.getPartsField()));
        }
        FieldSinCos<T> scr = FastMath.sinCos(this.real);
        FieldSinhCosh<T> schi = FastMath.sinhCosh(this.imaginary);
        return new FieldSinCos<FieldComplex<T>>(this.createComplex(((CalculusFieldElement)scr.sin()).multiply((CalculusFieldElement)schi.cosh()), ((CalculusFieldElement)scr.cos()).multiply((CalculusFieldElement)schi.sinh())), this.createComplex(((CalculusFieldElement)scr.cos()).multiply((CalculusFieldElement)schi.cosh()), ((CalculusFieldElement)((CalculusFieldElement)scr.sin()).negate()).multiply((CalculusFieldElement)schi.sinh())));
    }

    @Override
    public FieldComplex<T> atan2(FieldComplex<T> x) {
        FieldElement r = ((FieldComplex)x.square()).add((T)this.multiply((T)this)).sqrt();
        if (x.real.getReal() >= 0.0) {
            return ((FieldComplex)this.divide((T)((FieldComplex)r).add((T)x)).atan()).multiply(2);
        }
        return ((FieldComplex)((FieldComplex)this.divide((T)((FieldComplex)r).subtract((T)x)).atan()).multiply(-2)).add((T)((CalculusFieldElement)x.real.getPi()));
    }

    @Override
    public FieldComplex<T> acosh() {
        FieldElement sqrtPlus = ((FieldComplex)this.add(1.0)).sqrt();
        FieldElement sqrtMinus = ((FieldComplex)this.subtract(1.0)).sqrt();
        return this.add((T)((FieldComplex)sqrtPlus).multiply((T)sqrtMinus)).log();
    }

    @Override
    public FieldComplex<T> asinh() {
        return this.add((T)((FieldComplex)this.multiply((T)this).add(1.0)).sqrt()).log();
    }

    @Override
    public FieldComplex<T> atanh() {
        FieldElement logPlus = ((FieldComplex)this.add(1.0)).log();
        FieldElement logMinus = this.createComplex((CalculusFieldElement)((CalculusFieldElement)this.getPartsField().getOne()).subtract(this.real), (CalculusFieldElement)this.imaginary.negate()).log();
        return ((FieldComplex)logPlus).subtract((T)logMinus).multiply(0.5);
    }

    @Override
    public FieldComplex<T> sinh() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        FieldSinhCosh<T> schr = FastMath.sinhCosh(this.real);
        FieldSinCos<T> sci = FastMath.sinCos(this.imaginary);
        return this.createComplex(((CalculusFieldElement)schr.sinh()).multiply((CalculusFieldElement)sci.cos()), ((CalculusFieldElement)schr.cosh()).multiply((CalculusFieldElement)sci.sin()));
    }

    @Override
    public FieldSinhCosh<FieldComplex<T>> sinhCosh() {
        if (this.isNaN) {
            return new FieldSinhCosh<FieldComplex<T>>(FieldComplex.getNaN(this.getPartsField()), FieldComplex.getNaN(this.getPartsField()));
        }
        FieldSinhCosh<T> schr = FastMath.sinhCosh(this.real);
        FieldSinCos<T> sci = FastMath.sinCos(this.imaginary);
        return new FieldSinhCosh<FieldComplex<T>>(this.createComplex(((CalculusFieldElement)schr.sinh()).multiply((CalculusFieldElement)sci.cos()), ((CalculusFieldElement)schr.cosh()).multiply((CalculusFieldElement)sci.sin())), this.createComplex(((CalculusFieldElement)schr.cosh()).multiply((CalculusFieldElement)sci.cos()), ((CalculusFieldElement)schr.sinh()).multiply((CalculusFieldElement)sci.sin())));
    }

    @Override
    public FieldComplex<T> sqrt() {
        if (this.isNaN) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.isZero()) {
            return FieldComplex.getZero(this.getPartsField());
        }
        CalculusFieldElement t = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)FastMath.abs(this.real).add(FastMath.hypot(this.real, this.imaginary))).multiply(0.5));
        if (this.real.getReal() >= 0.0) {
            return this.createComplex(t, this.imaginary.divide((CalculusFieldElement)((CalculusFieldElement)t.multiply(2))));
        }
        return this.createComplex(FastMath.abs(this.imaginary).divide((CalculusFieldElement)((CalculusFieldElement)t.multiply(2))), FastMath.copySign(t, this.imaginary));
    }

    public FieldComplex<T> sqrt1z() {
        FieldElement t2 = this.square();
        return this.createComplex((CalculusFieldElement)((CalculusFieldElement)this.getPartsField().getOne()).subtract(((FieldComplex)t2).real), (CalculusFieldElement)((FieldComplex)t2).imaginary.negate()).sqrt();
    }

    @Override
    public FieldComplex<T> cbrt() {
        CalculusFieldElement magnitude = FastMath.cbrt(((FieldComplex)this.abs()).getRealPart());
        FieldSinCos<CalculusFieldElement> sc = FastMath.sinCos((CalculusFieldElement)this.getArgument().divide((double)3.0));
        return this.createComplex(magnitude.multiply((CalculusFieldElement)sc.cos()), magnitude.multiply((CalculusFieldElement)sc.sin()));
    }

    @Override
    public FieldComplex<T> rootN(int n) {
        CalculusFieldElement magnitude = FastMath.pow(((FieldComplex)this.abs()).getRealPart(), 1.0 / (double)n);
        FieldSinCos<CalculusFieldElement> sc = FastMath.sinCos((CalculusFieldElement)this.getArgument().divide((double)n));
        return this.createComplex(magnitude.multiply((CalculusFieldElement)sc.cos()), magnitude.multiply((CalculusFieldElement)sc.sin()));
    }

    @Override
    public FieldComplex<T> tan() {
        if (this.isNaN || this.real.isInfinite()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.imaginary.getReal() > 20.0) {
            return FieldComplex.getI(this.getPartsField());
        }
        if (this.imaginary.getReal() < -20.0) {
            return FieldComplex.getMinusI(this.getPartsField());
        }
        FieldSinCos<CalculusFieldElement> sc2r = FastMath.sinCos((CalculusFieldElement)this.real.multiply(2));
        CalculusFieldElement imaginary2 = (CalculusFieldElement)this.imaginary.multiply(2);
        CalculusFieldElement d = sc2r.cos().add(FastMath.cosh(imaginary2));
        return this.createComplex(sc2r.sin().divide(d), FastMath.sinh(imaginary2).divide(d));
    }

    @Override
    public FieldComplex<T> tanh() {
        if (this.isNaN || this.imaginary.isInfinite()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        if (this.real.getReal() > 20.0) {
            return FieldComplex.getOne(this.getPartsField());
        }
        if (this.real.getReal() < -20.0) {
            return FieldComplex.getMinusOne(this.getPartsField());
        }
        CalculusFieldElement real2 = (CalculusFieldElement)this.real.multiply(2);
        FieldSinCos<CalculusFieldElement> sc2i = FastMath.sinCos((CalculusFieldElement)this.imaginary.multiply(2));
        CalculusFieldElement d = FastMath.cosh(real2).add(sc2i.cos());
        return this.createComplex(FastMath.sinh(real2).divide(d), sc2i.sin().divide(d));
    }

    public T getArgument() {
        return FastMath.atan2(this.getImaginaryPart(), this.getRealPart());
    }

    public List<FieldComplex<T>> nthRoot(int n) throws MathIllegalArgumentException {
        if (n <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N, n);
        }
        ArrayList<FieldComplex<T>> result = new ArrayList<FieldComplex<T>>();
        if (this.isNaN) {
            result.add(FieldComplex.getNaN(this.getPartsField()));
            return result;
        }
        if (this.isInfinite()) {
            result.add(FieldComplex.getInf(this.getPartsField()));
            return result;
        }
        CalculusFieldElement nthRootOfAbs = FastMath.pow(FastMath.hypot(this.real, this.imaginary), 1.0 / (double)n);
        CalculusFieldElement nthPhi = (CalculusFieldElement)this.getArgument().divide((double)n);
        double slice = Math.PI * 2 / (double)n;
        CalculusFieldElement innerPart = nthPhi;
        for (int k = 0; k < n; ++k) {
            FieldSinCos<CalculusFieldElement> scInner = FastMath.sinCos(innerPart);
            CalculusFieldElement realPart = nthRootOfAbs.multiply((CalculusFieldElement)scInner.cos());
            CalculusFieldElement imaginaryPart = nthRootOfAbs.multiply((CalculusFieldElement)scInner.sin());
            result.add(this.createComplex(realPart, imaginaryPart));
            innerPart = (CalculusFieldElement)innerPart.add(slice);
        }
        return result;
    }

    protected FieldComplex<T> createComplex(T realPart, T imaginaryPart) {
        return new FieldComplex<T>(realPart, imaginaryPart);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> valueOf(T realPart, T imaginaryPart) {
        if (realPart.isNaN() || imaginaryPart.isNaN()) {
            return FieldComplex.getNaN(realPart.getField());
        }
        return new FieldComplex<T>(realPart, imaginaryPart);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> valueOf(T realPart) {
        if (realPart.isNaN()) {
            return FieldComplex.getNaN(realPart.getField());
        }
        return new FieldComplex<T>(realPart);
    }

    @Override
    public FieldComplex<T> newInstance(double realPart) {
        return FieldComplex.valueOf((CalculusFieldElement)((CalculusFieldElement)this.getPartsField().getZero()).newInstance(realPart));
    }

    @Override
    public FieldComplexField<T> getField() {
        return FieldComplexField.getField(this.getPartsField());
    }

    public Field<T> getPartsField() {
        return this.real.getField();
    }

    public String toString() {
        return "(" + this.real + ", " + this.imaginary + ")";
    }

    @Override
    public FieldComplex<T> scalb(int n) {
        return this.createComplex(FastMath.scalb(this.real, n), FastMath.scalb(this.imaginary, n));
    }

    @Override
    public FieldComplex<T> ulp() {
        return this.createComplex(FastMath.ulp(this.real), FastMath.ulp(this.imaginary));
    }

    @Override
    public FieldComplex<T> hypot(FieldComplex<T> y) {
        if (this.isInfinite() || y.isInfinite()) {
            return FieldComplex.getInf(this.getPartsField());
        }
        if (this.isNaN() || y.isNaN()) {
            return FieldComplex.getNaN(this.getPartsField());
        }
        return ((FieldComplex)this.square()).add((T)y.square()).sqrt();
    }

    public FieldComplex<T> linearCombination(FieldComplex<T>[] a, FieldComplex<T>[] b) throws MathIllegalArgumentException {
        int n = 2 * a.length;
        FieldElement[] realA = (CalculusFieldElement[])MathArrays.buildArray(this.getPartsField(), (int)n);
        FieldElement[] realB = (CalculusFieldElement[])MathArrays.buildArray(this.getPartsField(), (int)n);
        FieldElement[] imaginaryA = (CalculusFieldElement[])MathArrays.buildArray(this.getPartsField(), (int)n);
        FieldElement[] imaginaryB = (CalculusFieldElement[])MathArrays.buildArray(this.getPartsField(), (int)n);
        for (int i = 0; i < a.length; ++i) {
            FieldComplex<T> ai = a[i];
            FieldComplex<T> bi = b[i];
            realA[2 * i] = ai.real;
            realA[2 * i + 1] = (CalculusFieldElement)ai.imaginary.negate();
            realB[2 * i] = bi.real;
            realB[2 * i + 1] = bi.imaginary;
            imaginaryA[2 * i] = ai.real;
            imaginaryA[2 * i + 1] = ai.imaginary;
            imaginaryB[2 * i] = bi.imaginary;
            imaginaryB[2 * i + 1] = bi.real;
        }
        return this.createComplex((CalculusFieldElement)this.real.linearCombination(realA, realB), (CalculusFieldElement)this.real.linearCombination(imaginaryA, imaginaryB));
    }

    public FieldComplex<T> linearCombination(double[] a, FieldComplex<T>[] b) throws MathIllegalArgumentException {
        int n = a.length;
        FieldElement[] realB = (CalculusFieldElement[])MathArrays.buildArray(this.getPartsField(), (int)n);
        FieldElement[] imaginaryB = (CalculusFieldElement[])MathArrays.buildArray(this.getPartsField(), (int)n);
        for (int i = 0; i < a.length; ++i) {
            FieldComplex<T> bi = b[i];
            realB[i] = bi.real;
            imaginaryB[i] = bi.imaginary;
        }
        return this.createComplex((CalculusFieldElement)this.real.linearCombination(a, realB), (CalculusFieldElement)this.real.linearCombination(a, imaginaryB));
    }

    @Override
    public FieldComplex<T> linearCombination(FieldComplex<T> a1, FieldComplex<T> b1, FieldComplex<T> a2, FieldComplex<T> b2) {
        return this.createComplex(this.real.linearCombination(a1.real, b1.real, (CalculusFieldElement)((CalculusFieldElement)a1.imaginary.negate()), b1.imaginary, a2.real, b2.real, (CalculusFieldElement)((CalculusFieldElement)a2.imaginary.negate()), b2.imaginary), (CalculusFieldElement)this.real.linearCombination(a1.real, b1.imaginary, a1.imaginary, b1.real, a2.real, b2.imaginary, a2.imaginary, b2.real));
    }

    @Override
    public FieldComplex<T> linearCombination(double a1, FieldComplex<T> b1, double a2, FieldComplex<T> b2) {
        return this.createComplex((CalculusFieldElement)this.real.linearCombination(a1, b1.real, a2, b2.real), (CalculusFieldElement)this.real.linearCombination(a1, b1.imaginary, a2, b2.imaginary));
    }

    @Override
    public FieldComplex<T> linearCombination(FieldComplex<T> a1, FieldComplex<T> b1, FieldComplex<T> a2, FieldComplex<T> b2, FieldComplex<T> a3, FieldComplex<T> b3) {
        FieldComplex[] a = (FieldComplex[])MathArrays.buildArray((Field)this.getField(), (int)3);
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        FieldComplex[] b = (FieldComplex[])MathArrays.buildArray((Field)this.getField(), (int)3);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        return this.linearCombination(a, b);
    }

    @Override
    public FieldComplex<T> linearCombination(double a1, FieldComplex<T> b1, double a2, FieldComplex<T> b2, double a3, FieldComplex<T> b3) {
        FieldComplex[] b = (FieldComplex[])MathArrays.buildArray((Field)this.getField(), (int)3);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        return this.linearCombination(new double[]{a1, a2, a3}, b);
    }

    @Override
    public FieldComplex<T> linearCombination(FieldComplex<T> a1, FieldComplex<T> b1, FieldComplex<T> a2, FieldComplex<T> b2, FieldComplex<T> a3, FieldComplex<T> b3, FieldComplex<T> a4, FieldComplex<T> b4) {
        FieldComplex[] a = (FieldComplex[])MathArrays.buildArray((Field)this.getField(), (int)4);
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        a[3] = a4;
        FieldComplex[] b = (FieldComplex[])MathArrays.buildArray((Field)this.getField(), (int)4);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        b[3] = b4;
        return this.linearCombination(a, b);
    }

    @Override
    public FieldComplex<T> linearCombination(double a1, FieldComplex<T> b1, double a2, FieldComplex<T> b2, double a3, FieldComplex<T> b3, double a4, FieldComplex<T> b4) {
        FieldComplex[] b = (FieldComplex[])MathArrays.buildArray((Field)this.getField(), (int)4);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        b[3] = b4;
        return this.linearCombination(new double[]{a1, a2, a3, a4}, b);
    }

    @Override
    public FieldComplex<T> ceil() {
        return this.createComplex(FastMath.ceil(this.getRealPart()), FastMath.ceil(this.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> floor() {
        return this.createComplex(FastMath.floor(this.getRealPart()), FastMath.floor(this.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> rint() {
        return this.createComplex(FastMath.rint(this.getRealPart()), FastMath.rint(this.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> remainder(double a) {
        return this.createComplex(FastMath.IEEEremainder(this.getRealPart(), a), FastMath.IEEEremainder(this.getImaginaryPart(), a));
    }

    @Override
    public FieldComplex<T> remainder(FieldComplex<T> a) {
        FieldComplex<FieldComplex<T>> complexQuotient = this.divide((T)a);
        T qRInt = FastMath.rint(complexQuotient.real);
        T qIInt = FastMath.rint(complexQuotient.imaginary);
        return this.createComplex(this.real.subtract((CalculusFieldElement)((CalculusFieldElement)qRInt.multiply(a.real))).add((CalculusFieldElement)qIInt.multiply(a.imaginary)), this.imaginary.subtract((CalculusFieldElement)((CalculusFieldElement)qRInt.multiply(a.imaginary))).subtract((CalculusFieldElement)qIInt.multiply(a.real)));
    }

    @Override
    public FieldComplex<T> sign() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        return this.divide(FastMath.hypot(this.real, this.imaginary));
    }

    @Override
    public FieldComplex<T> copySign(FieldComplex<T> z) {
        return this.createComplex(FastMath.copySign(this.getRealPart(), z.getRealPart()), FastMath.copySign(this.getImaginaryPart(), z.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> copySign(double r) {
        return this.createComplex(FastMath.copySign(this.getRealPart(), r), FastMath.copySign(this.getImaginaryPart(), r));
    }

    @Override
    public FieldComplex<T> toDegrees() {
        return this.createComplex(FastMath.toDegrees(this.getRealPart()), FastMath.toDegrees(this.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> toRadians() {
        return this.createComplex(FastMath.toRadians(this.getRealPart()), FastMath.toRadians(this.getImaginaryPart()));
    }

    @Override
    public FieldComplex<T> getPi() {
        return FieldComplex.getPi(this.getPartsField());
    }
}

