/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class HermiteInterpolator
implements UnivariateDifferentiableVectorFunction {
    private final List<Double> abscissae = new ArrayList<Double>();
    private final List<double[]> topDiagonal = new ArrayList<double[]>();
    private final List<double[]> bottomDiagonal = new ArrayList<double[]>();

    public void addSamplePoint(double x, double[] ... value) throws MathRuntimeException {
        for (int i = 0; i < value.length; ++i) {
            int j;
            double[] y = (double[])value[i].clone();
            if (i > 1) {
                double inv = 1.0 / (double)CombinatoricsUtils.factorial(i);
                j = 0;
                while (j < y.length) {
                    int n = j++;
                    y[n] = y[n] * inv;
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i, y);
            double[] bottom0 = y;
            for (j = i; j < n; ++j) {
                double[] bottom1 = this.bottomDiagonal.get(n - (j + 1));
                double inv = 1.0 / (x - this.abscissae.get(n - (j + 1)));
                if (Double.isInfinite(inv)) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, x);
                }
                for (int k = 0; k < y.length; ++k) {
                    bottom1[k] = inv * (bottom0[k] - bottom1[k]);
                }
                bottom0 = bottom1;
            }
            this.topDiagonal.add((double[])bottom0.clone());
            this.abscissae.add(x);
        }
    }

    public PolynomialFunction[] getPolynomials() throws MathIllegalArgumentException {
        this.checkInterpolation();
        PolynomialFunction zero = this.polynomial(0.0);
        PolynomialFunction[] polynomials = new PolynomialFunction[this.topDiagonal.get(0).length];
        for (int i = 0; i < polynomials.length; ++i) {
            polynomials[i] = zero;
        }
        PolynomialFunction coeff = this.polynomial(1.0);
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] tdi = this.topDiagonal.get(i);
            for (int k = 0; k < polynomials.length; ++k) {
                polynomials[k] = polynomials[k].add(coeff.multiply(this.polynomial(tdi[k])));
            }
            coeff = coeff.multiply(this.polynomial(-this.abscissae.get(i).doubleValue(), 1.0));
        }
        return polynomials;
    }

    @Override
    public double[] value(double x) throws MathIllegalArgumentException {
        this.checkInterpolation();
        double[] value = new double[this.topDiagonal.get(0).length];
        double valueCoeff = 1.0;
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] dividedDifference = this.topDiagonal.get(i);
            for (int k = 0; k < value.length; ++k) {
                int n = k;
                value[n] = value[n] + dividedDifference[k] * valueCoeff;
            }
            double deltaX = x - this.abscissae.get(i);
            valueCoeff *= deltaX;
        }
        return value;
    }

    @Override
    public <T extends Derivative<T>> T[] value(T x) throws MathIllegalArgumentException {
        this.checkInterpolation();
        Object[] value = (Derivative[])MathArrays.buildArray(x.getField(), (int)this.topDiagonal.get(0).length);
        Arrays.fill(value, x.getField().getZero());
        Derivative valueCoeff = (Derivative)x.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] dividedDifference = this.topDiagonal.get(i);
            for (int k = 0; k < value.length; ++k) {
                value[k] = value[k].add((Derivative)valueCoeff.multiply(dividedDifference[k]));
            }
            Derivative deltaX = (Derivative)x.subtract(this.abscissae.get(i));
            valueCoeff = valueCoeff.multiply(deltaX);
        }
        return value;
    }

    public double[][] derivatives(double x, int order) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(x);
        if (this.abscissae.isEmpty()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_INTERPOLATION_SAMPLE, new Object[0]);
        }
        double[] tj = new double[order + 1];
        tj[0] = 0.0;
        for (int i = 0; i < order; ++i) {
            tj[i + 1] = tj[i] + 1.0;
        }
        double[][] derivatives = new double[order + 1][this.topDiagonal.get(0).length];
        double[] valueCoeff = new double[order + 1];
        valueCoeff[0] = 1.0;
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            double[] dividedDifference = this.topDiagonal.get(i);
            double deltaX = x - this.abscissae.get(i);
            for (int j = order; j >= 0; --j) {
                for (int k = 0; k < derivatives[j].length; ++k) {
                    double[] dArray = derivatives[j];
                    int n = k;
                    dArray[n] = dArray[n] + dividedDifference[k] * valueCoeff[j];
                }
                int n = j;
                valueCoeff[n] = valueCoeff[n] * deltaX;
                if (j <= 0) continue;
                int n2 = j;
                valueCoeff[n2] = valueCoeff[n2] + tj[j] * valueCoeff[j - 1];
            }
        }
        return derivatives;
    }

    private void checkInterpolation() throws MathIllegalArgumentException {
        if (this.abscissae.isEmpty()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EMPTY_INTERPOLATION_SAMPLE, new Object[0]);
        }
    }

    private PolynomialFunction polynomial(double ... c) {
        return new PolynomialFunction(c);
    }
}

