/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.util.concurrent.atomic.AtomicInteger;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldGridAxis<T extends CalculusFieldElement<T>> {
    private final T[] grid;
    private final int n;
    private final AtomicInteger cache;

    public FieldGridAxis(T[] grid, int n) throws MathIllegalArgumentException {
        if (grid.length < n) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INSUFFICIENT_DIMENSION, grid.length, n);
        }
        MathArrays.checkOrder(grid);
        this.grid = (CalculusFieldElement[])grid.clone();
        this.n = n;
        this.cache = new AtomicInteger(0);
    }

    public int size() {
        return this.grid.length;
    }

    public int getN() {
        return this.n;
    }

    public T node(int index) {
        return this.grid[index];
    }

    public int interpolationIndex(T t) {
        int middleOffset;
        int iInf = middleOffset = (this.n - 1) / 2;
        int iSup = this.grid.length - (this.n - 1) + middleOffset;
        int cached = this.cache.get();
        int middle = cached + middleOffset;
        T aMid0 = this.grid[middle];
        T aMid1 = this.grid[middle + 1];
        if (t.getReal() < aMid0.getReal()) {
            if (middle == iInf) {
                return cached;
            }
        } else {
            if (t.getReal() < aMid1.getReal()) {
                return cached;
            }
            if (middle == iSup - 1) {
                return cached;
            }
        }
        T aInf = this.grid[iInf];
        T aSup = this.grid[iSup];
        while (iSup - iInf > 1) {
            int iInterp = (int)(((double)iInf * (aSup.getReal() - t.getReal()) + (double)iSup * (t.getReal() - aInf.getReal())) / (aSup.getReal() - aInf.getReal()));
            int iMed = FastMath.max(iInf + 1, FastMath.min(iInterp, iSup - 1));
            if (t.getReal() < this.grid[iMed].getReal()) {
                iSup = iMed;
                aSup = this.grid[iSup];
                continue;
            }
            iInf = iMed;
            aInf = this.grid[iInf];
        }
        int newCached = iInf - middleOffset;
        this.cache.compareAndSet(cached, newCached);
        return newCached;
    }
}

