/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.BivariateFunction;
import org.hipparchus.analysis.FieldBivariateFunction;
import org.hipparchus.analysis.interpolation.GridAxis;
import org.hipparchus.exception.MathIllegalArgumentException;

public class BilinearInterpolatingFunction
implements BivariateFunction,
FieldBivariateFunction,
Serializable {
    private static final long serialVersionUID = 20180926L;
    private final GridAxis xGrid;
    private final GridAxis yGrid;
    private final int ySize;
    private final double[] fVal;

    public BilinearInterpolatingFunction(double[] xVal, double[] yVal, double[][] fVal) throws MathIllegalArgumentException {
        this.xGrid = new GridAxis(xVal, 2);
        this.yGrid = new GridAxis(yVal, 2);
        this.ySize = yVal.length;
        this.fVal = new double[xVal.length * this.ySize];
        int k = 0;
        for (int i = 0; i < xVal.length; ++i) {
            double[] fi = fVal[i];
            for (int j = 0; j < this.ySize; ++j) {
                this.fVal[k++] = fi[j];
            }
        }
    }

    public double getXInf() {
        return this.xGrid.node(0);
    }

    public double getXSup() {
        return this.xGrid.node(this.xGrid.size() - 1);
    }

    public double getYInf() {
        return this.yGrid.node(0);
    }

    public double getYSup() {
        return this.yGrid.node(this.yGrid.size() - 1);
    }

    @Override
    public double value(double x, double y) {
        int i = this.xGrid.interpolationIndex(x);
        int j = this.yGrid.interpolationIndex(y);
        double x0 = this.xGrid.node(i);
        double x1 = this.xGrid.node(i + 1);
        double y0 = this.yGrid.node(j);
        double y1 = this.yGrid.node(j + 1);
        int k0 = i * this.ySize + j;
        int k1 = k0 + this.ySize;
        double z00 = this.fVal[k0];
        double z01 = this.fVal[k0 + 1];
        double z10 = this.fVal[k1];
        double z11 = this.fVal[k1 + 1];
        double dx0 = x - x0;
        double dx1 = x1 - x;
        double dx10 = x1 - x0;
        double dy0 = y - y0;
        double dy1 = y1 - y;
        double dy10 = y1 - y0;
        return (dx0 * (dy0 * z11 + dy1 * z10) + dx1 * (dy0 * z01 + dy1 * z00)) / (dx10 * dy10);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T value(T x, T y) {
        int i = this.xGrid.interpolationIndex(x.getReal());
        int j = this.yGrid.interpolationIndex(y.getReal());
        double x0 = this.xGrid.node(i);
        double x1 = this.xGrid.node(i + 1);
        double y0 = this.yGrid.node(j);
        double y1 = this.yGrid.node(j + 1);
        int k0 = i * this.ySize + j;
        int k1 = k0 + this.ySize;
        double z00 = this.fVal[k0];
        double z01 = this.fVal[k0 + 1];
        double z10 = this.fVal[k1];
        double z11 = this.fVal[k1 + 1];
        CalculusFieldElement dx0 = (CalculusFieldElement)x.subtract((double)x0);
        CalculusFieldElement mdx1 = (CalculusFieldElement)x.subtract((double)x1);
        double dx10 = x1 - x0;
        CalculusFieldElement dy0 = (CalculusFieldElement)y.subtract((double)y0);
        CalculusFieldElement mdy1 = (CalculusFieldElement)y.subtract((double)y1);
        double dy10 = y1 - y0;
        return (T)((CalculusFieldElement)((CalculusFieldElement)dy0.multiply(z11)).subtract((CalculusFieldElement)mdy1.multiply(z10)).multiply(dx0).subtract(((CalculusFieldElement)dy0.multiply(z01)).subtract((CalculusFieldElement)mdy1.multiply(z00)).multiply(mdx1)).divide(dx10 * dy10));
    }
}

