/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.gauss.FieldAbstractRuleFactory;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;

public class FieldHermiteRuleFactory<T extends CalculusFieldElement<T>>
extends FieldAbstractRuleFactory<T> {
    public FieldHermiteRuleFactory(Field<T> field) {
        super(field);
    }

    @Override
    protected Pair<T[], T[]> computeRule(int numberOfPoints) throws MathIllegalArgumentException {
        Field field = this.getField();
        CalculusFieldElement sqrtPi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).getPi()).sqrt();
        if (numberOfPoints == 1) {
            CalculusFieldElement[] points = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
            CalculusFieldElement[] weights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
            points[0] = (CalculusFieldElement)field.getZero();
            weights[0] = sqrtPi;
            return new Pair<CalculusFieldElement[], CalculusFieldElement[]>(points, weights);
        }
        CalculusFieldElement[] points = this.findRoots(numberOfPoints, new Hermite(field, numberOfPoints)::ratio);
        this.enforceSymmetry(points);
        CalculusFieldElement[] weights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
        Hermite hm1 = new Hermite(field, numberOfPoints - 1);
        for (int i = 0; i < numberOfPoints; ++i) {
            CalculusFieldElement y = hm1.hNhNm1(points[i])[0];
            weights[i] = sqrtPi.divide((CalculusFieldElement)((CalculusFieldElement)y.square()).multiply(numberOfPoints));
        }
        return new Pair<CalculusFieldElement[], CalculusFieldElement[]>(points, weights);
    }

    private static class Hermite<T extends CalculusFieldElement<T>> {
        private final T sqrt2;
        private final int degree;

        Hermite(Field<T> field, int degree) {
            this.sqrt2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(2.0)).sqrt();
            this.degree = degree;
        }

        public T ratio(T x) {
            CalculusFieldElement[] h = this.hNhNm1((CalculusFieldElement)x);
            return (T)h[0].divide((CalculusFieldElement)h[1].multiply(2 * this.degree));
        }

        private T[] hNhNm1(T x) {
            CalculusFieldElement[] h = (CalculusFieldElement[])MathArrays.buildArray(x.getField(), (int)2);
            h[0] = (CalculusFieldElement)this.sqrt2.multiply(x);
            h[1] = (CalculusFieldElement)x.getField().getOne();
            CalculusFieldElement sqrtN = (CalculusFieldElement)x.getField().getOne();
            for (int n = 1; n < this.degree; ++n) {
                CalculusFieldElement sqrtNp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.getField().getZero()).newInstance(n + 1)).sqrt();
                CalculusFieldElement hp = ((CalculusFieldElement)((CalculusFieldElement)h[0].multiply(x)).multiply(this.sqrt2)).subtract(h[1].multiply(sqrtN)).divide(sqrtNp);
                h[1] = h[0];
                h[0] = hp;
                sqrtN = sqrtNp;
            }
            return h;
        }
    }
}

