/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.BaseAbstractFieldUnivariateIntegrator;
import org.hipparchus.analysis.integration.FieldTrapezoidIntegrator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class FieldSimpsonIntegrator<T extends CalculusFieldElement<T>>
extends BaseAbstractFieldUnivariateIntegrator<T> {
    public static final int SIMPSON_MAX_ITERATIONS_COUNT = 64;

    public FieldSimpsonIntegrator(Field<T> field, double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public FieldSimpsonIntegrator(Field<T> field, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(field, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 64) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 64);
        }
    }

    public FieldSimpsonIntegrator(Field<T> field) {
        super(field, 3, 64);
    }

    @Override
    protected T doIntegrate() throws MathIllegalStateException {
        FieldTrapezoidIntegrator qtrap = new FieldTrapezoidIntegrator(this.getField());
        if (this.getMinimalIterationCount() == 1) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)qtrap.stage(this, 1).multiply(4)).subtract(qtrap.stage(this, 0))).divide(3.0));
        }
        CalculusFieldElement olds = (CalculusFieldElement)this.getField().getZero();
        Object oldt = qtrap.stage(this, 0);
        while (true) {
            double rLimit;
            double delta;
            Object t = qtrap.stage(this, this.iterations.getCount());
            this.iterations.increment();
            CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply(4)).subtract(oldt)).divide(3.0);
            if (this.iterations.getCount() >= this.getMinimalIterationCount() && ((delta = FastMath.abs(s.subtract(olds)).getReal()) <= (rLimit = ((CalculusFieldElement)FastMath.abs(olds).add(FastMath.abs(s)).multiply(0.5 * this.getRelativeAccuracy())).getReal()) || delta <= this.getAbsoluteAccuracy())) {
                return (T)s;
            }
            olds = s;
            oldt = t;
        }
    }
}

