/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.lang.reflect.Array;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.DSCompiler;
import org.hipparchus.analysis.differentiation.DifferentialAlgebra;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldMatrixDecomposer;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldTaylorMap<T extends CalculusFieldElement<T>>
implements DifferentialAlgebra {
    private final T[] point;
    private final FieldDerivativeStructure<T>[] functions;

    public FieldTaylorMap(T[] point, FieldDerivativeStructure<T>[] functions) {
        if (point == null || point.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, point == null ? 0 : point.length);
        }
        if (functions == null || functions.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, functions == null ? 0 : functions.length);
        }
        this.point = (CalculusFieldElement[])point.clone();
        this.functions = (FieldDerivativeStructure[])functions.clone();
        FDSFactory<T> factory0 = functions[0].getFactory();
        MathUtils.checkDimension(point.length, factory0.getCompiler().getFreeParameters());
        for (int i = 1; i < functions.length; ++i) {
            factory0.checkCompatibility(functions[i].getFactory());
        }
    }

    public FieldTaylorMap(Field<T> valueField, int parameters, int order, int nbFunctions) {
        this(valueField, parameters, nbFunctions);
        FDSFactory<T> factory = new FDSFactory<T>(valueField, parameters, order);
        for (int i = 0; i < nbFunctions; ++i) {
            this.functions[i] = factory.variable(i, 0.0);
        }
    }

    private FieldTaylorMap(Field<T> valueField, int parameters, int nbFunctions) {
        this.point = (CalculusFieldElement[])MathArrays.buildArray(valueField, (int)parameters);
        this.functions = (FieldDerivativeStructure[])Array.newInstance(FieldDerivativeStructure.class, nbFunctions);
    }

    @Override
    public int getFreeParameters() {
        return this.point.length;
    }

    @Override
    public int getOrder() {
        return this.functions[0].getOrder();
    }

    public int getNbFunctions() {
        return this.functions.length;
    }

    public T[] getPoint() {
        return (CalculusFieldElement[])this.point.clone();
    }

    public FieldDerivativeStructure<T> getFunction(int i) {
        return this.functions[i];
    }

    private FieldTaylorMap<T> subtract(FieldTaylorMap<T> map) {
        FieldTaylorMap<T> result = new FieldTaylorMap<T>(this.functions[0].getFactory().getValueField(), this.point.length, this.functions.length);
        for (int i = 0; i < result.functions.length; ++i) {
            result.functions[i] = this.functions[i].subtract(map.functions[i]);
        }
        return result;
    }

    public T[] value(double ... deltaP) {
        CalculusFieldElement[] value = (CalculusFieldElement[])MathArrays.buildArray(this.functions[0].getFactory().getValueField(), (int)this.functions.length);
        for (int i = 0; i < this.functions.length; ++i) {
            value[i] = this.functions[i].taylor(deltaP);
        }
        return value;
    }

    public T[] value(T ... deltaP) {
        CalculusFieldElement[] value = (CalculusFieldElement[])MathArrays.buildArray(this.functions[0].getFactory().getValueField(), (int)this.functions.length);
        for (int i = 0; i < this.functions.length; ++i) {
            value[i] = this.functions[i].taylor((CalculusFieldElement[])deltaP);
        }
        return value;
    }

    public FieldTaylorMap<T> compose(FieldTaylorMap<T> other) {
        MathUtils.checkDimension(this.getFreeParameters(), other.getNbFunctions());
        FieldDerivativeStructure[] composed = (FieldDerivativeStructure[])Array.newInstance(FieldDerivativeStructure.class, this.functions.length);
        for (int i = 0; i < this.functions.length; ++i) {
            composed[i] = this.functions[i].rebase(other.functions);
        }
        return new FieldTaylorMap(other.point, composed);
    }

    public FieldTaylorMap<T> invert(FieldMatrixDecomposer<T> decomposer) {
        FDSFactory<T> factory = this.functions[0].getFactory();
        Field<T> field = factory.getValueField();
        DSCompiler compiler = factory.getCompiler();
        int n = this.functions.length;
        MathUtils.checkDimension(n, this.functions[0].getFreeParameters());
        int[] indirection = new int[n];
        int linearIndex = 0;
        int k = 1;
        while (linearIndex < n) {
            if (compiler.getPartialDerivativeOrdersSum(k) == 1) {
                indirection[linearIndex++] = k;
            }
            ++k;
        }
        FieldMatrix<T> linear = MatrixUtils.createFieldMatrix(field, n, n);
        FieldTaylorMap<T> nonLinearTM = new FieldTaylorMap<T>(field, n, n);
        for (int i = 0; i < n; ++i) {
            nonLinearTM.functions[i] = factory.build(this.functions[i].getAllDerivatives());
            nonLinearTM.functions[i].setDerivativeComponent(0, (CalculusFieldElement)field.getZero());
            for (int j = 0; j < n; ++j) {
                int k2 = indirection[j];
                linear.setEntry(i, j, this.functions[i].getDerivativeComponent(k2));
                nonLinearTM.functions[i].setDerivativeComponent(k2, (CalculusFieldElement)field.getZero());
            }
        }
        FieldMatrix<T> linearInvert = decomposer.decompose(linear).getInverse();
        FieldTaylorMap<T> linearInvertTM = new FieldTaylorMap<T>(field, n, n);
        for (int i = 0; i < n; ++i) {
            linearInvertTM.functions[i] = new FieldDerivativeStructure<T>(factory);
            for (int j = 0; j < n; ++j) {
                linearInvertTM.functions[i].setDerivativeComponent(indirection[j], (CalculusFieldElement)linearInvert.getEntry(i, j));
            }
        }
        FieldTaylorMap<T> identity = new FieldTaylorMap<T>(field, n, compiler.getOrder(), n);
        FieldTaylorMap<T> invertTM = linearInvertTM;
        for (int k3 = 1; k3 < compiler.getOrder(); ++k3) {
            invertTM = linearInvertTM.compose(super.subtract(nonLinearTM.compose(invertTM)));
        }
        for (int i = 0; i < n; ++i) {
            invertTM.point[i] = this.functions[i].getValue();
            invertTM.functions[i].setDerivativeComponent(0, this.point[i]);
        }
        return invertTM;
    }
}

