/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.DifferentialAlgebra;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;

public interface Derivative<T extends CalculusFieldElement<T>>
extends CalculusFieldElement<T>,
DifferentialAlgebra {
    @Override
    default public double getReal() {
        return this.getValue();
    }

    public double getValue();

    default public T withValue(double value) {
        return (T)this.add((CalculusFieldElement)this.newInstance(value - this.getValue()));
    }

    public double getPartialDerivative(int ... var1) throws MathIllegalArgumentException;

    @Override
    default public T add(double a) {
        return this.withValue(this.getValue() + a);
    }

    @Override
    default public T subtract(double a) {
        return this.withValue(this.getValue() - a);
    }

    public T compose(double ... var1) throws MathIllegalArgumentException;

    @Override
    default public T log10() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.log()).divide(FastMath.log(10.0)));
    }

    @Override
    default public T pow(T e) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.log()).multiply(e)).exp());
    }

    @Override
    default public T cosh() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.exp()).add((CalculusFieldElement)((CalculusFieldElement)this.negate()).exp()).divide(2.0));
    }

    @Override
    default public T sinh() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.exp()).subtract((CalculusFieldElement)((CalculusFieldElement)this.negate()).exp()).divide(2.0));
    }

    @Override
    default public T acos() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.asin()).negate()).add((CalculusFieldElement)((CalculusFieldElement)this.getPi()).divide(2.0));
    }

    @Override
    default public int getExponent() {
        return FastMath.getExponent(this.getValue());
    }

    @Override
    default public T remainder(double a) {
        return this.withValue(FastMath.IEEEremainder(this.getValue(), a));
    }
}

