package org.hibernate.validator.internal.util.logging;

import java.util.Locale;
import javax.validation.ElementKind;
import java.io.Serializable;
import org.hibernate.validator.spi.scripting.ScriptEvaluationException;
import java.lang.String;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.xml.mapping.ContainerElementTypePath;
import java.lang.reflect.TypeVariable;
import java.lang.AssertionError;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorNotFoundException;
import java.util.List;
import java.lang.invoke.MethodHandles.Lookup;
import org.hibernate.validator.messageinterpolation.ExpressionLanguageFeatureLevel;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.IllegalArgumentException;
import java.lang.annotation.ElementType;
import javax.validation.GroupDefinitionException;
import javax.validation.valueextraction.ValueExtractorDeclarationException;
import javax.validation.valueextraction.ValueExtractorDefinitionException;
import java.lang.NumberFormatException;
import java.time.Duration;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.properties.Constrainable;
import org.hibernate.validator.internal.properties.javabean.JavaBeanMethod;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import javax.validation.UnexpectedTypeException;
import java.lang.IllegalStateException;
import javax.validation.ConstraintTarget;
import javax.validation.ValidationException;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement.ConstrainedElementKind;
import java.util.ServiceConfigurationError;
import org.jboss.logging.Logger;
import org.hibernate.validator.internal.properties.Callable;
import java.lang.NoSuchMethodException;
import java.lang.RuntimeException;
import javax.validation.ConstraintDeclarationException;
import org.jboss.logging.BasicLogger;
import java.lang.ClassLoader;
import java.util.regex.PatternSyntaxException;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.messageinterpolation.parser.MessageDescriptorFormatException;
import org.hibernate.validator.internal.properties.javabean.JavaBeanConstructor;
import java.lang.Exception;
import javax.validation.ConstraintDefinitionException;
import java.lang.reflect.Type;
import javax.xml.stream.XMLStreamException;
import java.lang.ClassCastException;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl.ConstraintType;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    protected String version$str() {
        return "HV000001: Hibernate Validator %s";
    }
    @Override
    public final void ignoringXmlConfiguration() {
        super.log.logf(FQCN, DEBUG, null, ignoringXmlConfiguration$str());
    }
    protected String ignoringXmlConfiguration$str() {
        return "HV000002: Ignoring XML configuration.";
    }
    @Override
    public final void usingConstraintValidatorFactory(final Class<? extends javax.validation.ConstraintValidatorFactory> constraintValidatorFactoryClass) {
        super.log.logf(FQCN, DEBUG, null, usingConstraintValidatorFactory$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraintValidatorFactoryClass));
    }
    protected String usingConstraintValidatorFactory$str() {
        return "HV000003: Using %s as constraint validator factory.";
    }
    @Override
    public final void usingMessageInterpolator(final Class<? extends javax.validation.MessageInterpolator> messageInterpolatorClass) {
        super.log.logf(FQCN, DEBUG, null, usingMessageInterpolator$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(messageInterpolatorClass));
    }
    protected String usingMessageInterpolator$str() {
        return "HV000004: Using %s as message interpolator.";
    }
    @Override
    public final void usingTraversableResolver(final Class<? extends javax.validation.TraversableResolver> traversableResolverClass) {
        super.log.logf(FQCN, DEBUG, null, usingTraversableResolver$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(traversableResolverClass));
    }
    protected String usingTraversableResolver$str() {
        return "HV000005: Using %s as traversable resolver.";
    }
    @Override
    public final void usingValidationProvider(final Class<? extends javax.validation.spi.ValidationProvider<?>> validationProviderClass) {
        super.log.logf(FQCN, DEBUG, null, usingValidationProvider$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validationProviderClass));
    }
    protected String usingValidationProvider$str() {
        return "HV000006: Using %s as validation provider.";
    }
    @Override
    public final void parsingXMLFile(final String fileName) {
        super.log.logf(FQCN, DEBUG, null, parsingXMLFile$str(), fileName);
    }
    protected String parsingXMLFile$str() {
        return "HV000007: %s found. Parsing XML based configuration.";
    }
    @Override
    public final void unableToCloseInputStream() {
        super.log.logf(FQCN, WARN, null, unableToCloseInputStream$str());
    }
    protected String unableToCloseInputStream$str() {
        return "HV000008: Unable to close input stream.";
    }
    @Override
    public final void unableToCloseXMLFileInputStream(final String fileName) {
        super.log.logf(FQCN, WARN, null, unableToCloseXMLFileInputStream$str(), fileName);
    }
    protected String unableToCloseXMLFileInputStream$str() {
        return "HV000010: Unable to close input stream for %s.";
    }
    @Override
    public final void unableToCreateSchema(final String fileName, final String message) {
        super.log.logf(FQCN, WARN, null, unableToCreateSchema$str(), fileName, message);
    }
    protected String unableToCreateSchema$str() {
        return "HV000011: Unable to create schema for %1$s: %2$s";
    }
    protected String getUnableToCreateAnnotationForConfiguredConstraintException$str() {
        return "HV000012: Unable to create annotation for configured constraint";
    }
    @Override
    public final ValidationException getUnableToCreateAnnotationForConfiguredConstraintException(final RuntimeException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToCreateAnnotationForConfiguredConstraintException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String getUnableToFindPropertyWithAccessException$str() {
        return "HV000013: The class %1$s does not have a property '%2$s' with access %3$s.";
    }
    @Override
    public final ValidationException getUnableToFindPropertyWithAccessException(final Class<?> beanClass, final String property, final ElementType elementType) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToFindPropertyWithAccessException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), property, elementType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidBigDecimalFormatException$str() {
        return "HV000016: %s does not represent a valid BigDecimal format.";
    }
    @Override
    public final IllegalArgumentException getInvalidBigDecimalFormatException(final String value, final NumberFormatException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidBigDecimalFormatException$str(), value), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidLengthForIntegerPartException$str() {
        return "HV000017: The length of the integer part cannot be negative.";
    }
    @Override
    public final IllegalArgumentException getInvalidLengthForIntegerPartException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidLengthForIntegerPartException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidLengthForFractionPartException$str() {
        return "HV000018: The length of the fraction part cannot be negative.";
    }
    @Override
    public final IllegalArgumentException getInvalidLengthForFractionPartException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidLengthForFractionPartException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMinCannotBeNegativeException$str() {
        return "HV000019: The min parameter cannot be negative.";
    }
    @Override
    public final IllegalArgumentException getMinCannotBeNegativeException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMinCannotBeNegativeException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMaxCannotBeNegativeException$str() {
        return "HV000020: The max parameter cannot be negative.";
    }
    @Override
    public final IllegalArgumentException getMaxCannotBeNegativeException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMaxCannotBeNegativeException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getLengthCannotBeNegativeException$str() {
        return "HV000021: The length cannot be negative.";
    }
    @Override
    public final IllegalArgumentException getLengthCannotBeNegativeException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getLengthCannotBeNegativeException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidRegularExpressionException$str() {
        return "HV000022: Invalid regular expression.";
    }
    @Override
    public final IllegalArgumentException getInvalidRegularExpressionException(final PatternSyntaxException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidRegularExpressionException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getErrorDuringScriptExecutionException$str() {
        return "HV000023: Error during execution of script \"%s\" occurred.";
    }
    @Override
    public final ConstraintDeclarationException getErrorDuringScriptExecutionException(final String script, final Exception e) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getErrorDuringScriptExecutionException$str(), script), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getScriptMustReturnTrueOrFalseException1$str() {
        return "HV000024: Script \"%s\" returned null, but must return either true or false.";
    }
    @Override
    public final ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(final String script) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getScriptMustReturnTrueOrFalseException1$str(), script));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getScriptMustReturnTrueOrFalseException3$str() {
        return "HV000025: Script \"%1$s\" returned %2$s (of type %3$s), but must return either true or false.";
    }
    @Override
    public final ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(final String script, final Object executionResult, final String type) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getScriptMustReturnTrueOrFalseException3$str(), script, executionResult, type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInconsistentConfigurationException$str() {
        return "HV000026: Assertion error: inconsistent ConfigurationImpl construction.";
    }
    @Override
    public final ValidationException getInconsistentConfigurationException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInconsistentConfigurationException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToFindProviderException$str() {
        return "HV000027: Unable to find provider: %s.";
    }
    @Override
    public final ValidationException getUnableToFindProviderException(final Class<?> providerClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToFindProviderException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(providerClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getExceptionDuringIsValidCallException$str() {
        return "HV000028: Unexpected exception during isValid call.";
    }
    @Override
    public final ValidationException getExceptionDuringIsValidCallException(final RuntimeException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getExceptionDuringIsValidCallException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConstraintValidatorFactoryMustNotReturnNullException$str() {
        return "HV000029: Constraint factory returned null when trying to create instance of %s.";
    }
    @Override
    public final ValidationException getConstraintValidatorFactoryMustNotReturnNullException(final Class<? extends javax.validation.ConstraintValidator<?, ?>> validatorClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getConstraintValidatorFactoryMustNotReturnNullException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatorClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoValidatorFoundForTypeException$str() {
        return "HV000030: No validator could be found for constraint '%s' validating type '%s'. Check configuration for '%s'";
    }
    @Override
    public final UnexpectedTypeException getNoValidatorFoundForTypeException(final Class<? extends java.lang.annotation.Annotation> constraintType, final String validatedValueType, final String path) {
        final UnexpectedTypeException result = new UnexpectedTypeException(String.format(getLoggingLocale(), getNoValidatorFoundForTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraintType), validatedValueType, path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMoreThanOneValidatorFoundForTypeException$str() {
        return "HV000031: There are multiple validator classes which could validate the type %1$s. The validator classes are: %2$s.";
    }
    @Override
    public final UnexpectedTypeException getMoreThanOneValidatorFoundForTypeException(final Type type, final Collection<Type> validatorClasses) {
        final UnexpectedTypeException result = new UnexpectedTypeException(String.format(getLoggingLocale(), getMoreThanOneValidatorFoundForTypeException$str(), type, new org.hibernate.validator.internal.util.logging.formatter.CollectionOfObjectsToStringFormatter(validatorClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInitializeConstraintValidatorException$str() {
        return "HV000032: Unable to initialize %s.";
    }
    @Override
    public final ValidationException getUnableToInitializeConstraintValidatorException(final Class<? extends javax.validation.ConstraintValidator> validatorClass, final RuntimeException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInitializeConstraintValidatorException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatorClass)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getAtLeastOneCustomMessageMustBeCreatedException$str() {
        return "HV000033: At least one custom message must be created if the default error message gets disabled.";
    }
    @Override
    public final ValidationException getAtLeastOneCustomMessageMustBeCreatedException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getAtLeastOneCustomMessageMustBeCreatedException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidJavaIdentifierException$str() {
        return "HV000034: %s is not a valid Java Identifier.";
    }
    @Override
    public final IllegalArgumentException getInvalidJavaIdentifierException(final String identifier) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidJavaIdentifierException$str(), identifier));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToParsePropertyPathException$str() {
        return "HV000035: Unable to parse property path %s.";
    }
    @Override
    public final IllegalArgumentException getUnableToParsePropertyPathException(final String propertyPath) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getUnableToParsePropertyPathException$str(), propertyPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getTypeNotSupportedForUnwrappingException$str() {
        return "HV000036: Type %s not supported for unwrapping.";
    }
    @Override
    public final ValidationException getTypeNotSupportedForUnwrappingException(final Class<?> type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getTypeNotSupportedForUnwrappingException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInconsistentFailFastConfigurationException$str() {
        return "HV000037: Inconsistent fail fast configuration. Fail fast enabled via programmatic API, but explicitly disabled via properties.";
    }
    @Override
    public final ValidationException getInconsistentFailFastConfigurationException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInconsistentFailFastConfigurationException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidPropertyPathException0$str() {
        return "HV000038: Invalid property path.";
    }
    @Override
    public final IllegalArgumentException getInvalidPropertyPathException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidPropertyPathException0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidPropertyPathException2$str() {
        return "HV000039: Invalid property path. Either there is no property %2$s in entity %1$s or it is not possible to cascade to the property.";
    }
    @Override
    public final IllegalArgumentException getInvalidPropertyPathException(final Class<?> beanClass, final String propertyName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidPropertyPathException2$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getPropertyPathMustProvideIndexOrMapKeyException$str() {
        return "HV000040: Property path must provide index or map key.";
    }
    @Override
    public final IllegalArgumentException getPropertyPathMustProvideIndexOrMapKeyException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getPropertyPathMustProvideIndexOrMapKeyException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getErrorDuringCallOfTraversableResolverIsReachableException$str() {
        return "HV000041: Call to TraversableResolver.isReachable() threw an exception.";
    }
    @Override
    public final ValidationException getErrorDuringCallOfTraversableResolverIsReachableException(final RuntimeException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getErrorDuringCallOfTraversableResolverIsReachableException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getErrorDuringCallOfTraversableResolverIsCascadableException$str() {
        return "HV000042: Call to TraversableResolver.isCascadable() threw an exception.";
    }
    @Override
    public final ValidationException getErrorDuringCallOfTraversableResolverIsCascadableException(final RuntimeException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getErrorDuringCallOfTraversableResolverIsCascadableException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToExpandDefaultGroupListException$str() {
        return "HV000043: Unable to expand default group list %1$s into sequence %2$s.";
    }
    @Override
    public final GroupDefinitionException getUnableToExpandDefaultGroupListException(final List<?> defaultGroupList, final List<?> groupList) {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getUnableToExpandDefaultGroupListException$str(), new org.hibernate.validator.internal.util.logging.formatter.CollectionOfObjectsToStringFormatter(defaultGroupList), new org.hibernate.validator.internal.util.logging.formatter.CollectionOfObjectsToStringFormatter(groupList)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getAtLeastOneGroupHasToBeSpecifiedException$str() {
        return "HV000044: At least one group has to be specified.";
    }
    @Override
    public final IllegalArgumentException getAtLeastOneGroupHasToBeSpecifiedException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getAtLeastOneGroupHasToBeSpecifiedException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getGroupHasToBeAnInterfaceException$str() {
        return "HV000045: A group has to be an interface. %s is not.";
    }
    @Override
    public final ValidationException getGroupHasToBeAnInterfaceException(final Class<?> clazz) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getGroupHasToBeAnInterfaceException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getSequenceDefinitionsNotAllowedException$str() {
        return "HV000046: Sequence definitions are not allowed as composing parts of a sequence.";
    }
    @Override
    public final GroupDefinitionException getSequenceDefinitionsNotAllowedException() {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getSequenceDefinitionsNotAllowedException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCyclicDependencyInGroupsDefinitionException$str() {
        return "HV000047: Cyclic dependency in groups definition";
    }
    @Override
    public final GroupDefinitionException getCyclicDependencyInGroupsDefinitionException() {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getCyclicDependencyInGroupsDefinitionException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToExpandGroupSequenceException$str() {
        return "HV000048: Unable to expand group sequence.";
    }
    @Override
    public final GroupDefinitionException getUnableToExpandGroupSequenceException() {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getUnableToExpandGroupSequenceException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidDefaultGroupSequenceDefinitionException$str() {
        return "HV000052: Default group sequence and default group sequence provider cannot be defined at the same time.";
    }
    @Override
    public final GroupDefinitionException getInvalidDefaultGroupSequenceDefinitionException() {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getInvalidDefaultGroupSequenceDefinitionException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoDefaultGroupInGroupSequenceException$str() {
        return "HV000053: 'Default.class' cannot appear in default group sequence list.";
    }
    @Override
    public final GroupDefinitionException getNoDefaultGroupInGroupSequenceException() {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getNoDefaultGroupInGroupSequenceException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException$str() {
        return "HV000054: %s must be part of the redefined default group sequence.";
    }
    @Override
    public final GroupDefinitionException getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(final Class<?> beanClass) {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongDefaultGroupSequenceProviderTypeException$str() {
        return "HV000055: The default group sequence provider defined for %s has the wrong type";
    }
    @Override
    public final GroupDefinitionException getWrongDefaultGroupSequenceProviderTypeException(final Class<?> beanClass) {
        final GroupDefinitionException result = new GroupDefinitionException(String.format(getLoggingLocale(), getWrongDefaultGroupSequenceProviderTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidExecutableParameterIndexException$str() {
        return "HV000056: Method or constructor %1$s doesn't have a parameter with index %2$d.";
    }
    @Override
    public final IllegalArgumentException getInvalidExecutableParameterIndexException(final Callable callable, final int index) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidExecutableParameterIndexException$str(), callable, index));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToRetrieveAnnotationParameterValueException$str() {
        return "HV000059: Unable to retrieve annotation parameter value.";
    }
    @Override
    public final ValidationException getUnableToRetrieveAnnotationParameterValueException(final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToRetrieveAnnotationParameterValueException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidLengthOfParameterMetaDataListException$str() {
        return "HV000062: Method or constructor %1$s has %2$s parameters, but the passed list of parameter meta data has a size of %3$s.";
    }
    @Override
    public final IllegalArgumentException getInvalidLengthOfParameterMetaDataListException(final Callable callable, final int nbParameters, final int listSize) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidLengthOfParameterMetaDataListException$str(), callable, nbParameters, listSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateException1$str() {
        return "HV000063: Unable to instantiate %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateException(final Class<?> clazz, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateException1$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateException2$str() {
        return "HV000064: Unable to instantiate %1$s: %2$s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateException(final String message, final Class<?> clazz, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateException2$str(), message, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToLoadClassException$str() {
        return "HV000065: Unable to load class: %s from %s.";
    }
    @Override
    public final ValidationException getUnableToLoadClassException(final String className, final ClassLoader loader, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToLoadClassException$str(), className, loader), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getStartIndexCannotBeNegativeException$str() {
        return "HV000068: Start index cannot be negative: %d.";
    }
    @Override
    public final IllegalArgumentException getStartIndexCannotBeNegativeException(final int startIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getStartIndexCannotBeNegativeException$str(), startIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getEndIndexCannotBeNegativeException$str() {
        return "HV000069: End index cannot be negative: %d.";
    }
    @Override
    public final IllegalArgumentException getEndIndexCannotBeNegativeException(final int endIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getEndIndexCannotBeNegativeException$str(), endIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidRangeException$str() {
        return "HV000070: Invalid Range: %1$d > %2$d.";
    }
    @Override
    public final IllegalArgumentException getInvalidRangeException(final int startIndex, final int endIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidRangeException$str(), startIndex, endIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidCheckDigitException$str() {
        return "HV000071: A explicitly specified check digit must lie outside the interval: [%1$d, %2$d].";
    }
    @Override
    public final IllegalArgumentException getInvalidCheckDigitException(final int startIndex, final int endIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidCheckDigitException$str(), startIndex, endIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCharacterIsNotADigitException$str() {
        return "HV000072: '%c' is not a digit.";
    }
    @Override
    public final NumberFormatException getCharacterIsNotADigitException(final char c) {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), getCharacterIsNotADigitException$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConstraintParametersCannotStartWithValidException$str() {
        return "HV000073: Parameters starting with 'valid' are not allowed in a constraint.";
    }
    @Override
    public final ConstraintDefinitionException getConstraintParametersCannotStartWithValidException() {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getConstraintParametersCannotStartWithValidException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConstraintWithoutMandatoryParameterException$str() {
        return "HV000074: %2$s contains Constraint annotation, but does not contain a %1$s parameter.";
    }
    @Override
    public final ConstraintDefinitionException getConstraintWithoutMandatoryParameterException(final String parameterName, final String constraintName) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getConstraintWithoutMandatoryParameterException$str(), parameterName, constraintName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongDefaultValueForPayloadParameterException$str() {
        return "HV000075: %s contains Constraint annotation, but the payload parameter default value is not the empty array.";
    }
    @Override
    public final ConstraintDefinitionException getWrongDefaultValueForPayloadParameterException(final String constraintName) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getWrongDefaultValueForPayloadParameterException$str(), constraintName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongTypeForPayloadParameterException$str() {
        return "HV000076: %s contains Constraint annotation, but the payload parameter is of wrong type.";
    }
    @Override
    public final ConstraintDefinitionException getWrongTypeForPayloadParameterException(final String constraintName, final ClassCastException e) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getWrongTypeForPayloadParameterException$str(), constraintName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongDefaultValueForGroupsParameterException$str() {
        return "HV000077: %s contains Constraint annotation, but the groups parameter default value is not the empty array.";
    }
    @Override
    public final ConstraintDefinitionException getWrongDefaultValueForGroupsParameterException(final String constraintName) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getWrongDefaultValueForGroupsParameterException$str(), constraintName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongTypeForGroupsParameterException$str() {
        return "HV000078: %s contains Constraint annotation, but the groups parameter is of wrong type.";
    }
    @Override
    public final ConstraintDefinitionException getWrongTypeForGroupsParameterException(final String constraintName, final ClassCastException e) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getWrongTypeForGroupsParameterException$str(), constraintName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongTypeForMessageParameterException$str() {
        return "HV000079: %s contains Constraint annotation, but the message parameter is not of type java.lang.String.";
    }
    @Override
    public final ConstraintDefinitionException getWrongTypeForMessageParameterException(final String constraintName) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getWrongTypeForMessageParameterException$str(), constraintName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getOverriddenConstraintAttributeNotFoundException$str() {
        return "HV000080: Overridden constraint does not define an attribute with name %s.";
    }
    @Override
    public final ConstraintDefinitionException getOverriddenConstraintAttributeNotFoundException(final String attributeName) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getOverriddenConstraintAttributeNotFoundException$str(), attributeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongAttributeTypeForOverriddenConstraintException$str() {
        return "HV000081: The overriding type of a composite constraint must be identical to the overridden one. Expected %1$s found %2$s.";
    }
    @Override
    public final ConstraintDefinitionException getWrongAttributeTypeForOverriddenConstraintException(final Class<?> expectedReturnType, final Class<?> currentReturnType) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getWrongAttributeTypeForOverriddenConstraintException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(expectedReturnType), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(currentReturnType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongAnnotationAttributeTypeException$str() {
        return "HV000082: Wrong type for attribute '%2$s' of annotation %1$s. Expected: %3$s. Actual: %4$s.";
    }
    @Override
    public final ValidationException getWrongAnnotationAttributeTypeException(final Class<? extends java.lang.annotation.Annotation> annotationClass, final String attributeName, final Class<?> expectedType, final Class<?> currentType) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getWrongAnnotationAttributeTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationClass), attributeName, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(expectedType), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(currentType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToFindAnnotationAttributeException$str() {
        return "HV000083: The specified annotation %1$s defines no attribute '%2$s'.";
    }
    @Override
    public final ValidationException getUnableToFindAnnotationAttributeException(final Class<? extends java.lang.annotation.Annotation> annotationClass, final String parameterName, final NoSuchMethodException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToFindAnnotationAttributeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationClass), parameterName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToGetAnnotationAttributeException$str() {
        return "HV000084: Unable to get attribute '%2$s' from annotation %1$s.";
    }
    @Override
    public final ValidationException getUnableToGetAnnotationAttributeException(final Class<? extends java.lang.annotation.Annotation> annotationClass, final String parameterName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToGetAnnotationAttributeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationClass), parameterName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoValueProvidedForAnnotationAttributeException$str() {
        return "HV000085: No value provided for attribute '%1$s' of annotation @%2$s.";
    }
    @Override
    public final IllegalArgumentException getNoValueProvidedForAnnotationAttributeException(final String parameterName, final Class<? extends java.lang.annotation.Annotation> annotation) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getNoValueProvidedForAnnotationAttributeException$str(), parameterName, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotation)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getTryingToInstantiateAnnotationWithUnknownAttributesException$str() {
        return "HV000086: Trying to instantiate annotation %1$s with unknown attribute(s): %2$s.";
    }
    @Override
    public final RuntimeException getTryingToInstantiateAnnotationWithUnknownAttributesException(final Class<? extends java.lang.annotation.Annotation> annotationType, final Set<String> unknownParameters) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), getTryingToInstantiateAnnotationWithUnknownAttributesException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationType), unknownParameters));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getPropertyNameCannotBeNullOrEmptyException$str() {
        return "HV000087: Property name cannot be null or empty.";
    }
    @Override
    public final IllegalArgumentException getPropertyNameCannotBeNullOrEmptyException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getPropertyNameCannotBeNullOrEmptyException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getElementTypeHasToBeFieldOrMethodException$str() {
        return "HV000088: Element type has to be FIELD or METHOD.";
    }
    @Override
    public final IllegalArgumentException getElementTypeHasToBeFieldOrMethodException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getElementTypeHasToBeFieldOrMethodException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMemberIsNeitherAFieldNorAMethodException$str() {
        return "HV000089: Member %s is neither a field nor a method.";
    }
    @Override
    public final IllegalArgumentException getMemberIsNeitherAFieldNorAMethodException(final Member member) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMemberIsNeitherAFieldNorAMethodException$str(), member));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToAccessMemberException$str() {
        return "HV000090: Unable to access %s.";
    }
    @Override
    public final ValidationException getUnableToAccessMemberException(final String memberName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToAccessMemberException$str(), memberName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getHasToBeAPrimitiveTypeException$str() {
        return "HV000091: %s has to be a primitive type.";
    }
    @Override
    public final IllegalArgumentException getHasToBeAPrimitiveTypeException(final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getHasToBeAPrimitiveTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNullIsAnInvalidTypeForAConstraintValidatorException$str() {
        return "HV000093: null is an invalid type for a constraint validator.";
    }
    @Override
    public final ValidationException getNullIsAnInvalidTypeForAConstraintValidatorException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getNullIsAnInvalidTypeForAConstraintValidatorException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMissingActualTypeArgumentForTypeParameterException$str() {
        return "HV000094: Missing actual type argument for type parameter: %s.";
    }
    @Override
    public final IllegalArgumentException getMissingActualTypeArgumentForTypeParameterException(final TypeVariable<?> typeParameter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMissingActualTypeArgumentForTypeParameterException$str(), typeParameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateConstraintValidatorFactoryClassException$str() {
        return "HV000095: Unable to instantiate constraint factory class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateConstraintValidatorFactoryClassException(final String constraintValidatorFactoryClassName, final ValidationException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateConstraintValidatorFactoryClassException$str(), constraintValidatorFactoryClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToOpenInputStreamForMappingFileException$str() {
        return "HV000096: Unable to open input stream for mapping file %s.";
    }
    @Override
    public final ValidationException getUnableToOpenInputStreamForMappingFileException(final String mappingFileName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToOpenInputStreamForMappingFileException$str(), mappingFileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateMessageInterpolatorClassException$str() {
        return "HV000097: Unable to instantiate message interpolator class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateMessageInterpolatorClassException(final String messageInterpolatorClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateMessageInterpolatorClassException$str(), messageInterpolatorClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateTraversableResolverClassException$str() {
        return "HV000098: Unable to instantiate traversable resolver class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateTraversableResolverClassException(final String traversableResolverClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateTraversableResolverClassException$str(), traversableResolverClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateValidationProviderClassException$str() {
        return "HV000099: Unable to instantiate validation provider class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateValidationProviderClassException(final String providerClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateValidationProviderClassException$str(), providerClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToParseValidationXmlFileException$str() {
        return "HV000100: Unable to parse %s.";
    }
    @Override
    public final ValidationException getUnableToParseValidationXmlFileException(final String file, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToParseValidationXmlFileException$str(), file), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getIsNotAnAnnotationException$str() {
        return "HV000101: %s is not an annotation.";
    }
    @Override
    public final ValidationException getIsNotAnAnnotationException(final Class<?> annotationClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getIsNotAnAnnotationException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getIsNotAConstraintValidatorClassException$str() {
        return "HV000102: %s is not a constraint validator class.";
    }
    @Override
    public final ValidationException getIsNotAConstraintValidatorClassException(final Class<?> validatorClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getIsNotAConstraintValidatorClassException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatorClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanClassHasAlreadyBeenConfiguredInXmlException$str() {
        return "HV000103: %s is configured at least twice in xml.";
    }
    @Override
    public final ValidationException getBeanClassHasAlreadyBeenConfiguredInXmlException(final Class<?> beanClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getBeanClassHasAlreadyBeenConfiguredInXmlException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getIsDefinedTwiceInMappingXmlForBeanException$str() {
        return "HV000104: %1$s is defined twice in mapping xml for bean %2$s.";
    }
    @Override
    public final ValidationException getIsDefinedTwiceInMappingXmlForBeanException(final String name, final Class<?> beanClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getIsDefinedTwiceInMappingXmlForBeanException$str(), name, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanDoesNotContainTheFieldException$str() {
        return "HV000105: %1$s does not contain the fieldType %2$s.";
    }
    @Override
    public final ValidationException getBeanDoesNotContainTheFieldException(final Class<?> beanClass, final String fieldName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getBeanDoesNotContainTheFieldException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanDoesNotContainThePropertyException$str() {
        return "HV000106: %1$s does not contain the property %2$s.";
    }
    @Override
    public final ValidationException getBeanDoesNotContainThePropertyException(final Class<?> beanClass, final String getterName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getBeanDoesNotContainThePropertyException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), getterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getAnnotationDoesNotContainAParameterException$str() {
        return "HV000107: Annotation of type %1$s does not contain a parameter %2$s.";
    }
    @Override
    public final ValidationException getAnnotationDoesNotContainAParameterException(final Class<? extends java.lang.annotation.Annotation> annotationClass, final String parameterName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getAnnotationDoesNotContainAParameterException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationClass), parameterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException$str() {
        return "HV000108: Attempt to specify an array where single value is expected.";
    }
    @Override
    public final ValidationException getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnexpectedParameterValueException$str() {
        return "HV000109: Unexpected parameter value.";
    }
    @Override
    public final ValidationException getUnexpectedParameterValueException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnexpectedParameterValueException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final ValidationException getUnexpectedParameterValueException(final ClassCastException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnexpectedParameterValueException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidNumberFormatException$str() {
        return "HV000110: Invalid %s format.";
    }
    @Override
    public final ValidationException getInvalidNumberFormatException(final String formatName, final NumberFormatException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInvalidNumberFormatException$str(), formatName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidCharValueException$str() {
        return "HV000111: Invalid char value: %s.";
    }
    @Override
    public final ValidationException getInvalidCharValueException(final String value) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInvalidCharValueException$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidReturnTypeException$str() {
        return "HV000112: Invalid return type: %s. Should be a enumeration type.";
    }
    @Override
    public final ValidationException getInvalidReturnTypeException(final Class<?> returnType, final ClassCastException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInvalidReturnTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(returnType)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getReservedParameterNamesException$str() {
        return "HV000113: %s, %s, %s are reserved parameter names.";
    }
    @Override
    public final ValidationException getReservedParameterNamesException(final String messageParameterName, final String groupsParameterName, final String payloadParameterName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getReservedParameterNamesException$str(), messageParameterName, groupsParameterName, payloadParameterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWrongPayloadClassException$str() {
        return "HV000114: Specified payload class %s does not implement javax.validation.Payload";
    }
    @Override
    public final ValidationException getWrongPayloadClassException(final Class<?> payloadClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getWrongPayloadClassException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(payloadClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getErrorParsingMappingFileException$str() {
        return "HV000115: Error parsing mapping file.";
    }
    @Override
    public final ValidationException getErrorParsingMappingFileException(final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getErrorParsingMappingFileException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getIllegalArgumentException$str() {
        return "HV000116: %s";
    }
    @Override
    public final IllegalArgumentException getIllegalArgumentException(final String message) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getIllegalArgumentException$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToNarrowNodeTypeException$str() {
        return "HV000118: Unable to cast %s (with element kind %s) to %s";
    }
    @Override
    public final ClassCastException getUnableToNarrowNodeTypeException(final Class<?> actualDescriptorType, final ElementKind kind, final Class<?> expectedDescriptorType) {
        final ClassCastException result = new ClassCastException(String.format(getLoggingLocale(), getUnableToNarrowNodeTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(actualDescriptorType), kind, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(expectedDescriptorType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void usingParameterNameProvider(final Class<? extends javax.validation.ParameterNameProvider> parameterNameProviderClass) {
        super.log.logf(FQCN, DEBUG, null, usingParameterNameProvider$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(parameterNameProviderClass));
    }
    protected String usingParameterNameProvider$str() {
        return "HV000119: Using %s as parameter name provider.";
    }
    protected String getUnableToInstantiateParameterNameProviderClassException$str() {
        return "HV000120: Unable to instantiate parameter name provider class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateParameterNameProviderClassException(final String parameterNameProviderClassName, final ValidationException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateParameterNameProviderClassException$str(), parameterNameProviderClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToDetermineSchemaVersionException$str() {
        return "HV000121: Unable to parse %s.";
    }
    @Override
    public final ValidationException getUnableToDetermineSchemaVersionException(final String file, final XMLStreamException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToDetermineSchemaVersionException$str(), file), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnsupportedSchemaVersionException$str() {
        return "HV000122: Unsupported schema version for %s: %s.";
    }
    @Override
    public final ValidationException getUnsupportedSchemaVersionException(final String file, final String version) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnsupportedSchemaVersionException$str(), file, version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMultipleGroupConversionsForSameSourceException$str() {
        return "HV000124: Found multiple group conversions for source group %s: %s.";
    }
    @Override
    public final ConstraintDeclarationException getMultipleGroupConversionsForSameSourceException(final Class<?> from, final Collection<Class<?>> tos) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getMultipleGroupConversionsForSameSourceException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(from), new org.hibernate.validator.internal.util.logging.formatter.CollectionOfClassesObjectFormatter(tos)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getGroupConversionOnNonCascadingElementException$str() {
        return "HV000125: Found group conversions for non-cascading element at: %s.";
    }
    @Override
    public final ConstraintDeclarationException getGroupConversionOnNonCascadingElementException(final Object context) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getGroupConversionOnNonCascadingElementException$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getGroupConversionForSequenceException$str() {
        return "HV000127: Found group conversion using a group sequence as source at: %s.";
    }
    @Override
    public final ConstraintDeclarationException getGroupConversionForSequenceException(final Class<?> from) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getGroupConversionForSequenceException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(from)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unknownPropertyInExpressionLanguage(final String expression, final Exception e) {
        super.log.logf(FQCN, WARN, e, unknownPropertyInExpressionLanguage$str(), expression);
    }
    protected String unknownPropertyInExpressionLanguage$str() {
        return "HV000129: EL expression '%s' references an unknown property";
    }
    @Override
    public final void errorInExpressionLanguage(final String expression, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorInExpressionLanguage$str(), expression);
    }
    protected String errorInExpressionLanguage$str() {
        return "HV000130: Error in EL expression '%s'";
    }
    protected String getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException$str() {
        return "HV000131: A method return value must not be marked for cascaded validation more than once in a class hierarchy, but the following two methods are marked as such: %s, %s.";
    }
    @Override
    public final ConstraintDeclarationException getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException(final Callable callable1, final Callable callable2) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException$str(), callable1, callable2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getVoidMethodsMustNotBeConstrainedException$str() {
        return "HV000132: Void methods must not be constrained or marked for cascaded validation, but method %s is.";
    }
    @Override
    public final ConstraintDeclarationException getVoidMethodsMustNotBeConstrainedException(final Callable callable) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getVoidMethodsMustNotBeConstrainedException$str(), callable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanDoesNotContainConstructorException$str() {
        return "HV000133: %1$s does not contain a constructor with the parameter types %2$s.";
    }
    @Override
    public final ValidationException getBeanDoesNotContainConstructorException(final Class<?> beanClass, final Class<?>[] parameterTypes) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getBeanDoesNotContainConstructorException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), new org.hibernate.validator.internal.util.logging.formatter.ArrayOfClassesObjectFormatter(parameterTypes)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidParameterTypeException$str() {
        return "HV000134: Unable to load parameter of type '%1$s' in %2$s.";
    }
    @Override
    public final ValidationException getInvalidParameterTypeException(final String type, final Class<?> beanClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInvalidParameterTypeException$str(), type, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanDoesNotContainMethodException$str() {
        return "HV000135: %1$s does not contain a method with the name '%2$s' and parameter types %3$s.";
    }
    @Override
    public final ValidationException getBeanDoesNotContainMethodException(final Class<?> beanClass, final String methodName, final Class<?>[] parameterTypes) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getBeanDoesNotContainMethodException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), methodName, new org.hibernate.validator.internal.util.logging.formatter.ArrayOfClassesObjectFormatter(parameterTypes)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToLoadConstraintAnnotationClassException$str() {
        return "HV000136: The specified constraint annotation class %1$s cannot be loaded.";
    }
    @Override
    public final ValidationException getUnableToLoadConstraintAnnotationClassException(final String constraintAnnotationClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToLoadConstraintAnnotationClassException$str(), constraintAnnotationClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMethodIsDefinedTwiceInMappingXmlForBeanException$str() {
        return "HV000137: The method '%1$s' is defined twice in the mapping xml for bean %2$s.";
    }
    @Override
    public final ValidationException getMethodIsDefinedTwiceInMappingXmlForBeanException(final JavaBeanMethod javaBeanMethod, final Class<?> beanClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getMethodIsDefinedTwiceInMappingXmlForBeanException$str(), javaBeanMethod, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConstructorIsDefinedTwiceInMappingXmlForBeanException$str() {
        return "HV000138: The constructor '%1$s' is defined twice in the mapping xml for bean %2$s.";
    }
    @Override
    public final ValidationException getConstructorIsDefinedTwiceInMappingXmlForBeanException(final JavaBeanConstructor javaBeanConstructor, final Class<?> beanClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getConstructorIsDefinedTwiceInMappingXmlForBeanException$str(), javaBeanConstructor, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMultipleCrossParameterValidatorClassesException$str() {
        return "HV000139: The constraint '%1$s' defines multiple cross parameter validators. Only one is allowed.";
    }
    @Override
    public final ConstraintDefinitionException getMultipleCrossParameterValidatorClassesException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getMultipleCrossParameterValidatorClassesException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getImplicitConstraintTargetInAmbiguousConfigurationException$str() {
        return "HV000141: The constraint %1$s used ConstraintTarget#IMPLICIT where the target cannot be inferred.";
    }
    @Override
    public final ConstraintDeclarationException getImplicitConstraintTargetInAmbiguousConfigurationException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getImplicitConstraintTargetInAmbiguousConfigurationException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCrossParameterConstraintOnMethodWithoutParametersException$str() {
        return "HV000142: Cross parameter constraint %1$s is illegally placed on a parameterless method or constructor '%2$s'.";
    }
    @Override
    public final ConstraintDeclarationException getCrossParameterConstraintOnMethodWithoutParametersException(final Class<? extends java.lang.annotation.Annotation> constraint, final Constrainable executable) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getCrossParameterConstraintOnMethodWithoutParametersException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint), executable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCrossParameterConstraintOnClassException$str() {
        return "HV000143: Cross parameter constraint %1$s is illegally placed on class level.";
    }
    @Override
    public final ConstraintDeclarationException getCrossParameterConstraintOnClassException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getCrossParameterConstraintOnClassException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCrossParameterConstraintOnFieldException$str() {
        return "HV000144: Cross parameter constraint %1$s is illegally placed on field '%2$s'.";
    }
    @Override
    public final ConstraintDeclarationException getCrossParameterConstraintOnFieldException(final Class<? extends java.lang.annotation.Annotation> constraint, final Constrainable field) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getCrossParameterConstraintOnFieldException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint), field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParameterNodeAddedForNonCrossParameterConstraintException$str() {
        return "HV000146: No parameter nodes may be added since path %s doesn't refer to a cross-parameter constraint.";
    }
    @Override
    public final IllegalStateException getParameterNodeAddedForNonCrossParameterConstraintException(final Path path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getParameterNodeAddedForNonCrossParameterConstraintException$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConstrainedElementConfiguredMultipleTimesException$str() {
        return "HV000147: %1$s is configured multiple times (note, <getter> and <method> nodes for the same method are not allowed)";
    }
    @Override
    public final ValidationException getConstrainedElementConfiguredMultipleTimesException(final String location) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getConstrainedElementConfiguredMultipleTimesException$str(), location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void evaluatingExpressionLanguageExpressionCausedException(final String expression, final Exception e) {
        super.log.logf(FQCN, WARN, e, evaluatingExpressionLanguageExpressionCausedException$str(), expression);
    }
    protected String evaluatingExpressionLanguageExpressionCausedException$str() {
        return "HV000148: An exception occurred during evaluation of EL expression '%s'";
    }
    protected String getExceptionOccurredDuringMessageInterpolationException$str() {
        return "HV000149: An exception occurred during message interpolation";
    }
    @Override
    public final ValidationException getExceptionOccurredDuringMessageInterpolationException(final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getExceptionOccurredDuringMessageInterpolationException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMultipleValidatorsForSameTypeException$str() {
        return "HV000150: The constraint %1$s defines multiple validators for the type %2$s: %3$s, %4$s. Only one is allowed.";
    }
    @Override
    public final UnexpectedTypeException getMultipleValidatorsForSameTypeException(final Class<? extends java.lang.annotation.Annotation> constraint, final Type type, final Class<? extends javax.validation.ConstraintValidator<?, ?>> validatorClass1, final Class<? extends javax.validation.ConstraintValidator<?, ?>> validatorClass2) {
        final UnexpectedTypeException result = new UnexpectedTypeException(String.format(getLoggingLocale(), getMultipleValidatorsForSameTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(type), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatorClass1), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatorClass2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParameterConfigurationAlteredInSubTypeException$str() {
        return "HV000151: A method overriding another method must not redefine the parameter constraint configuration, but method %2$s redefines the configuration of %1$s.";
    }
    @Override
    public final ConstraintDeclarationException getParameterConfigurationAlteredInSubTypeException(final Callable superMethod, final Callable subMethod) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getParameterConfigurationAlteredInSubTypeException$str(), superMethod, subMethod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParameterConstraintsDefinedInMethodsFromParallelTypesException$str() {
        return "HV000152: Two methods defined in parallel types must not declare parameter constraints, if they are overridden by the same method, but methods %s and %s both define parameter constraints.";
    }
    @Override
    public final ConstraintDeclarationException getParameterConstraintsDefinedInMethodsFromParallelTypesException(final Callable method1, final Callable method2) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getParameterConstraintsDefinedInMethodsFromParallelTypesException$str(), method1, method2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException$str() {
        return "HV000153: The constraint %1$s used ConstraintTarget#%2$s but is not specified on a method or constructor.";
    }
    @Override
    public final ConstraintDeclarationException getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException(final Class<? extends java.lang.annotation.Annotation> constraint, final ConstraintTarget target) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint), target));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCrossParameterConstraintHasNoValidatorException$str() {
        return "HV000154: Cross parameter constraint %1$s has no cross-parameter validator.";
    }
    @Override
    public final ConstraintDefinitionException getCrossParameterConstraintHasNoValidatorException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getCrossParameterConstraintHasNoValidatorException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getComposedAndComposingConstraintsHaveDifferentTypesException$str() {
        return "HV000155: Composed and composing constraints must have the same constraint type, but composed constraint %1$s has type %3$s, while composing constraint %2$s has type %4$s.";
    }
    @Override
    public final ConstraintDefinitionException getComposedAndComposingConstraintsHaveDifferentTypesException(final Class<? extends java.lang.annotation.Annotation> composedConstraintClass, final Class<? extends java.lang.annotation.Annotation> composingConstraintClass, final ConstraintType composedConstraintType, final ConstraintType composingConstraintType) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getComposedAndComposingConstraintsHaveDifferentTypesException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(composedConstraintClass), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(composingConstraintClass), composedConstraintType, composingConstraintType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException$str() {
        return "HV000156: Constraints with generic as well as cross-parameter validators must define an attribute validationAppliesTo(), but constraint %s doesn't.";
    }
    @Override
    public final ConstraintDefinitionException getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException$str() {
        return "HV000157: Return type of the attribute validationAppliesTo() of the constraint %s must be javax.validation.ConstraintTarget.";
    }
    @Override
    public final ConstraintDefinitionException getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValidationAppliesToParameterMustHaveDefaultValueImplicitException$str() {
        return "HV000158: Default value of the attribute validationAppliesTo() of the constraint %s must be ConstraintTarget#IMPLICIT.";
    }
    @Override
    public final ConstraintDefinitionException getValidationAppliesToParameterMustHaveDefaultValueImplicitException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getValidationAppliesToParameterMustHaveDefaultValueImplicitException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException$str() {
        return "HV000159: Only constraints with generic as well as cross-parameter validators must define an attribute validationAppliesTo(), but constraint %s does.";
    }
    @Override
    public final ConstraintDefinitionException getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException$str() {
        return "HV000160: Validator for cross-parameter constraint %s does not validate Object nor Object[].";
    }
    @Override
    public final ConstraintDefinitionException getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException(final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException$str() {
        return "HV000161: Two methods defined in parallel types must not define group conversions for a cascaded method return value, if they are overridden by the same method, but methods %s and %s both define parameter constraints.";
    }
    @Override
    public final ConstraintDeclarationException getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException(final Callable method1, final Callable method2) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException$str(), method1, method2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMethodOrConstructorNotDefinedByValidatedTypeException$str() {
        return "HV000162: The validated type %1$s does not specify the constructor/method: %2$s";
    }
    @Override
    public final IllegalArgumentException getMethodOrConstructorNotDefinedByValidatedTypeException(final Class<?> validatedType, final Executable executable) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMethodOrConstructorNotDefinedByValidatedTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatedType), new org.hibernate.validator.internal.util.logging.formatter.ExecutableFormatter(executable)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParameterTypesDoNotMatchException$str() {
        return "HV000163: The actual parameter type '%1$s' is not assignable to the expected one '%2$s' for parameter %3$d of '%4$s'";
    }
    @Override
    public final IllegalArgumentException getParameterTypesDoNotMatchException(final Class<?> actualType, final Type expectedType, final int index, final Executable executable) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getParameterTypesDoNotMatchException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(actualType), expectedType, index, new org.hibernate.validator.internal.util.logging.formatter.ExecutableFormatter(executable)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getHasToBeABoxedTypeException$str() {
        return "HV000164: %s has to be a auto-boxed type.";
    }
    @Override
    public final IllegalArgumentException getHasToBeABoxedTypeException(final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getHasToBeABoxedTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMixingImplicitWithOtherExecutableTypesException$str() {
        return "HV000165: Mixing IMPLICIT and other executable types is not allowed.";
    }
    @Override
    public final IllegalArgumentException getMixingImplicitWithOtherExecutableTypesException() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMixingImplicitWithOtherExecutableTypesException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValidateOnExecutionOnOverriddenOrInterfaceMethodException$str() {
        return "HV000166: @ValidateOnExecution is not allowed on methods overriding a superclass method or implementing an interface. Check configuration for %1$s";
    }
    @Override
    public final ValidationException getValidateOnExecutionOnOverriddenOrInterfaceMethodException(final Executable executable) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getValidateOnExecutionOnOverriddenOrInterfaceMethodException$str(), new org.hibernate.validator.internal.util.logging.formatter.ExecutableFormatter(executable)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getOverridingConstraintDefinitionsInMultipleMappingFilesException$str() {
        return "HV000167: A given constraint definition can only be overridden in one mapping file. %1$s is overridden in multiple files";
    }
    @Override
    public final ValidationException getOverridingConstraintDefinitionsInMultipleMappingFilesException(final String constraintClassName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getOverridingConstraintDefinitionsInMultipleMappingFilesException$str(), constraintClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnbalancedBeginEndParameterException$str() {
        return "HV000168: The message descriptor '%1$s' contains an unbalanced meta character '%2$c'.";
    }
    @Override
    public final MessageDescriptorFormatException getUnbalancedBeginEndParameterException(final String messageDescriptor, final char character) {
        final MessageDescriptorFormatException result = new MessageDescriptorFormatException(String.format(getLoggingLocale(), getUnbalancedBeginEndParameterException$str(), messageDescriptor, character));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNestedParameterException$str() {
        return "HV000169: The message descriptor '%1$s' has nested parameters.";
    }
    @Override
    public final MessageDescriptorFormatException getNestedParameterException(final String messageDescriptor) {
        final MessageDescriptorFormatException result = new MessageDescriptorFormatException(String.format(getLoggingLocale(), getNestedParameterException$str(), messageDescriptor));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCreationOfScriptExecutorFailedException$str() {
        return "HV000170: No JSR-223 scripting engine could be bootstrapped for language \"%s\".";
    }
    @Override
    public final ConstraintDeclarationException getCreationOfScriptExecutorFailedException(final String languageName, final Exception e) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getCreationOfScriptExecutorFailedException$str(), languageName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getBeanClassHasAlreadyBeConfiguredViaProgrammaticApiException$str() {
        return "HV000171: %s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getBeanClassHasAlreadyBeConfiguredViaProgrammaticApiException(final Class<?> beanClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getBeanClassHasAlreadyBeConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getPropertyHasAlreadyBeConfiguredViaProgrammaticApiException$str() {
        return "HV000172: Property \"%2$s\" of type %1$s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getPropertyHasAlreadyBeConfiguredViaProgrammaticApiException(final Class<?> beanClass, final String propertyName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getPropertyHasAlreadyBeConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMethodHasAlreadyBeenConfiguredViaProgrammaticApiException$str() {
        return "HV000173: Method %2$s of type %1$s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getMethodHasAlreadyBeenConfiguredViaProgrammaticApiException(final Class<?> beanClass, final String method) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getMethodHasAlreadyBeenConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParameterHasAlreadyBeConfiguredViaProgrammaticApiException$str() {
        return "HV000174: Parameter %3$s of method or constructor %2$s of type %1$s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getParameterHasAlreadyBeConfiguredViaProgrammaticApiException(final Class<?> beanClass, final Callable callable, final int parameterIndex) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getParameterHasAlreadyBeConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), callable, parameterIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getReturnValueHasAlreadyBeConfiguredViaProgrammaticApiException$str() {
        return "HV000175: The return value of method or constructor %2$s of type %1$s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getReturnValueHasAlreadyBeConfiguredViaProgrammaticApiException(final Class<?> beanClass, final Callable callable) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getReturnValueHasAlreadyBeConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), callable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConstructorHasAlreadyBeConfiguredViaProgrammaticApiException$str() {
        return "HV000176: Constructor %2$s of type %1$s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getConstructorHasAlreadyBeConfiguredViaProgrammaticApiException(final Class<?> beanClass, final String constructor) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getConstructorHasAlreadyBeConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), constructor));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCrossParameterElementHasAlreadyBeConfiguredViaProgrammaticApiException$str() {
        return "HV000177: Cross-parameter constraints for the method or constructor %2$s of type %1$s are declared more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getCrossParameterElementHasAlreadyBeConfiguredViaProgrammaticApiException(final Class<?> beanClass, final Callable callable) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getCrossParameterElementHasAlreadyBeConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass), callable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getMultiplierCannotBeNegativeException$str() {
        return "HV000178: Multiplier cannot be negative: %d.";
    }
    @Override
    public final IllegalArgumentException getMultiplierCannotBeNegativeException(final int multiplier) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getMultiplierCannotBeNegativeException$str(), multiplier));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWeightCannotBeNegativeException$str() {
        return "HV000179: Weight cannot be negative: %d.";
    }
    @Override
    public final IllegalArgumentException getWeightCannotBeNegativeException(final int weight) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getWeightCannotBeNegativeException$str(), weight));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getTreatCheckAsIsNotADigitNorALetterException$str() {
        return "HV000180: '%c' is not a digit nor a letter.";
    }
    @Override
    public final IllegalArgumentException getTreatCheckAsIsNotADigitNorALetterException(final int weight) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getTreatCheckAsIsNotADigitNorALetterException$str(), weight));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidParameterCountForExecutableException$str() {
        return "HV000181: Wrong number of parameters. Method or constructor %1$s expects %2$d parameters, but got %3$d.";
    }
    @Override
    public final IllegalArgumentException getInvalidParameterCountForExecutableException(final String executable, final int expectedParameterCount, final int actualParameterCount) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getInvalidParameterCountForExecutableException$str(), executable, expectedParameterCount, actualParameterCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoUnwrapperFoundForTypeException$str() {
        return "HV000182: No validation value unwrapper is registered for type '%1$s'.";
    }
    @Override
    public final ValidationException getNoUnwrapperFoundForTypeException(final Type type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getNoUnwrapperFoundForTypeException$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInitializeELExpressionFactoryException$str() {
        return "HV000183: Unable to initialize 'javax.el.ExpressionFactory'. Check that you have the EL dependencies on the classpath, or use ParameterMessageInterpolator instead";
    }
    @Override
    public final ValidationException getUnableToInitializeELExpressionFactoryException(final Throwable e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInitializeELExpressionFactoryException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnElIsUnsupported(final String expression) {
        super.log.logf(FQCN, WARN, null, warnElIsUnsupported$str(), expression);
    }
    protected String warnElIsUnsupported$str() {
        return "HV000185: Message contains EL expression: %1s, which is not supported by the selected message interpolator";
    }
    protected String getInconsistentValueUnwrappingConfigurationBetweenFieldAndItsGetterException$str() {
        return "HV000189: The configuration of value unwrapping for property '%s' of bean '%s' is inconsistent between the field and its getter.";
    }
    @Override
    public final ConstraintDeclarationException getInconsistentValueUnwrappingConfigurationBetweenFieldAndItsGetterException(final String property, final Class<?> beanClass) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getInconsistentValueUnwrappingConfigurationBetweenFieldAndItsGetterException$str(), property, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(beanClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToCreateXMLEventReader$str() {
        return "HV000190: Unable to parse %s.";
    }
    @Override
    public final ValidationException getUnableToCreateXMLEventReader(final String file, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToCreateXMLEventReader$str(), file), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unknownJvmVersion(final String vmVersionStr) {
        super.log.logf(FQCN, WARN, null, unknownJvmVersion$str(), vmVersionStr);
    }
    protected String unknownJvmVersion$str() {
        return "HV000192: Couldn't determine Java version from value %1s; Not enabling features requiring Java 8";
    }
    protected String getConstraintHasAlreadyBeenConfiguredViaProgrammaticApiException$str() {
        return "HV000193: %s is configured more than once via the programmatic constraint definition API.";
    }
    @Override
    public final ValidationException getConstraintHasAlreadyBeenConfiguredViaProgrammaticApiException(final Class<? extends java.lang.annotation.Annotation> annotationClass) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getConstraintHasAlreadyBeenConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(annotationClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getEmptyElementOnlySupportedWhenCharSequenceIsExpectedExpection$str() {
        return "HV000194: An empty element is only supported when a CharSequence is expected.";
    }
    @Override
    public final ValidationException getEmptyElementOnlySupportedWhenCharSequenceIsExpectedExpection() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getEmptyElementOnlySupportedWhenCharSequenceIsExpectedExpection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToReachPropertyToValidateException$str() {
        return "HV000195: Unable to reach the property to validate for the bean %s and the property path %s. A property is null along the way.";
    }
    @Override
    public final ValidationException getUnableToReachPropertyToValidateException(final Object bean, final Path path) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToReachPropertyToValidateException$str(), bean, path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToConvertTypeToClassException$str() {
        return "HV000196: Unable to convert the Type %s to a Class.";
    }
    @Override
    public final ValidationException getUnableToConvertTypeToClassException(final Type type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToConvertTypeToClassException$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoValueExtractorFoundForTypeException2$str() {
        return "HV000197: No value extractor found for type parameter '%2$s' of type %1$s.";
    }
    @Override
    public final ConstraintDeclarationException getNoValueExtractorFoundForTypeException(final Class<?> type, final TypeVariable<?> typeParameter) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getNoValueExtractorFoundForTypeException2$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(type), typeParameter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoValueExtractorFoundForUnwrapException$str() {
        return "HV000198: No suitable value extractor found for type %1$s.";
    }
    @Override
    public final ConstraintDeclarationException getNoValueExtractorFoundForUnwrapException(final Type type) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getNoValueExtractorFoundForUnwrapException$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void usingClockProvider(final Class<? extends javax.validation.ClockProvider> clockProviderClass) {
        super.log.logf(FQCN, DEBUG, null, usingClockProvider$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clockProviderClass));
    }
    protected String usingClockProvider$str() {
        return "HV000200: Using %s as clock provider.";
    }
    protected String getUnableToInstantiateClockProviderClassException$str() {
        return "HV000201: Unable to instantiate clock provider class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateClockProviderClassException(final String clockProviderClassName, final ValidationException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateClockProviderClassException$str(), clockProviderClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToGetCurrentTimeFromClockProvider$str() {
        return "HV000202: Unable to get the current time from the clock provider";
    }
    @Override
    public final ValidationException getUnableToGetCurrentTimeFromClockProvider(final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToGetCurrentTimeFromClockProvider$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValueExtractorFailsToDeclareExtractedValueException$str() {
        return "HV000203: Value extractor type %1s fails to declare the extracted type parameter using @ExtractedValue.";
    }
    @Override
    public final ValueExtractorDefinitionException getValueExtractorFailsToDeclareExtractedValueException(final Class<?> extractorType) {
        final ValueExtractorDefinitionException result = new ValueExtractorDefinitionException(String.format(getLoggingLocale(), getValueExtractorFailsToDeclareExtractedValueException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(extractorType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getValueExtractorDeclaresExtractedValueMultipleTimesException$str() {
        return "HV000204: Only one type parameter must be marked with @ExtractedValue for value extractor type %1s.";
    }
    @Override
    public final ValueExtractorDefinitionException getValueExtractorDeclaresExtractedValueMultipleTimesException(final Class<?> extractorType) {
        final ValueExtractorDefinitionException result = new ValueExtractorDefinitionException(String.format(getLoggingLocale(), getValueExtractorDeclaresExtractedValueMultipleTimesException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(extractorType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidUnwrappingConfigurationForConstraintException$str() {
        return "HV000205: Invalid unwrapping configuration for constraint %2$s on %1$s. You can only define one of 'Unwrapping.Skip' or 'Unwrapping.Unwrap'.";
    }
    @Override
    public final ConstraintDeclarationException getInvalidUnwrappingConfigurationForConstraintException(final Constrainable constrainable, final Class<? extends java.lang.annotation.Annotation> constraint) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getInvalidUnwrappingConfigurationForConstraintException$str(), constrainable, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToInstantiateValueExtractorClassException$str() {
        return "HV000206: Unable to instantiate value extractor class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateValueExtractorClassException(final String valueExtractorClassName, final ValidationException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateValueExtractorClassException$str(), valueExtractorClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void addingValueExtractor(final Class<? extends ValueExtractor<?>> valueExtractorClass) {
        super.log.logf(FQCN, DEBUG, null, addingValueExtractor$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(valueExtractorClass));
    }
    protected String addingValueExtractor$str() {
        return "HV000207: Adding value extractor %s.";
    }
    protected String getValueExtractorForTypeAndTypeUseAlreadyPresentException$str() {
        return "HV000208: Given value extractor %2$s handles the same type and type use as previously given value extractor %1$s.";
    }
    @Override
    public final ValueExtractorDeclarationException getValueExtractorForTypeAndTypeUseAlreadyPresentException(final ValueExtractor<?> first, final ValueExtractor<?> second) {
        final ValueExtractorDeclarationException result = new ValueExtractorDeclarationException(String.format(getLoggingLocale(), getValueExtractorForTypeAndTypeUseAlreadyPresentException$str(), first, second));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getCannotMixDirectAnnotationAndListContainerOnComposedConstraintException$str() {
        return "HV000209: A composing constraint (%2$s) must not be given directly on the composed constraint (%1$s) and using the corresponding List annotation at the same time.";
    }
    @Override
    public final ConstraintDeclarationException getCannotMixDirectAnnotationAndListContainerOnComposedConstraintException(final Class<? extends java.lang.annotation.Annotation> composedConstraint, final Class<? extends java.lang.annotation.Annotation> composingConstraint) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getCannotMixDirectAnnotationAndListContainerOnComposedConstraintException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(composedConstraint), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(composingConstraint)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToFindTypeParameterInClass$str() {
        return "HV000210: Unable to find the type parameter %2$s in class %1$s.";
    }
    @Override
    public final IllegalArgumentException getUnableToFindTypeParameterInClass(final Class<?> clazz, final Object typeParameterReference) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getUnableToFindTypeParameterInClass$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz), typeParameterReference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getTypeIsNotAParameterizedNorArrayTypeException$str() {
        return "HV000211: Given type is neither a parameterized nor an array type: %s.";
    }
    @Override
    public final ValidationException getTypeIsNotAParameterizedNorArrayTypeException(final Type type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getTypeIsNotAParameterizedNorArrayTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInvalidTypeArgumentIndexException$str() {
        return "HV000212: Given type has no type argument with index %2$s: %1$s.";
    }
    @Override
    public final ValidationException getInvalidTypeArgumentIndexException(final Type type, final int index) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getInvalidTypeArgumentIndexException$str(), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(type), index));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoTypeArgumentIndexIsGivenForTypeWithMultipleTypeArgumentsException$str() {
        return "HV000213: Given type has more than one type argument, hence an argument index must be specified: %s.";
    }
    @Override
    public final ValidationException getNoTypeArgumentIndexIsGivenForTypeWithMultipleTypeArgumentsException(final Type type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getNoTypeArgumentIndexIsGivenForTypeWithMultipleTypeArgumentsException$str(), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getContainerElementTypeHasAlreadyBeenConfiguredViaProgrammaticApiException$str() {
        return "HV000214: The same container element type of type %1$s is configured more than once via the programmatic constraint declaration API.";
    }
    @Override
    public final ValidationException getContainerElementTypeHasAlreadyBeenConfiguredViaProgrammaticApiException(final Type type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getContainerElementTypeHasAlreadyBeenConfiguredViaProgrammaticApiException$str(), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParameterIsNotAValidCallException$str() {
        return "HV000215: Calling parameter() is not allowed for the current element.";
    }
    @Override
    public final ValidationException getParameterIsNotAValidCallException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getParameterIsNotAValidCallException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getReturnValueIsNotAValidCallException$str() {
        return "HV000216: Calling returnValue() is not allowed for the current element.";
    }
    @Override
    public final ValidationException getReturnValueIsNotAValidCallException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getReturnValueIsNotAValidCallException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getContainerElementTypeHasAlreadyBeenConfiguredViaXmlMappingConfigurationException$str() {
        return "HV000217: The same container element type %2$s is configured more than once for location %1$s via the XML mapping configuration.";
    }
    @Override
    public final ValidationException getContainerElementTypeHasAlreadyBeenConfiguredViaXmlMappingConfigurationException(final ConstraintLocation rootConstraintLocation, final ContainerElementTypePath path) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getContainerElementTypeHasAlreadyBeenConfiguredViaXmlMappingConfigurationException$str(), rootConstraintLocation, path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getParallelDefinitionsOfValueExtractorsException$str() {
        return "HV000218: Having parallel definitions of value extractors on a given class is not allowed: %s.";
    }
    @Override
    public final ValueExtractorDefinitionException getParallelDefinitionsOfValueExtractorsException(final Class<?> extractorImplementationType) {
        final ValueExtractorDefinitionException result = new ValueExtractorDefinitionException(String.format(getLoggingLocale(), getParallelDefinitionsOfValueExtractorsException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(extractorImplementationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToGetMostSpecificValueExtractorDueToSeveralMaximallySpecificValueExtractorsDeclaredException$str() {
        return "HV000219: Unable to get the most specific value extractor for type %1$s as several most specific value extractors are declared: %2$s.";
    }
    @Override
    public final ConstraintDeclarationException getUnableToGetMostSpecificValueExtractorDueToSeveralMaximallySpecificValueExtractorsDeclaredException(final Class<?> valueType, final Collection<Class<? extends ValueExtractor>> valueExtractors) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getUnableToGetMostSpecificValueExtractorDueToSeveralMaximallySpecificValueExtractorsDeclaredException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(valueType), new org.hibernate.validator.internal.util.logging.formatter.CollectionOfClassesObjectFormatter(valueExtractors)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getExtractedValueOnTypeParameterOfContainerTypeMayNotDefineTypeAttributeException$str() {
        return "HV000220: When @ExtractedValue is defined on a type parameter of a container type, the type attribute may not be set: %1$s.";
    }
    @Override
    public final ValueExtractorDefinitionException getExtractedValueOnTypeParameterOfContainerTypeMayNotDefineTypeAttributeException(final Class<? extends ValueExtractor> extractorImplementationType) {
        final ValueExtractorDefinitionException result = new ValueExtractorDefinitionException(String.format(getLoggingLocale(), getExtractedValueOnTypeParameterOfContainerTypeMayNotDefineTypeAttributeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(extractorImplementationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getErrorWhileExtractingValuesInValueExtractorException$str() {
        return "HV000221: An error occurred while extracting values in value extractor %1$s.";
    }
    @Override
    public final ValidationException getErrorWhileExtractingValuesInValueExtractorException(final Class<? extends ValueExtractor> extractorImplementationType, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getErrorWhileExtractingValuesInValueExtractorException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(extractorImplementationType)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getDuplicateDefinitionsOfValueExtractorException$str() {
        return "HV000222: The same value extractor %s is added more than once via the XML configuration.";
    }
    @Override
    public final ValueExtractorDeclarationException getDuplicateDefinitionsOfValueExtractorException(final String className) {
        final ValueExtractorDeclarationException result = new ValueExtractorDeclarationException(String.format(getLoggingLocale(), getDuplicateDefinitionsOfValueExtractorException$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getImplicitUnwrappingNotAllowedWhenSeveralMaximallySpecificValueExtractorsMarkedWithUnwrapByDefaultDeclaredException$str() {
        return "HV000223: Implicit unwrapping is not allowed for type %1$s as several maximally specific value extractors marked with @UnwrapByDefault are declared: %2$s.";
    }
    @Override
    public final ConstraintDeclarationException getImplicitUnwrappingNotAllowedWhenSeveralMaximallySpecificValueExtractorsMarkedWithUnwrapByDefaultDeclaredException(final Class<?> valueType, final Collection<Class<? extends ValueExtractor>> valueExtractors) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getImplicitUnwrappingNotAllowedWhenSeveralMaximallySpecificValueExtractorsMarkedWithUnwrapByDefaultDeclaredException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(valueType), new org.hibernate.validator.internal.util.logging.formatter.CollectionOfClassesObjectFormatter(valueExtractors)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnwrappingOfConstraintDescriptorNotSupportedYetException$str() {
        return "HV000224: Unwrapping of ConstraintDescriptor is not supported yet.";
    }
    @Override
    public final ValidationException getUnwrappingOfConstraintDescriptorNotSupportedYetException() {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnwrappingOfConstraintDescriptorNotSupportedYetException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getOnlyUnboundWildcardTypeArgumentsSupportedForContainerTypeOfValueExtractorException$str() {
        return "HV000225: Only unbound wildcard type arguments are supported for the container type of the value extractor: %1$s.";
    }
    @Override
    public final ValueExtractorDefinitionException getOnlyUnboundWildcardTypeArgumentsSupportedForContainerTypeOfValueExtractorException(final Class<? extends ValueExtractor> valueExtractorClass) {
        final ValueExtractorDefinitionException result = new ValueExtractorDefinitionException(String.format(getLoggingLocale(), getOnlyUnboundWildcardTypeArgumentsSupportedForContainerTypeOfValueExtractorException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(valueExtractorClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getContainerElementConstraintsAndCascadedValidationNotSupportedOnArraysException$str() {
        return "HV000226: Container element constraints and cascading validation are not supported on arrays: %1$s";
    }
    @Override
    public final ValidationException getContainerElementConstraintsAndCascadedValidationNotSupportedOnArraysException(final Type type) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getContainerElementConstraintsAndCascadedValidationNotSupportedOnArraysException$str(), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getPropertyNotDefinedByValidatedTypeException$str() {
        return "HV000227: The validated type %1$s does not specify the property: %2$s";
    }
    @Override
    public final IllegalArgumentException getPropertyNotDefinedByValidatedTypeException(final Class<?> validatedType, final String propertyName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getPropertyNotDefinedByValidatedTypeException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(validatedType), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getNoValueExtractorFoundForTypeException3$str() {
        return "HV000228: No value extractor found when narrowing down to the runtime type %3$s among the value extractors for type parameter '%2$s' of type %1$s.";
    }
    @Override
    public final ConstraintDeclarationException getNoValueExtractorFoundForTypeException(final Type declaredType, final TypeVariable<?> declaredTypeParameter, final Class<?> valueType) {
        final ConstraintDeclarationException result = new ConstraintDeclarationException(String.format(getLoggingLocale(), getNoValueExtractorFoundForTypeException3$str(), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(declaredType), declaredTypeParameter, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(valueType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToCastException$str() {
        return "HV000229: Unable to cast %1$s to %2$s.";
    }
    @Override
    public final ClassCastException getUnableToCastException(final Object object, final Class<?> clazz) {
        final ClassCastException result = new ClassCastException(String.format(getLoggingLocale(), getUnableToCastException$str(), object, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void usingScriptEvaluatorFactory(final Class<? extends org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory> scriptEvaluatorFactoryClass) {
        super.log.logf(FQCN, DEBUG, null, usingScriptEvaluatorFactory$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(scriptEvaluatorFactoryClass));
    }
    protected String usingScriptEvaluatorFactory$str() {
        return "HV000230: Using %s as script evaluator factory.";
    }
    protected String getUnableToInstantiateScriptEvaluatorFactoryClassException$str() {
        return "HV000231: Unable to instantiate script evaluator factory class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateScriptEvaluatorFactoryClassException(final String scriptEvaluatorFactoryClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateScriptEvaluatorFactoryClassException$str(), scriptEvaluatorFactoryClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToFindScriptEngineException$str() {
        return "HV000232: No JSR 223 script engine found for language \"%s\".";
    }
    @Override
    public final ScriptEvaluatorNotFoundException getUnableToFindScriptEngineException(final String languageName) {
        final ScriptEvaluatorNotFoundException result = new ScriptEvaluatorNotFoundException(String.format(getLoggingLocale(), getUnableToFindScriptEngineException$str(), languageName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getErrorExecutingScriptException$str() {
        return "HV000233: An error occurred while executing the script: \"%s\".";
    }
    @Override
    public final ScriptEvaluationException getErrorExecutingScriptException(final String script, final Exception e) {
        final ScriptEvaluationException result = new ScriptEvaluationException(String.format(getLoggingLocale(), getErrorExecutingScriptException$str(), script), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logValidatorFactoryScopedConfiguration(final Class<?> configuredClass, final String configuredElement) {
        super.log.logf(FQCN, DEBUG, null, logValidatorFactoryScopedConfiguration$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(configuredClass), configuredElement);
    }
    protected String logValidatorFactoryScopedConfiguration$str() {
        return "HV000234: Using %1$s as ValidatorFactory-scoped %2$s.";
    }
    protected String getUnableToCreateAnnotationDescriptor$str() {
        return "HV000235: Unable to create an annotation descriptor for %1$s.";
    }
    @Override
    public final ValidationException getUnableToCreateAnnotationDescriptor(final Class<?> configuredClass, final Throwable e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToCreateAnnotationDescriptor$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(configuredClass)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToFindAnnotationDefDeclaredMethods$str() {
        return "HV000236: Unable to find the method required to create the constraint annotation descriptor.";
    }
    @Override
    public final ValidationException getUnableToFindAnnotationDefDeclaredMethods(final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToFindAnnotationDefDeclaredMethods$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnableToAccessMethodException$str() {
        return "HV000237: Unable to access method %3$s of class %2$s with parameters %4$s using lookup %1$s.";
    }
    @Override
    public final ValidationException getUnableToAccessMethodException(final Lookup lookup, final Class<?> clazz, final String methodName, final Object[] parameterTypes, final Throwable e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToAccessMethodException$str(), lookup, new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(clazz), methodName, new org.hibernate.validator.internal.util.logging.formatter.ObjectArrayFormatter(parameterTypes)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logTemporalValidationTolerance(final Duration tolerance) {
        super.log.logf(FQCN, DEBUG, null, logTemporalValidationTolerance$str(), new org.hibernate.validator.internal.util.logging.formatter.DurationFormatter(tolerance));
    }
    protected String logTemporalValidationTolerance$str() {
        return "HV000238: Temporal validation tolerance set to %1$s.";
    }
    protected String getUnableToParseTemporalValidationToleranceException$str() {
        return "HV000239: Unable to parse the temporal validation tolerance property %s. It should be a duration represented in milliseconds.";
    }
    @Override
    public final ValidationException getUnableToParseTemporalValidationToleranceException(final String toleranceProperty, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToParseTemporalValidationToleranceException$str(), toleranceProperty), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logConstraintValidatorPayload(final Object payload) {
        super.log.logf(FQCN, DEBUG, null, logConstraintValidatorPayload$str(), payload);
    }
    protected String logConstraintValidatorPayload$str() {
        return "HV000240: Constraint validator payload set to %1$s.";
    }
    protected String logUnknownElementInXmlConfiguration$str() {
        return "HV000241: Encountered unsupported element %1$s while parsing the XML configuration.";
    }
    @Override
    public final ValidationException logUnknownElementInXmlConfiguration(final String tag) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), logUnknownElementInXmlConfiguration$str(), tag));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logUnableToLoadOrInstantiateJPAAwareResolver(final String traversableResolverClassName) {
        super.log.logf(FQCN, WARN, null, logUnableToLoadOrInstantiateJPAAwareResolver$str(), traversableResolverClassName);
    }
    protected String logUnableToLoadOrInstantiateJPAAwareResolver$str() {
        return "HV000242: Unable to load or instantiate JPA aware resolver %1$s. All properties will per default be traversable.";
    }
    protected String getConstraintValidatorDefinitionConstraintMismatchException$str() {
        return "HV000243: Constraint %2$s references constraint validator type %1$s, but this validator is defined for constraint type %3$s.";
    }
    @Override
    public final ConstraintDefinitionException getConstraintValidatorDefinitionConstraintMismatchException(final Class<? extends javax.validation.ConstraintValidator<?, ?>> constraintValidatorImplementationType, final Class<? extends java.lang.annotation.Annotation> registeredConstraintAnnotationType, final Type declaredConstraintAnnotationType) {
        final ConstraintDefinitionException result = new ConstraintDefinitionException(String.format(getLoggingLocale(), getConstraintValidatorDefinitionConstraintMismatchException$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(constraintValidatorImplementationType), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(registeredConstraintAnnotationType), new org.hibernate.validator.internal.util.logging.formatter.TypeFormatter(declaredConstraintAnnotationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnexpectedConstraintElementType$str() {
        return "HV000244: ConstrainedElement expected class was %1$s, but instead received %2$s.";
    }
    @Override
    public final AssertionError getUnexpectedConstraintElementType(final Class<?> expecting, final Class<?> got) {
        final AssertionError result = new AssertionError(String.format(getLoggingLocale(), getUnexpectedConstraintElementType$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(expecting), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(got)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getUnsupportedConstraintElementType$str() {
        return "HV000245: Allowed constraint element types are FIELD and GETTER, but instead received %1$s.";
    }
    @Override
    public final AssertionError getUnsupportedConstraintElementType(final ConstrainedElementKind kind) {
        final AssertionError result = new AssertionError(String.format(getLoggingLocale(), getUnsupportedConstraintElementType$str(), kind));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void usingGetterPropertySelectionStrategy(final Class<? extends org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy> getterPropertySelectionStrategyClass) {
        super.log.logf(FQCN, DEBUG, null, usingGetterPropertySelectionStrategy$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(getterPropertySelectionStrategyClass));
    }
    protected String usingGetterPropertySelectionStrategy$str() {
        return "HV000246: Using %s as getter property selection strategy.";
    }
    protected String getUnableToInstantiateGetterPropertySelectionStrategyClassException$str() {
        return "HV000247: Unable to instantiate getter property selection strategy class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateGetterPropertySelectionStrategyClassException(final String getterPropertySelectionStrategyClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateGetterPropertySelectionStrategyClassException$str(), getterPropertySelectionStrategyClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToGetXmlSchema$str() {
        return "HV000248: Unable to get an XML schema named %s.";
    }
    @Override
    public final ValidationException unableToGetXmlSchema(final String schemaResourceName) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), unableToGetXmlSchema$str(), schemaResourceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uninitializedLocale$str() {
        return "HV000250: Uninitialized locale: %s. Please register your locale as a locale to initialize when initializing your ValidatorFactory.";
    }
    @Override
    public final ValidationException uninitializedLocale(final Locale locale) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), uninitializedLocale$str(), locale));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToLoadInstanceOfService(final String serviceName, final ServiceConfigurationError e) {
        super.log.logf(FQCN, ERROR, e, unableToLoadInstanceOfService$str(), serviceName);
    }
    protected String unableToLoadInstanceOfService$str() {
        return "HV000251: An error occurred while loading an instance of service %s.";
    }
    @Override
    public final void usingPropertyNodeNameProvider(final Class<? extends org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider> propertyNodeNameProviderClass) {
        super.log.logf(FQCN, DEBUG, null, usingPropertyNodeNameProvider$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(propertyNodeNameProviderClass));
    }
    protected String usingPropertyNodeNameProvider$str() {
        return "HV000252: Using %s as property node name provider.";
    }
    protected String getUnableToInstantiatePropertyNodeNameProviderClassException$str() {
        return "HV000253: Unable to instantiate property node name provider class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiatePropertyNodeNameProviderClassException(final String propertyNodeNameProviderClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiatePropertyNodeNameProviderClassException$str(), propertyNodeNameProviderClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void usingLocaleResolver(final Class<? extends org.hibernate.validator.spi.messageinterpolation.LocaleResolver> localeResolverClass) {
        super.log.logf(FQCN, DEBUG, null, usingLocaleResolver$str(), new org.hibernate.validator.internal.util.logging.formatter.ClassObjectFormatter(localeResolverClass));
    }
    protected String usingLocaleResolver$str() {
        return "HV000255: Using %s as locale resolver.";
    }
    protected String getUnableToInstantiateLocaleResolverClassException$str() {
        return "HV000256: Unable to instantiate locale resolver class %s.";
    }
    @Override
    public final ValidationException getUnableToInstantiateLocaleResolverClassException(final String localeResolverClassName, final Exception e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), getUnableToInstantiateLocaleResolverClassException$str(), localeResolverClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void expressionVariablesDefinedWithExpressionLanguageNotEnabled(final Class<? extends java.lang.annotation.Annotation> constraintAnnotation) {
        super.log.logf(FQCN, WARN, null, expressionVariablesDefinedWithExpressionLanguageNotEnabled$str(), constraintAnnotation);
    }
    protected String expressionVariablesDefinedWithExpressionLanguageNotEnabled$str() {
        return "HV000257: Expression variables have been defined for constraint %1$s while Expression Language is not enabled.";
    }
    protected String expressionsNotResolvedWhenExpressionLanguageFeaturesDisabled$str() {
        return "HV000258: Expressions should not be resolved when Expression Language features are disabled.";
    }
    @Override
    public final IllegalStateException expressionsNotResolvedWhenExpressionLanguageFeaturesDisabled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expressionsNotResolvedWhenExpressionLanguageFeaturesDisabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expressionsLanguageFeatureLevelNotSupported$str() {
        return "HV000259: Provided Expression Language feature level is not supported.";
    }
    @Override
    public final IllegalStateException expressionsLanguageFeatureLevelNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expressionsLanguageFeatureLevelNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logConstraintExpressionLanguageFeatureLevel(final ExpressionLanguageFeatureLevel expressionLanguageFeatureLevel) {
        super.log.logf(FQCN, DEBUG, null, logConstraintExpressionLanguageFeatureLevel$str(), expressionLanguageFeatureLevel);
    }
    protected String logConstraintExpressionLanguageFeatureLevel$str() {
        return "HV000260: Expression Language feature level for constraints set to %1$s.";
    }
    @Override
    public final void logCustomViolationExpressionLanguageFeatureLevel(final ExpressionLanguageFeatureLevel expressionLanguageFeatureLevel) {
        super.log.logf(FQCN, DEBUG, null, logCustomViolationExpressionLanguageFeatureLevel$str(), expressionLanguageFeatureLevel);
    }
    protected String logCustomViolationExpressionLanguageFeatureLevel$str() {
        return "HV000261: Expression Language feature level for custom violations set to %1$s.";
    }
    protected String invalidExpressionLanguageFeatureLevelValue$str() {
        return "HV000262: Unable to find an expression language feature level for value %s.";
    }
    @Override
    public final ValidationException invalidExpressionLanguageFeatureLevelValue(final String expressionLanguageFeatureLevelName, final IllegalArgumentException e) {
        final ValidationException result = new ValidationException(String.format(getLoggingLocale(), invalidExpressionLanguageFeatureLevelValue$str(), expressionLanguageFeatureLevelName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unknownMethodInExpressionLanguage(final String expression, final Exception e) {
        super.log.logf(FQCN, WARN, e, unknownMethodInExpressionLanguage$str(), expression);
    }
    protected String unknownMethodInExpressionLanguage$str() {
        return "HV000263: EL expression '%s' references an unknown method.";
    }
    @Override
    public final void disabledFeatureInExpressionLanguage(final String expression, final Exception e) {
        super.log.logf(FQCN, ERROR, e, disabledFeatureInExpressionLanguage$str(), expression);
    }
    protected String disabledFeatureInExpressionLanguage$str() {
        return "HV000264: Unable to interpolate EL expression '%s' as it uses a disabled feature.";
    }
}
