/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.BootstrapConfiguration;
import javax.validation.executable.ExecutableType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.SetContextClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.BootstrapConfigurationImpl;
import org.hibernate.validator.internal.xml.CloseIgnoringInputStream;
import org.hibernate.validator.internal.xml.ResourceLoaderHelper;
import org.hibernate.validator.internal.xml.XmlParserHelper;
import org.hibernate.validator.internal.xml.binding.DefaultValidatedExecutableTypesType;
import org.hibernate.validator.internal.xml.binding.ExecutableValidationType;
import org.hibernate.validator.internal.xml.binding.PropertyType;
import org.hibernate.validator.internal.xml.binding.ValidationConfigType;
import org.xml.sax.SAXException;

public class ValidationXmlParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final Map<String, String> SCHEMAS_BY_VERSION = Collections.unmodifiableMap(ValidationXmlParser.getSchemasByVersion());
    private final ClassLoader externalClassLoader;

    private static Map<String, String> getSchemasByVersion() {
        HashMap<String, String> schemasByVersion = CollectionHelper.newHashMap(3);
        schemasByVersion.put("1.0", "META-INF/validation-configuration-1.0.xsd");
        schemasByVersion.put("1.1", "META-INF/validation-configuration-1.1.xsd");
        schemasByVersion.put("2.0", "META-INF/validation-configuration-2.0.xsd");
        return schemasByVersion;
    }

    public ValidationXmlParser(ClassLoader externalClassLoader) {
        this.externalClassLoader = externalClassLoader;
    }

    public final BootstrapConfiguration parseValidationXml() {
        InputStream in = this.getValidationXmlInputStream();
        if (in == null) {
            return BootstrapConfigurationImpl.getDefaultBootstrapConfiguration();
        }
        ClassLoader previousTccl = ValidationXmlParser.run(GetClassLoader.fromContext());
        try {
            ValidationXmlParser.run(SetContextClassLoader.action(ValidationXmlParser.class.getClassLoader()));
            XmlParserHelper xmlParserHelper = new XmlParserHelper();
            in.mark(Integer.MAX_VALUE);
            XMLEventReader xmlEventReader = xmlParserHelper.createXmlEventReader(VALIDATION_XML_FILE, new CloseIgnoringInputStream(in));
            String schemaVersion = xmlParserHelper.getSchemaVersion(VALIDATION_XML_FILE, xmlEventReader);
            xmlEventReader.close();
            in.reset();
            Schema schema = this.getSchema(xmlParserHelper, schemaVersion);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new CloseIgnoringInputStream(in)));
            in.reset();
            xmlEventReader = xmlParserHelper.createXmlEventReader(VALIDATION_XML_FILE, new CloseIgnoringInputStream(in));
            ValidationConfigType validationConfig = this.unmarshal(xmlEventReader);
            xmlEventReader.close();
            BootstrapConfiguration bootstrapConfiguration = this.createBootstrapConfiguration(validationConfig);
            return bootstrapConfiguration;
        }
        catch (IOException | XMLStreamException | SAXException e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
        finally {
            ValidationXmlParser.run(SetContextClassLoader.action(previousTccl));
            this.closeStream(in);
        }
    }

    private InputStream getValidationXmlInputStream() {
        log.debugf("Trying to load %s for XML based Validator configuration.", VALIDATION_XML_FILE);
        InputStream inputStream = ResourceLoaderHelper.getResettableInputStreamForPath(VALIDATION_XML_FILE, this.externalClassLoader);
        if (inputStream != null) {
            return inputStream;
        }
        log.debugf("No %s found. Using annotation based configuration only.", VALIDATION_XML_FILE);
        return null;
    }

    private Schema getSchema(XmlParserHelper xmlParserHelper, String schemaVersion) {
        String schemaResource = SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw log.getUnsupportedSchemaVersionException(VALIDATION_XML_FILE, schemaVersion);
        }
        return xmlParserHelper.getSchema(schemaResource);
    }

    private ValidationConfigType unmarshal(XMLEventReader xmlEventReader) {
        log.parsingXMLFile(VALIDATION_XML_FILE);
        try {
            JAXBContext jc = this.run(NewJaxbContext.action(ValidationConfigType.class));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement root = (JAXBElement)this.run(Unmarshal.action(unmarshaller, xmlEventReader, ValidationConfigType.class));
            return (ValidationConfigType)root.getValue();
        }
        catch (Exception e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
    }

    private void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException io) {
            log.unableToCloseXMLFileInputStream(VALIDATION_XML_FILE);
        }
    }

    private BootstrapConfiguration createBootstrapConfiguration(ValidationConfigType config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Found property '%s' with value '%s' in validation.xml.", property.getName(), property.getValue());
            }
            properties.put(property.getName(), property.getValue());
        }
        ExecutableValidationType executableValidationType = config.getExecutableValidation();
        EnumSet<ExecutableType> defaultValidatedExecutableTypes = executableValidationType == null ? this.getValidatedExecutableTypes(null) : this.getValidatedExecutableTypes(executableValidationType.getDefaultValidatedExecutableTypes());
        boolean executableValidationEnabled = executableValidationType == null || executableValidationType.getEnabled() != false;
        return new BootstrapConfigurationImpl(config.getDefaultProvider(), config.getConstraintValidatorFactory(), config.getMessageInterpolator(), config.getTraversableResolver(), config.getParameterNameProvider(), config.getClockProvider(), this.getScriptEvaluatorFactoryClassProperty(config.getProperty()), this.getValueExtractorClassNames(config), defaultValidatedExecutableTypes, executableValidationEnabled, new HashSet<String>(config.getConstraintMapping()), properties);
    }

    private String getScriptEvaluatorFactoryClassProperty(List<PropertyType> properties) {
        return properties.stream().filter(property -> "hibernate.validator.script_evaluator_factory".equals(property.getName())).map(PropertyType::getValue).findFirst().orElse(null);
    }

    private Set<String> getValueExtractorClassNames(ValidationConfigType config) {
        HashSet<String> valueExtractorClassNames = CollectionHelper.newHashSet(config.getValueExtractor().size());
        for (String className : config.getValueExtractor()) {
            if (valueExtractorClassNames.add(className)) continue;
            throw log.getDuplicateDefinitionsOfValueExtractorException(className);
        }
        return valueExtractorClassNames;
    }

    private EnumSet<ExecutableType> getValidatedExecutableTypes(DefaultValidatedExecutableTypesType validatedExecutables) {
        if (validatedExecutables == null) {
            return null;
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        executableTypes.addAll(validatedExecutables.getExecutableType());
        return executableTypes;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private <T> T run(PrivilegedExceptionAction<T> action) throws Exception {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

