/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.HashMap;
import java.util.Map;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

public class ValidatorContextImpl
implements HibernateValidatorContext {
    private static final Log LOG = LoggerFactory.make();
    private final ValidatorFactoryImpl validatorFactory;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ExecutableParameterNameProvider parameterNameProvider;
    private ClockProvider clockProvider;
    private ScriptEvaluatorFactory scriptEvaluatorFactory;
    private boolean failFast;
    private boolean traversableResolverResultCacheEnabled;
    private final ValueExtractorManager valueExtractorManager;
    private final MethodValidationConfiguration.Builder methodValidationConfigurationBuilder;
    private final Map<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> valueExtractorDescriptors;

    public ValidatorContextImpl(ValidatorFactoryImpl validatorFactory) {
        this.validatorFactory = validatorFactory;
        this.messageInterpolator = validatorFactory.getMessageInterpolator();
        this.traversableResolver = validatorFactory.getTraversableResolver();
        this.constraintValidatorFactory = validatorFactory.getConstraintValidatorFactory();
        this.parameterNameProvider = validatorFactory.getExecutableParameterNameProvider();
        this.clockProvider = validatorFactory.getClockProvider();
        this.scriptEvaluatorFactory = validatorFactory.getScriptEvaluatorFactory();
        this.failFast = validatorFactory.isFailFast();
        this.traversableResolverResultCacheEnabled = validatorFactory.isTraversableResolverResultCacheEnabled();
        this.methodValidationConfigurationBuilder = new MethodValidationConfiguration.Builder(validatorFactory.getMethodValidationConfiguration());
        this.valueExtractorManager = validatorFactory.getValueExtractorManager();
        this.valueExtractorDescriptors = new HashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor>();
    }

    @Override
    public HibernateValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator == null ? this.validatorFactory.getMessageInterpolator() : messageInterpolator;
        return this;
    }

    @Override
    public HibernateValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver == null ? this.validatorFactory.getTraversableResolver() : traversableResolver;
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        this.constraintValidatorFactory = factory == null ? this.validatorFactory.getConstraintValidatorFactory() : factory;
        return this;
    }

    @Override
    public HibernateValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider == null ? this.validatorFactory.getExecutableParameterNameProvider() : new ExecutableParameterNameProvider(parameterNameProvider);
        return this;
    }

    @Override
    public HibernateValidatorContext clockProvider(ClockProvider clockProvider) {
        this.clockProvider = clockProvider == null ? this.validatorFactory.getClockProvider() : clockProvider;
        return this;
    }

    @Override
    public HibernateValidatorContext addValueExtractor(ValueExtractor<?> extractor) {
        ValueExtractorDescriptor descriptor = new ValueExtractorDescriptor(extractor);
        ValueExtractorDescriptor previous = this.valueExtractorDescriptors.put(descriptor.getKey(), descriptor);
        if (previous != null) {
            throw LOG.getValueExtractorForTypeAndTypeUseAlreadyPresentException(extractor, previous.getValueExtractor());
        }
        return this;
    }

    @Override
    public HibernateValidatorContext failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public HibernateValidatorContext allowOverridingMethodAlterParameterConstraint(boolean allow) {
        this.methodValidationConfigurationBuilder.allowOverridingMethodAlterParameterConstraint(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext allowMultipleCascadedValidationOnReturnValues(boolean allow) {
        this.methodValidationConfigurationBuilder.allowMultipleCascadedValidationOnReturnValues(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext allowParallelMethodsDefineParameterConstraints(boolean allow) {
        this.methodValidationConfigurationBuilder.allowParallelMethodsDefineParameterConstraints(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext enableTraversableResolverResultCache(boolean enabled) {
        this.traversableResolverResultCacheEnabled = enabled;
        return this;
    }

    public Validator getValidator() {
        return this.validatorFactory.createValidator(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.parameterNameProvider, this.clockProvider, this.scriptEvaluatorFactory, this.failFast, this.valueExtractorDescriptors.isEmpty() ? this.valueExtractorManager : new ValueExtractorManager(this.valueExtractorManager, this.valueExtractorDescriptors), this.methodValidationConfigurationBuilder.build(), this.traversableResolverResultCacheEnabled);
    }
}

