/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.privilegedactions;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class GetAnnotationParameters
implements PrivilegedAction<AnnotationParameters> {
    private static final Log LOG = LoggerFactory.make();
    private final Annotation annotation;

    public static GetAnnotationParameters action(Annotation annotation) {
        return new GetAnnotationParameters(annotation);
    }

    private GetAnnotationParameters(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public AnnotationParameters run() {
        Method[] declaredMethods = this.annotation.annotationType().getDeclaredMethods();
        HashMap<String, Object> parameters = CollectionHelper.newHashMap(declaredMethods.length);
        for (Method m : declaredMethods) {
            if (m.isSynthetic()) continue;
            m.setAccessible(true);
            String parameterName = m.getName();
            try {
                parameters.put(m.getName(), m.invoke((Object)this.annotation, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw LOG.getUnableToGetAnnotationParameterException(parameterName, this.annotation.getClass(), e);
            }
        }
        return new AnnotationParameters(parameters);
    }

    public static class AnnotationParameters
    implements Serializable {
        private final Map<String, Object> parameters;

        private AnnotationParameters(Map<String, Object> parameters) {
            this.parameters = CollectionHelper.toImmutableMap(parameters);
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public <T> T getMandatoryParameter(String parameterName, Class<T> type) {
            Object parameter = this.parameters.get(parameterName);
            if (parameter == null) {
                throw LOG.getUnableToFindAnnotationParameterException(parameterName, null);
            }
            if (!type.isAssignableFrom(parameter.getClass())) {
                throw LOG.getWrongParameterTypeException(type, parameter.getClass());
            }
            return (T)parameter;
        }

        public <T> T getParameter(String parameterName, Class<T> type) {
            Object parameter = this.parameters.get(parameterName);
            if (parameter == null) {
                return null;
            }
            if (!type.isAssignableFrom(parameter.getClass())) {
                throw LOG.getWrongParameterTypeException(type, parameter.getClass());
            }
            return (T)parameter;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('{');
            sb.append("parameters=").append(this.parameters);
            sb.append('}');
            return sb.toString();
        }
    }
}

