/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public abstract class AnnotationDef<C extends AnnotationDef<C, A>, A extends Annotation> {
    private static final Log LOG = LoggerFactory.make();
    protected final Class<A> annotationType;
    protected final Map<String, Object> parameters;
    protected final Map<String, List<AnnotationDef<?, ?>>> annotationsAsParameters;
    private final Map<String, Class<?>> annotationsAsParametersTypes;

    protected AnnotationDef(Class<A> annotationType) {
        this.annotationType = annotationType;
        this.parameters = new HashMap<String, Object>();
        this.annotationsAsParameters = new HashMap();
        this.annotationsAsParametersTypes = new HashMap();
    }

    protected AnnotationDef(AnnotationDef<?, A> original) {
        this.annotationType = original.annotationType;
        this.parameters = original.parameters;
        this.annotationsAsParameters = original.annotationsAsParameters;
        this.annotationsAsParametersTypes = original.annotationsAsParametersTypes;
    }

    private C getThis() {
        return (C)this;
    }

    protected C addParameter(String key, Object value) {
        this.parameters.put(key, value);
        return this.getThis();
    }

    protected C addAnnotationAsParameter(String key, AnnotationDef<?, ?> value) {
        this.annotationsAsParameters.compute(key, (k, oldValue) -> {
            if (oldValue == null) {
                return Arrays.asList(value);
            }
            ArrayList resultingList = CollectionHelper.newArrayList(oldValue);
            resultingList.add(value);
            return resultingList;
        });
        this.annotationsAsParametersTypes.putIfAbsent(key, value.annotationType);
        return this.getThis();
    }

    protected A createAnnotationProxy() {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(this.annotationType);
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            annotationDescriptor.setValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.annotationsAsParameters.entrySet()) {
            annotationDescriptor.setValue(entry.getKey(), this.toAnnotationParameterArray((List)entry.getValue(), this.annotationsAsParametersTypes.get(entry.getKey())));
        }
        try {
            return AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw LOG.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
    }

    private <T> T[] toAnnotationParameterArray(List<AnnotationDef<?, ?>> list, Class<T> aClass) {
        return list.stream().map(AnnotationDef::createAnnotationProxy).toArray(n -> (Object[])Array.newInstance(aClass, n));
    }

    protected <T> T toAnnotationParameter(AnnotationDef<?, ?> annotationDef, Class<T> aClass) {
        return (T)annotationDef.createAnnotationProxy();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('{');
        sb.append("annotationType=").append(StringHelper.toShortString(this.annotationType));
        sb.append(", parameters=").append(this.parameters);
        sb.append('}');
        return sb.toString();
    }
}

