/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.time;

import java.lang.annotation.Annotation;
import java.time.Clock;
import java.time.temporal.TemporalAccessor;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public abstract class AbstractJavaTimeValidator<C extends Annotation, T extends TemporalAccessor & Comparable<? super T>>
implements ConstraintValidator<C, T> {
    private static final Log LOG = LoggerFactory.make();

    public boolean isValid(T value, ConstraintValidatorContext context) {
        Clock reference;
        if (value == null) {
            return true;
        }
        try {
            ClockProvider clockProvider = context.getClockProvider();
            reference = clockProvider.getClock();
        }
        catch (Exception e) {
            throw LOG.getUnableToGetCurrentTimeFromClockProvider(e);
        }
        int result = ((Comparable)value).compareTo(this.getReferenceValue(reference));
        return this.isValid(result);
    }

    protected abstract T getReferenceValue(Clock var1);

    protected abstract boolean isValid(int var1);
}

